+++
date = "2015-04-06T21:52:00-04:00"
discipline = "Soprano"
lastmod = "2015-04-06T21:52:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428371404357/AnnaNetrebko-pc-Ruven-Afanador-16.jpg.jpg"
primary_image_credit = "Ruven Afanador"
publishDate = "2015-04-06T21:52:00-04:00"
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/bayerische-staatsoper.md","scene/companies/royal-opera-house.md","scene/companies/san-francisco-opera.md","scene/companies/lyric-opera-of-chicago.md","scene/companies/wiener-staatsoper.md","scene/companies/opra-national-de-paris.md","scene/companies/opernhaus-zurich.md"]
slug = "anna-netrebko"
title = "Anna Netrebko"
website = "http://www.annanetrebko.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/pages/Anna-Netrebko/105861839447290"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/AnnaNetrebko"
+++

<p>
	Anna Netrebko has redefined what it means to be an opera star and in the process she has become one of the most acclaimed and widely-recognized classical singers in the world today. Regularly headlining productions at virtually every leading opera house across the globe, the Russian soprano has been hailed by the <em>Associated Press</em> as "the reigning new diva of the early 21st century." In 2007 she became the first classical musician to be selected as one of the <em>Time </em>100, <em>Time</em> magazine's list of the most influential people in the world. Her beautiful, dark, distinctive voice and her elegant and alluring stage presence have prompted critics to describe her as "Audrey Hepburn with a voice" and "a singer who simply has it all: a voice of astounding purity, precision, and scope, extensive dynamic and tonal range, imagination, insight, and wit—all combined with a dazzling charisma that makes it all but impossible to look away when she is performing" (<em>San Francisco Chronicle</em>).
</p>
<p>
	Since her triumphant Salzburg Festival debut in 2002 as Donna Anna in Mozart's<em>Don Giovanni</em>, Netrebko has gone on to appear with nearly all the world's great opera companies, including the Metropolitan Opera, San Francisco Opera, Lyric Opera of Chicago, London's Royal Opera House, Milan's Teatro alla Scala, Vienna State Opera, Paris Opera, Zurich Opera, Berlin State Opera, and Munich's Bavarian State Opera. She frequently returns to the Kirov Opera at the Mariinsky Theater in St. Petersburg (where she made her stage debut as Susanna in Mozart's <em>Le nozze di Figaro</em>) to collaborate with her longtime mentor, conductor Valery Gergiev. As well as Mozart's Susanna, Netrebko's other signature roles past and present include Puccini's Mimì (<em>La bohème</em>) and Manon Lescaut; Verdi's Violetta (<em>La traviata</em>), Lady Macbeth (<em>Macbeth</em>) and Giovanna d'Arco; Bellini's Giulietta (<em>I Capuleti e i Montecchi</em>), Elvira (<em>I puritani</em>), and Amina (<em>La sonnambula</em>); Mozart's Donna Anna (<em>Don Giovanni</em>); Donizetti's Norina (<em>Don Pasquale</em>), Adina (<em>L'elisir d'amore</em>), Lucia (<em>Lucia di Lammermoor</em>), and Anna Bolena; the title role in Massenet's <em>Manon</em>; Juliette in Gounod's<em> Roméo et Juliette</em>; and Tchaikovsky's Tatiana (<em>Eugene Onegin</em>) and Iolanta.
</p>
<p>
	Netrebko also appears extensively in concerts throughout the world, both in famous music venues such as New York's Carnegie Hall and in arenas in front of tens of thousands of people. Her outdoor concerts – in which she has shared the stage with artists such as Plácido Domingo and Dmitri Hvorostovsky at places ranging from Berlin's Waldbühne to Moscow's Red Square – are often internationally televised events. She is a fixture at the Salzburg Festival and has headlined the famous Last Night of the Proms in London. Netrebko frequently appears in recital with the world's leading artists, including Daniel Barenboim.
</p>
<p>
	Following a season that saw the soprano venture into bold new repertoire with the release of her <em>Verdi</em> recording, she continues to broaden her horizons over the coming year. This season, she makes her American role debut as Lady Macbeth at the Metropolitan Opera, and with her October 11 performance she launches the house's celebrated <em>Live in HD</em> season of transmissions to movie theaters worldwide. She returns to the Met early in the New Year to star in a new staging of Tchaikovsky's <em>Iolanta</em>, which will be broadcast <em>Live in HD</em> on Valentine's Day. Other highlights of her season include her portrayal of Mimì opposite Joseph Calleja's Rodolfo in <em>La bohème</em> at Covent Garden and her return to the title role in <em>Anna Bolena</em> at Zurich Opera and Vienna State Opera. Her June 10 performance of <em>La bohème</em> at the Royal Opera House will be broadcast to cinemas across the UK and Europe. In concert this season Netrebko makes her role debut as Sylva Varescu in Kálmán's <em>Die Csárdásfürstin</em> with Staatskapelle Dresden; sings Strauss's <em>Four Last Songs</em> with the Staatskapelle Berlin and Orchestre National de France; performs "Verdi and Verismo" arias at Barcelona's Palau de la Música Catalana, Mexico City's Palacio Bellas Artes, and Guadalajara's Teatro Diana; joins the Orchestra of the Accademia Nazionale di Santa Cecilia for selections from <em>Macbeth</em>; gives a recital at the Vilar Performing Arts Center in Colorado; revisits <em>Iolanta</em> on tour in Lucerne, Copenhagen, Monte Carlo, and London; and stars in a gala concert at Salzburg's Whitsun Festival.
</p>
<p>
	Anna Netrebko boasts an extensive discography that includes solo albums, complete opera recordings, and concert repertoire. Her solo discs for Deutsche Grammophon – <em>Opera Arias</em>, <em>Sempre Libera</em>,<em> Russian Album</em>, <em>Souvenirs</em>, <em>In the Still of Night</em>, <em>Anna Netrebko: Live at the Metropolitan Opera, </em>and <em>Anna Netrebko – Verdi – </em>have all been bestsellers, as have her full-length recordings of <em>La traviata</em>,<em>Le nozze di Figaro</em>, <em>La bohème</em>, <em>I Capuleti e i Montecchi</em>, <em>Giovanna d'Arco</em>, Britten's<em>War Requiem, </em>and the <em>Stabat Mater</em>s of both Pergolesi and Rossini. Highlights from Netrebko's videography include DVD or Blu-ray discs of <em>Ruslan and Lyudmila</em>, <em>Betrothal in a Monastery</em>, <em>La traviata</em>, <em>Le nozze di Figaro</em>, <em>I puritani</em>,<em>Manon</em>, <em>Lucia di Lammermoor</em>, <em>Don Pasquale</em>, <em>Anna Bolena</em> and <em>Eugene Onegin</em>; a feature film release of <em>La bohème </em>directed by Robert Dornhelm; and a DVD of music videos, titled <em>Anna Netrebko: The Woman, The Voice</em>. Her CD <em>Duets</em>, with tenor Rolando Villazón, set a record for the best European debut for a classical album, climbing to the top of the pop charts in several countries.
</p>
<p>
	Netrebko sang the Olympic Hymn live at the internationally televised opening ceremony of the 2014 Olympic Winter Games in Sochi. In 2007, the year she was named to the <em>Time</em> 100 list, she serenaded film director Martin Scorsese on the CBS broadcast of the 30th Annual Kennedy Center Honors, and the following year she performed on the BBC telecast of the Classical BRIT Awards alongside Andrea Bocelli. Netrebko has been profiled in numerous magazines, including <em>Vogue</em>,<em>Vanity Fair</em>, and <em>Town &amp; Country</em>. She has also been featured on television shows such as ABC's <em>Good Morning America</em>, NBC's <em>The</em> <em>Tonight Show with Jay Leno</em>, CBS's <em>60 Minutes</em>, CNN's <em>Revealed</em>, and Germany's <em>Wetten, dass..? </em>Documentaries about her have been televised in Austria, Denmark, Germany, Russia, and Switzerland.
</p>
<p>
	Anna Netrebko's other honors and awards include Grammy nominations for her recordings <em>Violetta</em> and <em>Russian Album</em>; <em>Musical America</em>'s 2008 "Musician of the Year"; Germany's prestigious Bambi Award; the UK's Classical BRIT Awards for "Singer of the Year" and "Female Artist of the Year"; and ten German ECHO Klassik awards. In 2005 she was awarded the Russian State Prize (the country's highest award in the field of arts and literature), and in 2008 she was given the title of "People's Artist of Russia."
</p>
<p>
	Born in 1971 in Krasnodar, Russia, Anna Netrebko studied vocal performance at the St. Petersburg Conservatory. A passionate advocate for children's causes, she supports a number of charitable organizations, including SOS-Kinderdorf International and the Russian Children's Welfare Society. She is a global ambassador for Chopard jewelry and Austrian Airlines. She became a dual citizen of Austria in 2006.
</p>
