+++
date = "2017-01-21T16:49:00+00:00"
discipline = "Composer"
lastmod = "2017-01-21T16:51:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485017378087/2017-01-21---Analia-Lludgar.jpg.jpg"
publishDate = "2017-01-21T16:49:00+00:00"
related_companies = ["scene/companies/esprit-orchestra.md"]
slug = "analia-lludgar"
title = "Analia Lludgar"
website = "http://www.analiallugdar.net/"
[[social_media]]
platform = "Soundcloud"
template = "social-media"
url = "https://soundcloud.com/analia-llugdar"
+++

Born in Argentina, composer Analia Llugdar initially studied piano and composition at the Cordoba National University, Argentina. She continued her composition studies at the University of Montréal, where she completed a Master’s degree with José Evangelista and a Ph.D. in Music composition with Denis Gougeon.

Drawing upon literature, history, dance, theater and plastic arts, Analia Llugdar creates a contemporary reflection upon which, as a goldsmith working with sounds, she brings to the forefront her research for a new resonance through her mastery of instrumental techniques and the eloquence of the form. For ever renewed, her interest for the multiplicity of concourses allows her to create multidisciplinary works on subjects such as aboriginal cultures, a Jean de La Fontaine fable, a radio essay by Antonin Artaud, a Juan Gelman poem or world events.

With the invention of timbres arousing from acoustic instruments as her inspiration, her catalogue of music includes some 40 pieces for voice, orchestra, chamber music, solo instrument, ballet, opera and mixed music. In her music, we can hear: timbre, density, energy, movement, speed, amplitude and fineness (Juana, 2012); illusion, surrealism, imagination, utopia and chimera for orchestra (Quimera, 2012); glottal stops, lacerated phonation, use of shouting as the air for a flute and electronic music (La Machi, 2010); musical theater (La Faim Artaud, 2007); construction, densification and spatialization of masses (Le Chêne et le roseau, 2005); attacks-resonance ratios (Tricycle, 2004); social critic for a soprano, pots and flutes (Sentir de cacerolas, 2002). Imagined as such, the composition of complex textures in a toned-down language provides the works with a more profound, refined and poetic esthetic.

Internationally renowned, Analia Llugdar’s creations have been played throughout the years by collectives such as Ensemble contemporain de Montréal, ensemble S.I.C, I Solisti del Vento, Les Enfants Terribles, L’Itinéraire, Nouvel Ensemble Moderne, Orchestre symphonique de Laval, Tambuco, Molinari string quartet, Quasar saxophone quartet, Trio Fibonacci and by soloists like Julie Bouliane (mezzo-soprano), Jacynthe Riverin (pianist), Vincent Ranallo (baryton) Donatienne Michel Dansac (soprano), Krisztina Szabo (mezzo-soprano), Julie-Anne Derome (violon), Gabriel Prynn (violoncelle). Her works have been played at several festivals in America, Asia and Europe, including Cervantino (Mexico), the Festival international du Domaine Forget, Montréal/Nouvelles Musiques, Présence China Concerts (Shanghai), Huddersfield Contemporary Music Festival, Journées GRAME (Lyon), the Biennale Musiques en Scène (Lyon), la Société internationale de musique contemporaine (Flandre), the Festival belge de la flûte (Bruxelles), the Festival MANCA (Nice), TRANSIT (Louvain) and Voix nouvelles (Royaumont).

She has participated in several residencies for artists among which we can mention: Jiwar in Barcelona, Bellagio Center in Italy, Voix nouvelles and Aleph Forum in France and Electroacoustic seminar in Madrid.

She has received several awards for her work throughout her career, including the Sir-Ernest-McMillan award from SOCAN, first prize in the chamber music category at the 15th CBC/Radio-Canada national competition for young compo­sers, the Jeunesses musicales du Canada award and the Grand Prix of the Canada Council for the Arts. Also, she has received the Contemporary Music Québec-Flandres Prize (2007), the Jules Léger Prize (2008), the “Prix Opus du
composi­teur de l’année” (2008-2009) du Conseil québécois de la musique and the Victor-Martyn-Lynch-Staunton prize from the Canada Council for the Arts.

Analia Lludgar is a member of the Canadian Music Centre, the Canadien Ligue of Composers, the artistic committee of the Société de musique contemporaine du Québec (SMCQ), the Society of dramatic authors and composers (SACD) and the Society of Composers, Authors and Music Publishers of Canada (SOCAN). She receives the support of the Canadian Arts Council and the Québec Conseil des arts et des lettres.


