+++
date = "2018-06-09T21:00:00-04:00"
lastmod = "2018-06-09T21:33:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1528592346381/S5PfTFKS_400x400.jpg.jpg"
publishDate = "2018-06-09T21:33:00-04:00"
related_people = ["scene/people/ashley-riches.md","scene/people/jonathan-lemalu.md"]
slug = "the-grange-festival"
title = "The Grange Festival"
type_of_company = "Festival"
website = "https://thegrangefestival.co.uk/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/TheGrangeFestival/"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/grangefestival"
[[social_media]]
platform = "Instagram"
template = "social-media"
url = "https://www.instagram.com/thegrangefestival/"
[[social_media]]
platform = "Youtube"
template = "social-media"
url = "https://www.youtube.com/channel/UC4rcyykXcv1PkrePpnN90RQ"
+++

Not since Thomas Beecham created his own international opera company in 1916, paid for with the proceeds from sales of Beecham’s Powders, has a new UK opera festival of such scale and ambition been born. It has quickly emerged phoenix-like to present world-class performance in the heart of Hampshire.

Number 5, Via de’ Benci in Florence is one of the least known and most important addresses in the history of opera. It was here, Palazzo Bardi, the home of Count Giovanni Bardi, that opera was invented in the 1580s. The Count hosted regular meetings of the greatest thinkers and writers of the day, including the astronomer Galileo Galilei’s father, under the title accorded to them later, the Florentine Camerata. They devised their own interpretation of how Greek tragedy was performed: in their view, mostly sung or recited on a tone, and they laid out the basic rules and structure of communicating drama through accompanied song, which quickly developed into a form recognisable to us today as opera. Opera, of course, means both the labour of making and performing and the finished artefact of a composed musical drama.

At the same time, in another Italian city, Ferrara, other events were taking place which were also to prove fundamental to what opera became. The court there established a group of professional women singers and players, the Concerto delle Donne, who became some of the most celebrated performers of the time, throughout Italy. They were copied in other cities and courts. These women were virtuosic, well paid, and very highly regarded.

So from the outset, opera established the notions of professionalism, story-telling, inclusiveness on an equal level of both sexes as performers, the primacy of words over music, and, very quickly, the absorption into the world of musical drama all the arts: visual, physical, aural.

Scroll forward to any familiar scenes in opera which you might know – Mimi’s hands being warmed by Rodolfo; Otello being revved up by Iago to uncontrollable bloodlust; the ghost of the Commendatore driving Don Giovanni to the flames of hell; Madam Butterfly preparing herself for suicide rather than submitting to life as a geisha having conceded that her American Officer will never return; Carmen seducing, taunting, fascinating every man she chooses to focus on; Barbarina singing sublimely while desperately looking for a pin; Isolde and Tristan singing of their perfect love finding fulfilment in the realm of dreams; – these and countless others tell heart-breaking stories of love, betrayal, loss, revenge, despair, often with women centre stage, and words and music touching every core of our being: the ideals identified in 16th century Florence.

The telling of powerful stories, and not necessarily always tragic ones, lies at the heart of what a festival of opera is about. Add to that the setting, the sensuality of the whole experience, so that what we see, hear, taste, touch and even smell all play their part, and you have with your visit to The Grange as powerful a mix as it is possible to imagine. But I think there is more. The people: the temporary community of highly skilled performers, technicians, helpers, volunteers and festival staff who are all working towards the same end, and, I hope, equally determined to have a good time while doing it. And then there is the visiting audience – old and new friends, locals, visitors, another temporary community who invest in their visits a lot of time, and money, and expectation. And add to them those who choose to be even more connected to this festival, by donating as members or funders. I fancifully imagine The Grange as a latter-day Delphi, the navel of country-house opera. You can choose which of the others is the heart, or the mind or the soul, but let us call The Grange our operatic navel, our Omphalos. Votive offerings are very gratefully received.

The need to separate from the past and start afresh has led to the new name, The Grange Festival. This is designed both to celebrate the place and also promote a wider range of activities in the opera house. In our first season we presented two enticing evenings which were not staged opera. There has been expressed a strong and widespread desire for ballet in addition to the staple fare of opera. In 2018, we will put on two evenings of world class ballet. We are already commissioning a new opera for inclusion in our festival programme a few years hence. We will be caretakers of its composition and nurture its development. Details of this venture will be revealed as soon as we feel we can. The idea of an autumn season is not entirely new to The Grange, but one I am keen to explore. Our first season, 2017, happened to coincide with the Bi-Centennial of the death of a certain local author, but one who also happens to be one of the most widely read and admired in the world. In September 2017, we presented performances of ‘Mansfield Park’ the opera by Jonathan Dove after commissionning him to provide a new orchestral score from the original piano accompaniment. This will be the central event of a more substantial September season. And there is also an embryonic plan to introduce drama to the Grange theatre.

None of this extra activity must dilute or diminish the core opera festival in June and July. This will always remain the main event, around which all else will revolve.

I have been intensely involved for much of my professional life in teaching and giving opportunities to younger performers – the next generation, if you like. It seems both natural and essential that all manner of scheme both during the Festival and throughout the rest of the year should be developed to nurture the stars of the future. We will have a well-worked understudy scheme for the operas and showcase their work in masterclasses and workshops on performance days. In addition, I am keen to offer apprenticeships in the multiple crafts on which opera depends. We also want to send these young performers into prisons, adult education colleges, hospitals and hospices – indeed anyway where their well-focused energy can make a difference. I have been lucky to sing in hospices, in teenage penitentiaries in America, and, of course, in many schools. It’s always completely unpredictable, scary and not always successful. But usually something amazing happens – an instant rap, or a speech of disarming power and honesty. I always feel rhythm is the most telling way to get anybody to communicate through music. Once that has been unlocked, tunes and words and whatever else start spilling out. I feel everybody has rhythm inside of them, even if they claim to be tone-deaf. Just hear what comes naturally on football terraces. Taking a deep breath and yelling out a well-known sung taunt to the opposition team can be a truly liberating experience. Pretty operatic stuff, in fact.

The choice of operas we will present at The Grange will not be based on any clever scheme for each festival, but be as varied as possible, and be always tried and tested masterpieces, apart from the new one, of course. That will always be a thrilling and somewhat daring leap into the unknown, but done as well as we can possibly do it.

2018 is a season of fun, wit, brilliance and humour. We open, though, not with an opera, but with its sister art, dance – a first, not just for us, but for the whole country. The buzz around this initiative has been palpable. For the stage at The Grange to be filled with the extraordinary talents of some of the country’s most admired dancers from the Royal Ballet and the Wayne McGregor company is the stuff of dreams. I urge you to take the plunge if this would not normally be top of your list. Dance at this level communicates at a spiritual level, creating images and conveying ideas and feelings of breath-catching power.

And then we offer three operas and a Broadway operetta. Agrippina is Handel at his delicious best. A great showcase not only for one of our associate orchestras, The Academy of Ancient Music, but also for a cast fully immersed in the nuances and verve of this wonderful music. For The Barber of Seville, we welcome Rossini stylist David Parry and a truly starry international cast. And then there is Mozart – perfect for The Grange and elegantly poised between Handel and Rossini. Operatic legend John Copley returns to direct The Abduction from the Seraglio in all its exotic quirky entertaining brilliance. We end with a celebration of the genius of Leonard Bernstein. European operetta meets south American dance rhythms via a host of other musical influences and with a Broadway/West End cast to die for. Candide was written exactly at the same time as West Side Story. If you love the latter, I suspect you might enjoy the former! We are thrilled to welcome back our other associate orchestra, the Bournemouth Symphony Orchestra, for all these other shows.
