+++
date = "2015-09-23T12:45:00-04:00"
lastmod = "2015-09-23T12:45:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1443026708145/SalzburgFestivalLogo.jpg.jpg"
publishDate = "2015-09-23T12:45:00-04:00"
related_people = ["scene/people/johan-botha.md","scene/people/peter-mattei.md","scene/people/daniel-brenna.md","scene/people/johan-reuter.md","scene/people/kristine-opolais.md","scene/people/waltraud-meier.md","scene/people/yannick-nezet-seguin.md","scene/people/thomas-hampson.md","scene/people/andrew-staples.md","scene/people/lydia-teuscher.md","scene/people/richard-croft.md","scene/people/joseph-calleja.md","scene/people/stephen-gadd.md","scene/people/juan-diego-florez.md","scene/people/anna-devin.md","scene/people/sarah-tynan.md","scene/people/ludovic-tezier.md","scene/people/christian-gerhaher.md","scene/people/russell-thomas.md","scene/people/david-soar.md","scene/people/steven-cole.md","scene/people/vito-priante.md","scene/people/daniela-barcellona.md","scene/people/audrey-luna.md","scene/people/angela-brower.md","scene/people/johannes-weisser.md","scene/people/claudia-boyle.md","scene/people/massimo-cavalletti.md","scene/people/simon-shibambu.md","scene/people/ekaterina-semenchuk.md","scene/people/gabor-bretz.md","scene/people/colin-balzer.md","scene/people/sophie-bevan.md","scene/people/tomasz-konieczny.md","scene/people/elena-tsallagova.md","scene/people/vladimir-jurowski.md","scene/people/artur-rucinski.md","scene/people/marienicole-lemieux.md","scene/people/joshua-guerrero.md","scene/people/karen-cargill.md","scene/people/angela-gheorghiu.md","scene/people/ksenia-dudnikova-.md","scene/people/sir-john-tomlinson.md","scene/people/christopher-maltman.md","scene/people/lawrence-brownlee.md","scene/people/ferruccio-furlanetto.md","scene/people/saimir-pirgu.md","scene/people/violeta-urmana.md","scene/people/krassimira-stoyanova.md","scene/people/ivan-magri.md","scene/people/iestyn-davies.md","scene/people/bejun-mehta.md","scene/people/michael-spyres.md","scene/people/annalisa-stroppa.md","scene/people/edith-wiens.md","scene/people/peter-kellner.md","scene/people/dmitry-korchak.md","scene/people/julia-jones.md","scene/people/alan-opie.md","scene/people/rosa-feola.md","scene/people/jane-henschel.md","scene/people/malin-bystrm.md","scene/people/michael-volle.md","scene/people/laurent-naouri.md","scene/people/gino-quilico.md","scene/people/juan-sancho.md","scene/people/tanja-ariane-baumgartner.md","scene/people/elina-garanca.md","scene/people/julien-behr.md","scene/people/wilhelm-schwinghammer.md","scene/people/onay-kose.md","scene/people/francesco-meli.md","scene/people/kostas-smoriginas.md","scene/people/piotr-beczala.md","scene/people/erik-anstine.md"]
slug = "salzburg-festival"
title = "Salzburg Festival"
type_of_company = "Opera Festival"
website = "http://www.salzburgerfestspiele.at/summer"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/salzburg.festival?fref=ts"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/SbgFestival"
+++

The Salzburg Festival was inaugurated on August 22, 1920, when Hugo von Hofmannsthal’s morality play Jedermann was premiered on the Domplatz, directed by Max Reinhardt. Since that time, the Salzburg Festival has established itself as the most important festival for opera, drama and concerts.

THE FESTIVAL IDEA

The birth hour of the Salzburg Festival is generally stated as 22 August 1920 when Hugo von Hofmannsthal’s morality play Jedermann was first performed on the Domplatz (Cathedral Square) in the staging by Max Reinhardt. 

The origins, however, go back much further. The first opera ever to be performed north of the Alps probably took place in Salzburg. Prestigious presentations of music and theatre were given with great extravagance at the princely and archiepiscopal court in Salzburg; the people were captivated by the many sacred and secular plays. Until Mozart’s time dramas and singspiels were performed at the venerable Salzburg University and enjoyed great public interest; and Salzburg Cathedral had always been the scene of presentations of magnificent church music as well as church festivities which were celebrated with processions. 

The dramatic spectrum in Salzburg extends from the mystery and passion plays of the Middle Ages, courtly Baroque festivities to the time when middle-class theatre traditions became established. Wolfgang Amadé Mozart was born on 27 January 1756 into this dense artistic atmosphere. From 1842, when in the presence of the sons of the composer, the Mozart Monument was ceremoniously unveiled, thus also laying the foundation stone for revering the genius loci, the idea was repeatedly mooted of organising regular Mozart music festivals in Salzburg. In 1877 the Wiener Philharmoniker (Vienna Philharmonic) accepted an invitation from the International Mozart Foundation to come to Salzburg for a music festival and performed here for the first time outside Vienna. In 1887 the conductor Hans Richter spoke in the same context in favour of an annual Mozart festival based on the model of Bayreuth.

In 1917, following on from the idea formulated at the end of the 19th century to hold a regular Mozart festival in Salzburg, the association calling itself Salzburg Festspielhaus-Gemeinde was founded thanks to the initiative of Friedrich Gehmacher and Heinrich Damisch in Vienna in order to raise funds for building a festival house. The idea of founding a festival in Salzburg had in the meantime already been taken up by other circles. The poet Hermann Bahr was committed to the idea. Max Reinhardt, who had begun his career at the Salzburg Stadttheater (nowadays the Landestheater) and in 1918 acquired Schloss Leopoldskron, submitted a relevant Memorandum for the Building of a Festival House in Hellbrunn in 1917 in Vienna. In 1919 Hugo von Hofmannsthal published a draft programme for the Salzburg Festival. Thus the festival idea, which had originated on the initiative of the Salzburg middle-class – probably Salzburg’s most successful and sustainable civic initiative – received its intellectual superstructure from its influential protagonists in Vienna. 
After the performances of Hofmannsthal’s Jedermann, the Salzburg Festival quickly became established also internationally through the participation of the stage designer Alfred Roller, the composer Richard Strauss and the conductor Franz Schalk, despite the insecure economic situation and initially without support from public subsidies. In particular from 1933, when the Thousand Mark Ban was imposed by Hitler, which meant that German guests stayed away, a counterpart to Bayreuth was proclaimed in Salzburg. The festival managed to attract wealthy Western Europeans and Americans to Salzburg, “with the anti-Fascist Arturo Toscanini as the world famous attraction” (Ernst Hanisch quoting from Heinz Dopsch, Geschichte der Stadt Salzburg, 1996). Nevertheless, this was only for a short time.

TOPOI

The chequered history of the festival can be described vividly showing the ambivalent features, the breaks and the continuities. Ambivalence is most obvious between the poles of tradition and modern because the Salzburg Festival positioned itself as “an anti-modern product of modernity” (Georg Kreis, Das Festspiel, 1991), in an antagonism of bourgeoisie and progressiveness, conservative Catholicism or rather national new definition and a newly aroused cosmopolitanism, as well as a new orientation with regard to the future (cf. Michael Steinberg, Ursprung und Ideologie der Salzburger Festspiele 1890–1938, 2000). The attempt to bridge this ambivalence between tradition and modern has repeatedly sparked off efforts for the festival idea and also criticism of it. 
Initially the festival idea was based on the desire to establish outstanding artistic events of the highest standard in a close relationship with the cultural tradition of Austria, to the genius loci and to the special scenery of a Baroque city. After the turmoil of the First World War and in the general lack of orientation, the founding of the festival was intended to support the creation of a new Austrian identity, whereby by referring back to tradition, a cultural restoration took place. The statements made by the founders of the festival move between these poles: “Organising a musical and theatrical festival in Salzburg means reviving ancient living traditions in a new way; it means: doing things in a new way in ancient, meaningful and exquisite places, what was always done there […].” (Hugo von Hofmannsthal, Festspiele in Salzburg, 1921)

“The festive, holiday-like, unique features that all art has and that even theatre in the time of the Ancient Greeks had and also at the time when it was still in the cradle of the Catholic church, that has to be given back to theatre.” (Max Reinhardt to Ferdinand Künzelmann, 21 July 1918)
By reflecting on the magnificent cultural heritage a platitude of Austrian cultural history and cultural policy is referred to, which does, however, represent an extremely complex phenomenon. Both the interwar years as well as the post-war years are characterised by this phenomenon. Even after the horrors of Nazi atrocities, art and culture served as a catalyst so as to compensate for a reduced national sense of self-esteem. 
At the same time the Salzburg Festival was intended as a project against “the crisis, the crisis of meaning, the loss of values, the crisis of identity of the individual human being as well as of entire nations” (Helga Rabl-Stadler). In the middle of the First World War the resolve matured to reconcile the nations who were warring against each other by means of a festival that would give them a unifying aim. That is why peace and the belief in Europe are at the centre of the first “Appeal for a Plan for a Salzburg Festival” (1919), incomparably formulated by Hugo von Hofmannsthal: “Europeanism that fulfilled and enlightened the period from 1750 to 1850.” Which other festival can or must fulfil such a founding mission that is valid for all time?

It is also not by chance that Reinhardt’s and Hofmannthal’s festival idea was sparked off by Salzburg. Far away from the big cities, away from the worries of day-to-day life, the intention was to establish the festival as a place of pilgrimage, theatre as a place of refuge. “The restlessness of our time, the difficulties caused by daily events take on such dimensions in the big city, oppress us and burden us to such an extent that in the evenings we cannot free ourselves of the worries of the day as we would wish. The play as such can neither be presented nor received. In the big city we cannot celebrate true festivities with the heart.” (Max Reinhardt, Festliche Spiele, 1935)

Besides being anti-modern, a feeling of anti-metropolis also characterised this special festival, which was also intended to bring people together as an overall European project. The big wide world was to be brought into the small city, whereby tangible economic and touristic considerations also played a role, resulting in Salzburg becoming stylised as “the heart of the heart of Europe”. The antithetical reality prompted Max Reinhardt to make the memorable statement that the festival should not only be a “luxury good for the rich and saturated but also food for the needy.” (Max Reinhardt, Memorandum, 1917)

OU-TÓPOS AND WORLD STAGE

In the same way that great history, world history is reflected in the small history of the festival, grandeur is manifested on a small scale, for instance, in Hans Poelzig’s design for a festival house in Hellbrunn. “To a certain extent the planned festival house in Salzburg […] is to be understood as the reflection of the solution and conception in Berlin [Poelzig planned Reinhardt’s Grosses Schauspielhaus there]: here the theatre of the big city in the metropolis of Berlin – there the festival house of ‘consecration’ and of ‘light’, away from urban everyday goings on in the province”. (Constanze Schuler, Der Altar als Bühne, 2007)
The visionary project that aimed to combine landscape and architecture, had, however, to remain ou-tópos because of the absence of the hoped-for international financial help, and the massive depreciation of currency doomed the ambitious project to failure. Ultimately the court stables built in 1607 were adapted and turned into a festival house and the architecture of the festival quarter was dominated by Clemens Holzmeister. The Utopia was realised within the city and its surrounding mountains and the myth revived of the “city as a stage”. In Salzburg the recurring picture of the Baroque culture of prestigious events meant: the Great World Theatre – “that builds up an auditorium for the world”, “the metaphor carrying the whole” (Hugo von Hofmannsthal, 1922). To a certain extent Salzburg’s most important secular and religious locations were linked to each other, and the entire city, in accordance with the Baroque idea of “world theatre” was made into a stage (cf. Schuler, 2007). In his Salzburger grosses Welttheater, premiered in 1922 in the Kollegienkirche, Hugo von Hofmannsthal stylised the metaphor as a mystery play. Thomas Bernhard, the writer with the most polarising impact in the 1970s and 1980s, who also caused uproar in Salzburg, paraphrased it 60 years later as follows: 

“Everything in the world is a play, isn’t it? The Pope is also a great actor. Irrespective of whether he has learned a very low play, he is of course now one of the greatest actors. This is such a world play. […] I do not appear in the world theatre. – Somewhere up in the grid, perhaps. Somehow I am pulled along. They are not even pulling at a piece of scenery but perhaps some millions or billions are pulling there? And there the background moves […]. But these few figures at the front, they perform their salon play. And the Pope creates the dignity – with his white robe. The one who is inscrutable usually comes from the East. In other words the red one, the dark one, the feared one. […] Then the comic figure. These things do happen […] Then there are the drinking companions, young journeymen who appear, fat cousins. That is a Jedermann play. And the stage is roundly flattened out, like the globe.” (Thomas Bernhard, Monologe auf Mallorca, recorded by Krista Fleischmann, ORF 1981)

COSMOPOLITANISM VERSUS XENOPHOBIA

Thanks to the international charisma of the artists Max Reinhardt brought to Salzburg, and the visions of the founding fathers, as well as the excellent contacts abroad, especially of Max Reinhardt, the Salzburg Festival very quickly became established. “[…] all at once the Salzburg Festival became a world attraction, as it were the Olympic Games of Art in the modern era, in which all nations competed to present their best achievements […] Kings and princes, American millionaires and film stars, music enthusiasts, artists, writers and snobs all met in Salzburg […].” (Stefan Zweig, Die Welt von Gestern, 1944)
The relationship of the Salzburgers to the “foreigners”, who soon made the pilgrimage in large numbers to the city on the Salzach, was, however, not free of friction. It was not long before the boom in cultural tourism was criticised, and local residents often felt they had been degraded to the role of mere accessories. “They grumbled because they felt threatened, and fought in advance the foreigners who would come, and proved that despite the revolution Austria had remained what it was, by reflecting on the old Austrian election slogan that one wanted to have peace and quiet.” (Quoted from: Dopsch, Geschichte, 1996)
Finally, from the beginning of the 1930s, the worst form of xenophobia, anti-Semitism, became unbearable under the influence of the Nazis. It became increasingly difficult for Max Reinhardt, who was Jewish, to work in Salzburg. From 1938 Jewish artists were prohibited from performing in Salzburg. Hugo von Hofmannsthal’s Jedermann disappeared from the programme, as did many other works by Jewish artist colleagues. Salzburg was also no longer the stage for an international public. The festival degenerated into insignificance and became a wheel in the propaganda machine of the Nazis, a “place where politics could be staged”. (cf. Robert Kriechbaumer, Salzburger Festspiele. Ihre Geschichte von 1960 bis 1989, 2010)

CONTINUITIES AND BREAKS

Efforts were made to revive the festival immediately after the war. Nevertheless, a renaissance of the glorious past was not possible without friction. Artists of decisive importance had either been exiled or killed. This radical change was more of a new beginning for the festival and one which would have been impossible without the mission and the support of the American occupying forces. Nevertheless, between the breaks which occurred parallel to the changes in time, some elements of continuity are also evident, both as regards the persons involved as well as the content: “Besides the reengagement of eminent artists who had been exiled […] efforts were concentrated above all on the de-Nazification of the antipodes Wilhelm Furtwängler and Herbert von Karajan.” (Robert Kriechbaumer, Salzburger Festspiele. Ihre Geschichte von 1945 bis 1960, 2007)

Similar to the period 1918/20, in 1945 the return to the idea of the founding fathers of bringing nations together and evoking a new Austrian identity played a central role for Salzburg. “The opening of the festival in 1945 was not only the politically conscious break back to the time before 1938 but was also intended to stage this” (Kriechbaumer, Festspielgeschichte, 2010).

During the consolidation of the Salzburg Festival in the 1950s – which occurred parallel to economic normalisation in Austria as well as in Europe – Oscar Fritz Schuh and his “Salzburger Dramaturgie” (Dramatic Concept for Salzburg) followed on spiritually from Hofmannsthal’s and Reinhardt’s programmatic ideas, but on the other hand he also tried, together with Gottfried von Einem, to bring about a new accentuation by presenting world premieres and by broadening the programme. Finally, in the midst of the Cold War, the Bertolt Brecht affair occurred in the microcosm of the festival – a grotesque cultural and political incident related to a new Salzburger Totentanz and an Austrian passport.

The opening of the Grosses Festspielhaus – built according to plans by Clemens Holzmeister – in the summer of 1960 with a performance of Der Rosenkavalier by Richard Strauss, marked the beginning of a new era, which is inseparably linked with Herbert von Karajan, the “genius of the economic miracle.” (Theodor W. Adorno) “The ‘Karajan era’ lasted about three decades and discussion centred on preserving the special Salzburg Festival idea of its founders Hugo von Hofmannsthal, Max Reinhardt and Richard Strauss. The necessity for a ‘Dramatic Concept for Salzburg’ also emerged in three waves, following the cycle of the decades as well as the three mutually influential levels of professional criticism, the group around Bernhard Paumgartner, Clemens Holzmeister and Oscar Fritz Schuh, who spoke out in favour of adapting the idea of the founders, and in particular promoted the links between landscape and art. Some of the regional politicians also demanded an opening up and democratisation of the festival.” (Kriechbaumer, Festspielgeschichte, 2010)
At the latest since the Karajan era the discussion about the festival idea and programming policy is something that occurs annually in public. With the same regularity the decline of the festival is also prophesied. 
Naturally adaptations to the programme were necessary because of the need to fill the 2,200 seats in the Grosses Festspielhaus and this meant a relative limitation to the repertoire of grand opera from the 19th century. There were also economic consequences. Many people seemed to think the future of the festival had been sacrificed to the dominance of the rich and beautiful, to Vanitas, Vanity Fair. “In the Viennese journal Forum des Akademikers the fear was expressed that most seats would probably have to be filled with members of the high society from America and the rest of the world. In the Zurich newspaper Weltwoche Robert Jungk feared that Salzburg might become a mass concern, that cultural capital would be wasted and that the ‘opera bunker in the Mönchsberg’ was an attack against the spirit of the old cultural cities.” (Gert Kerschbaumer, Die Wiederbelebung der Glanzzeiten in den Nachkriegsjahren, 1994)

Many of the fears expressed at that time were justified – many were characterised by resentment and prejudice. At the latest in the mid-1980s, however, the debates about the philosophy of the Salzburg Festival escalated and the need for a radical change became increasingly evident. Is it by chance that precisely in 1989/90, when the borders towards Eastern Europe were opening up, in Salzburg too the course was set for the future and Gerard Mortier proclaimed the “new Salzburg”? The “death of Herbert von Karajan, the resignation of Governor Dr. Wilfried Haslauer and the fall of the Iron Curtain brought a concordance of changes in art, in regional and world politics.” (Kriechbaumer, Festspielgeschichte, 2007)

Under Gerard Mortier, Peter Stein and Hans Landesmann the sphere of drama as well as the concert programmes were given greater significance. The opera repertoire was completely renovated and presented many first performances, with New Music in particular playing a greater role. The new Artistic Director refused to become involved in jet-setting hurly-burly à la Karajan, but he engaged eloquently in political discussions and opened the festival – “intended as a place of protection and healing – in the nineties as a place of pioneering enterprise and confrontation” (Gerard Mortier in: Gerard Mortier/Hans Landesmann, Salzburger Festspiele 1992–2001, 2001). “As formulated by Hugo von Hofmannsthal did purpose and duty ever become a tradition for the Salzburg Festival? The so-called Hofmannsthal ideology was a slalom between contradictory ambitions and their programmatic implementation; between sacred art and theatre as a festive institution to bring joy […]. ” (Gerard Mortier, ebd.)

Peter Ruzicka also gave much thought to the “Dramatic Concept for Salzburg” or rather its “long overdue new determination, historically and morally” (Peter Ruzicka) by rehabilitating the composers who had been forced into exile. This is a reflection of the signs of the times, as is the massive project of the 2006 season: after several years when the Mozart repertoire was not at the forefront of interest, the time seemed ripe for Mozart 22, the scenic performances of all his operas in the Mozart anniversary Year. “When I began making plans in 1999, at the start of a new dramatic concept for Salzburg and a festival idea that was intended to have lasting significance beyond the next premiere, I already had this risky undertaking in mind. […] Nevertheless, arousing enthusiasm for an idea is one thing, implementing it is something completely different. I knew right from the beginning and I understand it better now than ever before that this project, which was unique in theatre history, would never have succeeded anywhere else in the world, in no other opera house and at no other festival. Only in Salzburg, only at the Salzburg Festival was such an undertaking even conceivable.” (Peter Ruzicka, Fünf Jahre Salzburg! Ein Rückblick ohne Zorn?, 2006)
Like the years before Karajan, those afterwards are also characterised by conflicting aims, not least by the ever newly formulated task of presenting the highest quality, working efficiently and economically and at the same time allowing experiments, or as has increasingly been the case in recent years, nurturing young talent.

The years under Artistic Director Jürgen Flimm again tried to approach a festive character in the spiritual sense, dramaturgically based on metaphysical issues. In the new times of losing values this reflected the hope of being able to make statements through art, “by thinking about old concepts, indeed let’s say values” (Jürgen Flimm, Salzburger Festspiele, Magazin, 2009) as a countermeasure. It almost seems to be one of history’s cruel ironies that the preparations for the 2009 season on the theme “The Game of the Mighty” were overshadowed by the worldwide economic crisis, the “radical faults of the global financial markets” (Jürgen Flimm, ebd.). For 2010 attention was focused on the theme “Myth”, when in the anniversary year the Salzburg Festival reflected on its own history. “From the very beginning Hofmannsthal was aware of his founding a myth. Behind it was the intention of reconstructing lost unity by the arts, so as to halt spiritual and cultural decline. Thus the Salzburg Festival has become a myth, a ritual and a story about which the world is to be reminded annually. The myth is spiritedly maintained by criticism alone […].” (Michael Fischer, Salzburger Festspiele, Magazin, 2010)
At the same time the theme of the Salzburg Festival 2010 and the world premiere of Wolfgang Rihm’s new piece of music theatre referred to the idea of “Theatre as a Festivity”. The solemnly celebrated Dionysian feasts lasting several days were to be evoked, which were regarded as “the ideal image of a unity of cult and theatre in the framework of a religious festivity.” (Schuler, Altar als Bühne, 2007)

Margarethe Lasinger
Translated by Elizabeth Mortimer
