+++
date = "2015-10-26T23:07:00-04:00"
lastmod = "2015-10-26T23:11:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445915476204/OWS.jpg.jpg"
publishDate = "2015-10-26T23:11:00-04:00"
related_people = ["scene/people/sonya-headlam.md"]
slug = "one-world-symphony"
title = "One World Symphony"
type_of_company = "Orchestra"
website = "http://www.oneworldsymphony.org/index.shtml"
+++

## VISION

One World Symphony is dedicated to integrating itself into the fabric of the community through adventurous programming, inspiring performances, benefit concerts, and audience and community engagement.

## Realizing the VISION

### Adventurous Programming

"For visionary programming and winning zeal, no local orchestra tops One World Symphony." –Marion Lignana Rosenberg of *Classical Music Review*

"Top marks for gutsy programming" – *Time Out New York*

"One World Symphony has performed many premieres since its founding in 2001 by the composer and conductor Sung Jin Hong." –Vivien Schweitzer, *The New York Times*

"One World Symphony re-invents the orchestral experience." – *Courier-Life*

"One World Symphony has a track record in presenting music from Coldplay, the Beatles and U2 alongside the canonical classics of Holst and Strauss in concert programmes. Hong's successful 2009 production of Paulo Coelho's bestseller The Alchemist was hailed by The New York Times as "Mahlerian". More recently he has been conducting such 20th Century operatic classics as Britten's Peter Grimes and Richard Strauss' Elektra and Salomé. Hong, if refreshingly unpretentious, is no musical lightweight." –Clemency Burton-Hill, BBC

"Visionnaire avant-gardiste ... plutôt séduit par le projet de Sung Jin Hong." (Avant-garde visionary ... we're pretty impressed by Sung Jin Hong's project) – *Louis Le Classique*

"But another dimension is always present in their concerts, and that is a unified theme for each program, an added layer of content for digestion by the inquisitive mind, making the evening into an intellectually richer, more luxuriant experience." – Composers of Sibelius

"Few orchestras would take such a gamble by ending their season on such a dark note; then again, this ensemble has no fear of taking chances." – Alan Young, *Lucid Culture*

### Inspiring Performances

"And it was this sense above all — of people making exciting music together that elevated the evening into the realm of the truly inspired." – Georges Briscot, *Operaticus*

"Hong definitely took the audience on a complex emotional, and perhaps, spiritual journey as the piece was received with a standing ovation." – John-Morgan Bush, *Tuxedo Revolt*

"I definitely felt the passion as One World Symphony drives home with a powerful finale with a delivery of such a dynamic programming and vibrant performances. An amazing performance that was propelled forth with real drive and energy. Sung Jin Hong is brilliant and One World Symphony created a complete masterpiece." –Antonio Saillant, *The Examiner*

### Audience and Community Engagement

"Perhaps the best thing about One World Symphony is that while other orchestras may always begin with good intentions to relate to their audiences, One World Symphony always makes good on its promise.  Through innovative concert programming, to in-concert discussions about what makes the music relate to the concert's theme, to the intimate spaces in which the orchestra typically performs — make no mistake, One World Symphony is one of New York City's most liquid, adaptive, and creative orchestras." – John-Morgan Bush, *Tuxedo Revolt*

"The five-minute dissection of the love duet could easily be turned into a 30-minute preconcert talk by Hong. While he is incredibly knowledgeable, he is also passionate which makes the experience all the more illuminating." – Olivia Giovetti, *Time Out New York*

### The Intimate Experience

Up-close and personal, One World Symphony fosters active audience participation in an intimate setting without amplification, barriers, or pretense. Audiences enjoy surprises, sing-alongs, laughter, and powerful performances.

"An immersive experience...resulting acoustical effects, as the music filled the space from above and behind, created a very holographic, three-dimensional sound, seemingly placing the audience inside the cloud" – Composers of Sibelius

### Benefit Concerts

One World Symphony has raised thousands of dollars by performing concerts for the benefit of organizations in New York, such as the Uniformed Firefighter’s Association Widows’ and Children’s Fund and the United Spinal Association, as well as for tsunami victims in South East Asia and East Africa, victims of Hurricane Katrina, The Coalition for the Homeless, Haiti Relief and Development Fund, The Humane Society of New York, The Make-A-Wish® Foundation of Metro New York, the American Red Cross Japan Earthquake and Pacific Tsunami Relief Fund, the Holy Apostles Soup Kitchen, and The Breast Cancer Research Foundation.® Additionally, One World Symphony has collaborated with organizations like The September Concert Foundation and the Ramakrishna-Vivekananda Center of New York in an effort to create world unity through inspiring performances. Since 2011, One World Symphony annually contributes towards New York City’s largest soup kitchen — Holy Apostles Soup Kitchen — during the holiday and Valentine’s seasons.

"Whereas, it is a Brooklyn tradition to celebrate the spirit of generosity and concern for one’s fellow human beings in their time of need, it is only fitting that this office should recognize and honor One World Symphony working to support humanitarian relief efforts around the world. I salute and commend Conductor Sung Jin Hong and all the talented musicians of the One World Symphony for their generously donating their musical skill to help those in such great need, and for sharing their beautiful music with us tonight." – Marty Markowitz, Brooklyn Borough President

"Hong’s humanitarian efforts are also notable – the symphony commits to raising funds for at least one charity each year, a noble cause given how much arts organizations themselves clamor for funding. Perhaps it’s the modest means that they spin into artistically rich evenings. On a more mystical level, perhaps there’s some musical karma at play that returns the love the orchestra puts out into its world. At any rate, One World Symphony is one of those slow-and-steady success stories that sets a tone for making art in this decade’s economic climate." – Olivia Giovetti, WQXR

"New York's hippest orchestra" –*Courier-Life*
