+++
date = "2016-05-10T11:30:00+01:00"
lastmod = "2016-05-10T11:32:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462875929722/2016-05-10---Kronos-Quartet.jpg.jpg"
publishDate = "2016-05-10T11:32:00+01:00"
slug = "kronos-quartet"
title = "Kronos Quartet"
type_of_company = "String Quartet"
website = "http://kronosquartet.org/home"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/kronosquartet"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/kronosquartet"
[[social_media]]
platform = "Youtube"
template = "social-media"
url = "https://www.youtube.com/user/kronosquartet1"
+++

For more than 40 years, the Kronos Quartet—David Harrington (violin), John Sherba (violin), Hank Dutt (viola), and Sunny Yang (cello)—has pursued a singular artistic vision, combining a spirit of fearless exploration with a commitment to continually re-imagining the string quartet experience. In the process, Kronos has become one of the most celebrated and influential groups of our time, performing thousands of concerts worldwide, releasing more than 50 recordings of extraordinary breadth and creativity, collaborating with many of the world's most intriguing and accomplished composers and performers, and commissioning more than 850 works and arrangements for string quartet. In 2011, Kronos became the only recipients of both the Polar Music Prize and the Avery Fisher Prize, two of the most prestigious awards given to musicians. The group’s numerous awards also include a Grammy for Best Chamber Music Performance (2004) and “Musicians of the Year” (2003) from Musical America. 

Kronos’ adventurous approach dates back to the ensemble’s origins. In 1973, David Harrington was inspired to form Kronos after hearing George Crumb's *Black Angels*, a highly unorthodox, Vietnam War–inspired work featuring bowed water glasses, spoken word passages, and electronic effects. Kronos then began building a compellingly diverse repertoire for string quartet, performing and recording works by 20th-century masters (Bartók, Webern, Schnittke), contemporary composers (Sophia Gubaidulina, Bryce Dessner, Aleksandra Vrebalov), jazz legends (Ornette Coleman, Maria Schneider, Thelonious Monk), rock artists (guitar legend Jimi Hendrix, Brazilian electronica artist Amon Tobin, and Icelandic indie-rock group Sigur Rós), and artists who truly defy genre (performance artist Laurie Anderson, composer/sound sculptor/inventor Trimpin, and singer-songwriter/poet Patti Smith). 

Integral to Kronos’ work is a series of long-running, in-depth collaborations with many of the world’s foremost composers. One of the quartet’s most frequent composer-collaborators is “Father of Minimalism” Terry Riley, whose work with Kronos includes *Salome Dances for Peace* (1985–86); *Sun Rings* (2002), a multimedia, NASA-commissioned ode to the earth and its people, featuring celestial sounds and images from space; and *The Serquent Risadome*, premiered during Kronos’ 40th Anniversary Celebration at Carnegie Hall in 2014. Kronos commissioned and recorded the three string quartets of Polish composer Henryk Górecki, with whom the group worked for more than 25 years. The quartet has also collaborated extensively with composers such as Philip Glass, recording a CD of his string quartets in 1995 and premiering String Quartet No. 6 in 2013, among other projects; Azerbaijan’s Franghiz Ali-Zadeh, whose works are featured on the full-length 2005 release Mugam Sayagi; Steve Reich, from Kronos’ performance of the Grammy-winning composition *Different Trains* (1989) to the September 11–themed WTC 9/11 (2011); and many more. 

In addition to composers, Kronos counts numerous performers from around the world among its collaborators, including the Chinese pipa virtuoso Wu Man; Azeri master vocalist Alim Qasimov; legendary Bollywood “playback singer” Asha Bhosle, featured on Kronos’ 2005 Grammy-nominated CD *You’ve Stolen My Heart: Songs from R.D. Burman’s Bollywood*; Inuit throat singer Tanya Tagaq; indie rock band The National; Mexican rockers Café Tacvba; sound artist and instrument builder Walter Kitundu; and the Romanian gypsy band Taraf de Haïdouks. Kronos has performed live with the likes of Paul McCartney, Allen Ginsberg, Jarvis Cocker, Zakir Hussain, Modern Jazz Quartet, Noam Chomsky, Rokia Traoré, Tom Waits, Rhiannon Giddens, Howard Zinn, Betty Carter, and David Bowie, and has appeared on recordings by artists such as Nine Inch Nails, Dan Zanes, Glenn Kotche, Dave Matthews, Nelly Furtado, Joan Armatrading, and Don Walser. In dance, the famed choreographers Merce Cunningham, Paul Taylor, Twyla Tharp, Eiko & Koma, and Paul Lightfoot and Sol León (Nederlands Dans Theater) have created pieces with Kronos’ music. 

Kronos’ work has also featured prominently in a number of films, including two recent Academy Award–nominated documentaries: the AIDS-themed *How to Survive a Plague* (2012) and *Dirty Wars* (2013), an exposé of covert warfare for which Kronos’ David Harrington served as Music Supervisor. Kronos also performed scores by Philip Glass for the films *Mishima* and *Dracula* (a 1999 restored edition of the 1931 Tod Browning–Bela Lugosi classic) and by Clint Mansell for the Darren Aronofsky films *Noah* (2014), *The Fountain* (2006), and *Requiem for a Dream* (2000). Additional films featuring Kronos’ music include *The Great Beauty* (2013), *Heat* (1995), and *True Stories* (1986). 

The quartet spends five months of each year on tour, appearing in concert halls, clubs, and festivals around the world including Carnegie Hall, Lincoln Center Out of Doors, Big Ears, BAM Next Wave Festival, Chicago’s Harris Theater, Disney Hall, Palacio de Bellas Artes in Mexico City, Barbican in London, WOMAD, Amsterdam’s Concertgebouw, Shanghai Concert Hall, and Sydney Opera House. Kronos is equally prolific and wide-ranging on recordings. The ensemble’s expansive discography on Nonesuch Records includes collections like *Pieces of Africa* (1992), a showcase of African-born composers, which simultaneously topped Billboard’s Classical and World Music lists; 1998’s ten-disc anthology,* Kronos Quartet: 25 Years*; *Nuevo* (2002), a Grammy- and Latin Grammy–nominated celebration of Mexican culture; and the 2004 Grammy-winner, Alban Berg’s *Lyric Suite*, featuring renowned soprano Dawn Upshaw. Other more recent releases include Rainbow (Smithsonian Folkways, 2010), in collaboration with musicians from Afghanistan and Azerbaijan; and Aheym: Kronos Quartet Plays Music by Bryce Dessner (Anti-, 2013). In celebration of the quartet’s 40th anniversary season in 2014, Nonesuch released both Kronos Explorer Series, a five-CD retrospective boxed set, and the single-disc *A Thousand Thoughts*, featuring mostly unreleased recordings from throughout Kronos’ career. 2015 brought the release of *Tundra Songs* by Derek Charke as well as a boxed set of Terry Riley’s music written for and performed by Kronos in celebration of the composer’s 80th birthday. Music publishers Boosey & Hawkes and Kronos have released two editions of Kronos Collection sheet music: Volume 1 (2006), featuring three Kronos-commissioned works; and *Volume 2* (2014), featuring six Kronos-commissioned arrangements by composer Osvaldo Golijov. 

In addition to its role as a performing and recording ensemble, the quartet is committed to mentoring emerging performers and composers and has led workshops, master classes, and other education programs via the San Francisco Conservatory of Music, the California State Summer School for the Arts, Carnegie Hall’s Weill Music Institute, and other institutions in the U.S. and overseas. Kronos has recently undertaken extended educational residencies at UC Berkeley’s Cal Performances, The Clarice at the University of Maryland, and with the Kaufman Music Center’s Face the Music. 

With a staff of 11 based in San Francisco, the non-profit Kronos Performing Arts Association (KPAA) manages all aspects of Kronos’ work, including the commissioning of new works, concert tours and local performances, education programs, and more. KPAA’s *Kronos: Under 30 Project*, a unique commissioning and residency program for composers under age 30, has now added five new works to the Kronos repertoire. KRONOS PRESENTS is a new presenting program showcasing Kronos’ commissioned works, artistic projects and far-ranging musical collaborations through an annual festival, education and community activities, and other events in the San Francisco Bay Area and beyond. 

In 2015 KPAA launched a new commissioning and education initiative – *Fifty for the Future: The Kronos Learning Repertoire*. With Carnegie Hall as a lead partner, KPAA is commissioning 50 new works – 10 per year for five years – devoted to contemporary approaches to the quartet and designed expressly for the training of students and emerging professionals. The works will be created by an eclectic group of composers – 25 women and 25 men. The quartet will premiere each piece and create companion materials, including scores and parts, recordings, videos, performance notes, and composer interviews, that will be distributed online for free. Kronos’ *Fifty for the Future* will present quartet music as a living art form, and provide young musicians with both an indispensable library of learning and a blueprint for their own future collaborations with composers. Kronos, Carnegie Hall, and an adventurous list of project partners that includes presenters, academic institutions, foundations and individuals, have joined forces to support this exciting new commissioning, performance, education, and legacy project of unprecedented scope and potential impact.
