+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-06-02T05:47:00-06:00"
lastmod = "2016-07-06T16:12:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464980611100/2016-06-04---YNZ-2009002-Marco-Borggreve.jpg.jpg"
primary_image_credit = "Photo by Marco Borggreve."
publishDate = "2016-06-03T14:30:00-06:00"
related_articles = ["articles/is-it-time-for-the-met-to-move.md","articles/elitism-irony-and-the-phantom-of-the-opera.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/yannick-nezet-seguin.md"]
short_description = "With a few years of unsettled music direction, and a real need to try something actually new (perhaps veering towards what many opera fans would call &quot;pandering&quot;), it seems like a perfect opportunity for the Met to take a serious try at adding musicals to their heavy roster of over 20 productions per season. There&#039;s perhaps an untapped, enthusiastic potential audience that would love to pair the grandeur and the chandeliers with the kind of onstage action that is less foreign to their eyes and ears."
slug = "yannick-nezet-seguin-musicals-and-great-timing"
title = "Yannick Nézet-Séguin, musicals, and great timing"
+++

A few weeks ago, we were [pondering](/is-it-time-for-the-met-to-move/) what The Metropolitan Opera could do about the too few butts in their seats and falling ticket revenue. We added our two cents to the myriad of suggestions proposed by people who don't want the Met to fail, but for some reason, one huge, glaring, and hopefully not novel idea didn't occur to us at the time: what if the Met did musicals?

It can't be a new idea, seeing as major houses like Houston Grand Opera, San Francisco Opera, English National Opera, and Lyric Opera of Chicago have already tried it out with successful results. It's not even new for opera companies in New York; when she was general manager of New York City Opera, Beverly Sills included classic musicals in the season line-up.

So, why hasn't the Met followed suit? Maybe it's a combination of turf and supply-and-demand; New York is basically the world's capital when it comes to musicals, so maybe if the Met were to add stuff like *West Side Story* or *Into the Woods* or some good old Rogers & Hammerstein to their season line-up, it would dilute the market for both the Met and Broadway.

There's also the problem of acoustics. The Met's cavernous house doesn't lend itself well to dialogue, or for the kind of singing that assumes some level of microphone assistance. We know that miked performances are possible because of the Met's HD Broadcast series; still, there are many opera fans who deem it a shame to erase the natural acoustic in the opera house by way of amplification.

But frankly, who cares about the grumblings of a few? Like most opera companies, the Met is on the hunt for new audience members. There's likely a strong overlap between people who have never been to the Met, and people who don't get uppity over acoustic purity. The loyal audience who's averse to hearing an amplified show simply won't go to the musicals; if their opera is left acoustically intact, there's little risk of losing them entirely over feelings of huffiness.

We're among the many who are really excited about Yannick Nézet-Séguin's taking over as Music Director, yet [the Met will have to wait](http://www.nytimes.com/2016/06/03/arts/music/is-yannick-nzet-sguin-worth-the-wait-at-the-met.html) until the 2020/21 season before he officially begins his tenure. A span of five years is a lot of time in which attendance could either drop further, and if the former happens, it would be a really big shame. Nézet-Séguin is utterly thrilling to watch at work, and even listeners without a long standing relationship with opera would feel the gripping excitement he brings out of the pit. 

With a few years of unsettled music direction, and a real need to try something actually new (perhaps veering towards what many opera fans would call "pandering"), it seems like a perfect opportunity for the Met to make a serious attempt at adding musicals to their heavy roster of 20+ productions per season. There's perhaps an untapped, enthusiastic audience that would love to pair the grandeur of red carpeted staircases and crystal chandeliers with a more familiar kind of onstage action. 

We've [written before](/is-it-time-for-the-met-to-move/) about how the opera house itself can seem intimidating, a closed society of sorts; yet people are willing to go to any kind of venue if they know what they're getting. There could be great opportunities for the Met to offer subscription packages over these five pre-Yannick seasons (although, hopefully not limited to the interim period), which have one foot in the Sondheim door, and another in the Verdi door. 

Hopefully the Met isn't ceding to the idea that musicals are a lesser thing to place on their stage, or to similar sentiments by its donors and board. It's a kind of stubbornness that doesn't pay off, and simply adds to the stereotypes that opera is elitist; those are harder to prove wrong than perhaps the Met anticipates. The stars onstage, the exciting productions, and people like Nézet-Séguin in the pit are all great reasons to attend the Met, but to the people that they have to convice (as in, new audience members), these factors don't mean enough, if they mean anything at all. 

Introducing fans of music theatre to a stunning venue, and employing some of the stars in the Met's roster who are more than capable of pulling off crossover work - that's much less of a stretch to imagine this new group buying tickets for a different sort of entertainment within a context (and building) they know.
