+++
author = ["authors/blanche-isral.md"]
categories = "Review"
date = "2017-10-09T11:45:00-04:00"
lastmod = "2017-10-09T21:57:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507564036570/2017-10-09---3391_petergrimes07_gross.jpg.jpg"
primary_image_credit = "German tenor Vincent Wolfsteiner debuts the title role of Peter Grimes, Peter Grimes, Oper Frankfurt, 2017. Photographer: Monika Rittershaus."
publishDate = "2017-10-09T19:22:00-04:00"
related_articles = ["articles/a-visceral-nightmarish-tourdeforce-der-mieter.md"]
related_companies = ["scene/companies/oper-frankfurt.md"]
related_people = ["scene/people/sydney-mancasola.md","scene/people/aj-glueckert.md","scene/people/clive-bayley.md","scene/people/jane-henschel.md","scene/people/angela-vallone.md","scene/people/vincent-wolfsteiner.md","scene/people/sara-jakubiak.md"]
short_description = "Warner&#039;s Grimes is far from blameless, mirroring the ambiguity around an attitude that welcomes outsiders when those outsiders pose a perceived threat. For a German audience that is still adjusting to the arrival of a million Syrian refugees in the wake of the 2015 migrant crisis and whose dark history of unfounded scapegoating still looms large, this Peter Grimes struck a resounding chord. "
slug = "xenophobia-fake-news-mental-health-peter-grimes"
title = "Xenophobia, Fake News, &amp; Mental Health: Peter Grimes"
+++

[*Peter Grimes*](http://www.oper-frankfurt.de/en/season-calendar/peter-grimes/?id_datum=999) opened at [Oper Frankfurt](/scene/companies/oper-frankfurt/) last night in a new production by British director Keith Warner. Britten's opera is at once highly specific and highly universal in its exploration of the pain of being ostracized, shunned, or misunderstood, and of the damaging and irreversible results of spreading uninformed rumours and fake news. Oper Frankfurt offers a gloomy and powerful production at a time when we are all so used to being surrounded with blame and fear mongering, and mental health issues are running high and exacerbated by social pressures to conform. Warner's Grimes is far from blameless, mirroring the ambiguity around an attitude that welcomes outsiders when those outsiders pose a perceived threat. For a German audience that is still adjusting to the arrival of a million Syrian refugees in the wake of the 2015 migrant crisis and whose dark history of unfounded scapegoating still looms large, this *Peter Grimes* struck a resounding chord. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507563466924/2017-10-09---3390_petergrimes08_gross.jpg.jpg)
<figcaption>Sara Jakubiak (Ellen Orford, middle) and AJ Glueckert (Bob Boles, right) with Ensemble. *Peter Grimes*, Oper Frankfurt, 2017. Photographer: Monika Rittershaus.</figcaption>
</figure>

It was primarily an ensemble triumph, with the sheer forces in the orchestra and chorus as the star, led by Oper Frankfurt Music Director Sebastian Weigle. From the foghorn-like brass to the fluttering and crashing waves in the strings and winds, the orchestra was full and swelling. Ellen Orford's first aria, sung beautifully and with reserve by soprano [Sara Jakubiak](/scene/people/sara-jakubiak/), was very much a duet with orchestra. Weigle's orchestra interacted with and supported every singer, embodying at any given moment a swelling sea, a bird's unsettling song, the unpredictable villagers or the title character's inner turmoil. Especially moving was the fifth (third in suite for orchestra) "Moonlight" interlude that provided a wrenching heartbeat after the young apprentice's death. The chorus, nearly 80-strong and including the "extrachor" (additional forces), was relentless in its energy, raising goosebumps in "O Tide That Waits for No Man" and melting the audience's collective face off in the electric mob scene in Act III. As has been said [on this blog before](/tales-from-the-score-peter-grimes/), "there's nothing scarier than an ill-informed, xenophobic, bored group of small-towners with weapons", and this mob is all too familiar in these times where angry street mobs are [in the mainstream media](https://www.google.de/search?q=charlottesville+mob&source=lnms&tbm=isch&sa=X&ved=0ahUKEwjZ3IemnOPWAhVDIMAKHSTmAQUQ_AUICigB&biw=1254&bih=655).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507563584090/2017-10-09---3381_petergrimes17_gross.jpg.jpg)
<figcaption>Vincent Wolfsteiner (Peter Grimes) escaping a mob of angry villagers. *Peter Grimes*, Oper Frankfurt, 2017. Photographer: Monika Rittershaus</figcaption>
</figure>

Amidst this powerful wash of sound, some members of the cast especially stood out. Though perhaps a secondary character, it must be said that British bass [Clive Bayley](/scene/people/clive-bayley/) as Swallow gave a masterclass in singing, and the evident ease in his diction made him compelling and easy to follow. [AJ Glueckert](/scene/people/aj-glueckert/) was another standout in a supporting role, exhibiting great singing and sensitive acting as the judgmental and hypocritical Bible-thumping Bob Boles. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507563657207/2017-10-09---3384_petergrimes14_gross.jpg.jpg)
<figcaption>(l-r) Peter Marsh (Reverend Horace Adams), Jane Henschel (Auntie), Sara Jakubiak (Ellen Orford) and AJ Glueckert (Bob Boles) in *Peter Grimes*, Oper Frankfurt, 2017. Photographer: Monika Rittershaus</figcaption>
</figure>

German tenor Vincent Wolfsteiner offered a strong role debut as Peter Grimes. His sound only grew as the performance went along, and he embodied a rough and unhinged Grimes. Wolfsteiner really crossed a threshold when he arrived at his Mad Scene, unveiling a truly nuanced sense of the character's mental instability and societal vulnerability that invited sympathy and pity from the viewer.

The special moment shared by the female quartet of Sara Jakubiak (Ellen Orford), [Jane Henschel](/scene/people/jane-henschel/) (Auntie), [Sydney Mancasola](/scene/people/sydney-mancasola/) (First Niece) and [Angela Vallone](/scene/people/angela-vallone/) (Second Niece) was breathtaking, and I loved Warner's gently tumbling staging, which illustrated the etherealness already evoked in the music without being overly on the nose. Jakubiak as Ellen Orford was innocent and absorbed in a world all her own, her full and heartwrenching voice always a bit veiled by constant fear and inner turmoil.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507563732380/2017-10-09---3383_petergrimes15_gross.jpg.jpg)
<figcaption>Sara Jakubiak (Ellen Orford) und Vincent Wolfsteiner (Peter Grimes), *Peter Grimes*, Oper Frankfurt, 2017. Photographer: Monika Rittershaus</figcaption>
</figure>

Warner gave Wolfsteiner additional backstory for his *Peter Grimes*, which I appreciated. The little boy with a miniature boat, who mirrors the adult Peter, hinted at additional trauma in the character's past: the mini-Peter witnesses a father figure - perhaps a fisherman for whom he had been an apprentice when he was a child - die suddenly of a heart attack. This ignites the generational cycle of pain that later pushes him to abuse his own apprentices. His heavy burdens are illustrated by his large boat, which he lugs around, and later swings and spins around with deranged force. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507563807293/2017-10-09---3388_petergrimes09_gross.jpg.jpg)
<figcaption>Vincent Wolfsteiner as Peter Grimes dwarfed by set designer Ashley Martin-Davis's towering sets, *Peter Grimes*, Oper Frankfurt, 2017. Photographer: Monika Rittershaus.</figcaption>
</figure>

Ashley Martin-Davis's sets combined what one would expect of a more traditional staging of Peter Grimes - boats, fishing nets, fog - with symbolism and versatility. The tall wharf walls rose around Peter Grimes, constantly attempting to box him and the other villagers of the Borough in. The angles and sharp shadows towered over him like a looming coffin, foreshadowing his fate. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507563860114/2017-10-09---3394_petergrimes04_gross.jpg.jpg)
<figcaption>Coffin-like angular sets by Ashley Martin-Davis, *Peter Grimes*, Oper Frankfurt, 2017. Photographer: Monika Rittershaus.</figcaption>
</figure>

The backdrops changed abruptly, at times even ripped down by angry villagers, embodying the swiftness and unpredictability of the changes in mood in both the weather and the public's opinion of the title character. The way fog was used was innovative, especially in the last backdrop fall that created a stormy sea wave that crashed over Peter Grimes as he disappeared at sea.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507563909591/2017-10-09---3377_petergrimes21_gross.jpg.jpg)
<figcaption>Peter Grimes disappears at sea. Vincent Wolfsteiner, *Peter Grimes*, Oper Frankfurt, 2017. Photographer: Monika Rittershaus</figcaption>
</figure>

Frankfurt audiences I've spoken to so far seem to really love English opera. They perhaps have more tolerance for disturbing and gloomy themes than a Canadian audience, and they generally have more appetite for abstractness in themes and music. It is nice to watch Britten with them. If you’re in Frankfurt, don't miss being blown away by Britten's deeply intimate yet epic [*Peter Grimes*](http://www.oper-frankfurt.de/en/season-calendar/peter-grimes/?id_datum=999), on stage at Oper Frankfurt until **November 11, 2017**.
