+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = "2019-07-09T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Des Moines Metro Opera's [production of _Wozzeck_](http://desmoinesmetroopera.org/productions/wozzeck/) is onstage through July 19."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1562776594/media/2019/07/sqWozzeckDSC_7802.jpg"
primary_image_credit = "Wozzeck, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera."
related_articles = []
related_companies = ["scene/companies/des-moines-metro-opera.md"]
related_people = ["scene/people/michael-mayes.md", "scene/people/sara-gartland.md", "scene/people/corey-trahan.md", "scene/people/gregory-warren.md", "scene/people/zachary-james.md"]
short_description = "Certain characters and scenes were exaggerated and grotesque, accentuating Wozzeck's unreliable interpretation of reality. Other moments, however, were unsettling precisely because they felt so realistic. The omnipresent menacing atmosphere was palpable throughout the opera, and McIntyre did not pull any punches when it came to the pivotal murder scene."
slug = "raw-exposed-wozzeck"
title = "Raw & exposed: Wozzeck"
youtube_url = ""

+++
Des Moines Metro Opera's production of Alban Berg's _Wozzeck_ was a powerful theatrical experience. The atonal masterpiece is 98 minutes of psychological thriller in operatic form, immersing the audience in the dark and disturbing world of an unstable mind. It was absolutely riveting and sometimes hard to watch, but the emotions, whether good or bad, were always intense.

Shout out to the spectacular, ALL FEMALE production team that created the bleak and menacing atmosphere of Wozzeck's troubled existence. Vita Tzykun's scenic design highlighted the fragmented nature of the plot through the use of layered metallic panels. These panels cut through each scene, revealing off-kilter vignettes for Wozzeck's interactions with different characters. The lighting design by Kate Ashton strategically focused or diffused Wozzeck's perspective throughout his experiences, warm and soft when he thought of Marie then harsh and direct when he felt antagonized. The only time that the setting and lighting felt natural is during the murder scene, his most heinous act contrasted by the most unassuming environment.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562776863/media/2019/07/WozzeckDSC_0093-1.jpg){{% /md %}}

<figcaption>Wozzeck, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

Hair and makeup played a vital role in bringing to life the caricatures of Wozzeck's primary tormentors, the Captain and the Doctor. Through the use of prosthetics, wig and makeup designer Brittany Crinson transformed the two singers into hyperbolic villains, virtually unrecognizable compared to their program headshots. Wozzeck's fear of these men was palpable from their appearance alone.

Kristine McIntyre's stage direction showed us the world through Wozzeck's eyes. Certain characters and scenes were exaggerated and grotesque, accentuating Wozzeck's unreliable interpretation of reality. Other moments, however, were unsettling precisely because they felt so realistic. The omnipresent menacing atmosphere was palpable throughout the opera, and McIntyre did not pull any punches when it came to the pivotal murder scene. She did not hide anything from the audience. We watched as Wozzeck slit Marie's throat, leaving her body splayed on the stage for the rest of the scene. Frankly, it was difficult to watch, but anything less jarring would have been a disservice to the story. _Wozzeck_ is full of disturbing interactions, but at the root of the distortions and delusions there are dark truths about rage, violence, and poverty that continue to be relevant today.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562776844/media/2019/07/WozzeckDSC_0291.jpg){{% /md %}}

<figcaption>Wozzeck, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

The concept of an atonal opera can make audiences hesitant, but the emotional power of _Wozzeck_ carries the same weight as any popular tonal work. I forgot about the atonality almost immediately, drawn in by the story and the passion within the composition. The orchestra under the direction of David Neely inhabited the simmering tension and violent swells of Berg's music with a masterful performance. This music is fiendishly difficult for both the vocalists and instrumentalists, but no matter how the performers might have been feeling on the inside, they made it sounds deceptively easy - a testament to their musicianship and teamwork. I am sure that Berg's complex compositional style is a big reason why _Wozzeck_ does not get staged as often as other 20th century masterpieces, and it is a shame because the music, while strange, was absolutely rapturous.

Des Moines Metro Opera assembled a strong cast that displayed outstanding vocal abilities as well as nuanced dramatic performances. [Corey Bix](/scene/people/corey-bix/) sang the role of the Captain, Wozzeck's corpulent superior who constantly berates him. Bix's tenor voice soared through Berg's complex score, traversing an insanely wide vocal range as he jumped from dark low tones to brassy high notes. His performance of the Captain came off as a familiar villain (aka the kind that doesn't even realize that he is the bad guy). The Captain is too self-absorbed to even comprehend how poorly he treats Wozzeck, and Bix conveyed that narcissism with the perfect touch of malevolent humor.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562776832/media/2019/07/WozzeckDSC_0603.jpg){{% /md %}}

<figcaption>Wozzeck, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

[Zachary James](/scene/people/zachary-james/) brought to life Wozzeck's other primary persecutor, the malicious Doctor. James is a familiar face on the Des Moines Metro Opera stage, but he was visually transformed in this role, partially due to the prosthetics but also due to the altered physicality that the singer employed. James is a tall imposing figure, but he gave the Doctor a crooked stance and an almost slithering gait. Wozzeck looked terrified of him, and I couldn't blame him. (That mad scientist gave me the creeps!) James portrayed the Doctor as cold and calculating. It was clear that this man viewed all other human beings as mere case studies, never taking their needs or pains into account. James' voice took on a more sneering tone, and the affect enhanced the character’s sinister persona even further, contrasting the Captain's less intentional antagonism.

>In a world of extreme emotions, the Fool stood out because of his quiet eccentricities.

[Gregory Warren](/scene/people/gregory-warren/) adeptly sang the role Andres, Wozzeck's only friend. Warren was a calming, steady presence on the stage which was a refreshing balance to the more tumultuous vocals of his companions. Andres seemed to be one of the few people that could bring Wozzeck down from his heightened reactions but it was only a temporary effect.

Robert Watson portrayed Wozzeck's sexual rival, the Drum Major. Watson brought a physical swagger to this arrogant character who was obsessed with "breeding little drum majors." (Gross.) His seduction of Marie didn't feel completely consensual, and when she reluctantly gives into his aggressive advances, it is out of resignation rather than temptation.

>Marie brings beauty to Wozzeck's shitty life.

[Corey Trahan](/scene/people/corey-trahan/) was a magnetic enigma in the role of the Fool. He was a man of few words (mostly "blood!"), but the audience was transfixed by his presence. In a world of extreme emotions, the Fool stood out because of his quiet eccentricities. Trahan captured this aloof but wise aspect of the Fool, showing some of the rare glimmers of sympathy in this opera.

Timothy Bruno and Brian Vu as the two apprentices attempted to bring a bit of comedy to balance out Wozzeck's angst. Their carousing vocals brought joviality to the chaos of the tavern even as Wozzeck's world fell apart in front of him.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562776815/media/2019/07/WozzeckDSC_7261.jpg){{% /md %}}

<figcaption>Wozzeck, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

[Sara Gartland](/scene/people/sara-gartland/) sang the role of Marie, Wozzeck's common law wife and mother of his child. Unlike many of the other characters, Marie is not exaggerated or malevolent. Although they are lovers, her interactions with Wozzeck are always strained and brief. Their poverty is weighing on both of them, and it puts them at risk. Everyone beats Wozzeck down throughout the opera, and he cannot fight back. Instead, his internal rage targets the one person who is even more vulnerable than himself: Marie. Gartland portrayed this fallen and fragile woman with sympathy and maturity. It would be simple to condemn Marie for betraying her lover and sleeping with another man, but her circumstances leave her few choices. Gartland sang some of the most beautiful vocal lines of the opera, making atonal melodies feel just as luxurious as her more romantic roles. Marie brings beauty to Wozzeck's shitty life. She's the one good thing that keeps him going, and when he loses that beacon of hope, they are both doomed.

>Mayes radiated a tense energy onstage, like a taut wire ready to snap.

[Michael Mayes](/scene/people/michael-mayes/) was a dramatic beast in the title role of Wozzeck. The baritone took on the gruelling physicality of the staging without hesitation, throwing himself onto the floor and into pits and dangling in a mental health treatment swing that looked like a torture contraption while his head was in a vice! Mayes' vocal performance ran the gamut from timid terror to unhinged wrath. He also employed a variety of physical ticks to further convey the undercurrent of Wozzeck's unraveling mental state. Mayes radiated a tense energy onstage, like a taut wire ready to snap. It was both frightening and fascinating.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562776780/media/2019/07/WozzeckDSC_7521.jpg){{% /md %}}

<figcaption>Wozzeck, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

Wozzeck's one moment of clarity in the opera occurs when he kills Marie, no ticks or convulsions, just focused rage and violence. This scene felt like a screaming moment of silence surrounded by a cacophony of confusion - a shock to the system. After he commits murder, Wozzeck returned to the tavern and acts joyful for the first time in the opera, a downtrodden man celebrating his only moment of control in his life. Even when he returns to the scene of the crime, he hasn't come to terms with the consequences, and instead of mourning, he meets his demise in a frenzied attempt to get rid of the weapon, drowning himself in the process. A violent murder, a frantic suicide, and an orphaned child left behind. The opera ended with Wozzeck's and Marie's child playing alone, not comprehending what has happened to his parents or the dismal future ahead of him. The little boy stared out at the audience with a sad and empty expression, his hand starting to twitch at his side, hearkening back to his father. This subtle tick spoke volumes: the cycle will repeat itself.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562776766/media/2019/07/WozzeckDSC_7719.jpg){{% /md %}}

<figcaption>Wozzeck, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

Des Moines Metro Opera's Wozzeck left the audience feeling raw and exposed. As we left the theater, I could hear other patrons joking that a post-show therapy session was needed. The experience was strange and jarring, but I didn't hear a single person say anything negative about the opera itself. The performance exhumed emotions that we usually avoid, but afterwards, everyone couldn't stop talking about it. And isn't that what art is all about - to make us think and get a dialogue going? Berg's opera challenges us as an audience musically and emotionally, and I loved every unsettling minute of it.