+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-09-24T13:46:00+01:00"
lastmod = "2016-09-26T10:28:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474880178965/2016-09-25---Girls.jpg.jpg"
primary_image_credit = "Photo: Pexels."
publishDate = "2016-09-26T10:23:00+01:00"
related_articles = ["articles/who-are-our-comprimarias-why-arent-they-funnier.md","articles/fachisms-stereotypes-for-a-reason.md","articles/dont-miss-everybodys-got-a-story.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/royal-opera-house.md","scene/companies/mahogany-opera-group.md","scene/companies/indie-opera-to.md","scene/companies/cowtown-opera-company.md","scene/companies/stujess-productions.md","scene/companies/opera-da-camera.md"]
short_description = "And what if they remain ignored? What if women never make up 50% of our conductor, choreographers, and General Directors? Does that mean that our artistic experiences have been, and will always be, limited? Are we missing out on masterpieces without more women calling the artistic shots? Are there certain avenues of the arts that women are simply less interested in pursuing, like technical direction or stage direction?"
slug = "women-in-the-arts-is-it-our-turn-yet"
title = "Women in the arts: is it our turn, yet?"
+++

Last week we went to the [Advance Symposium](http://www.tonictheatre-advance.co.uk/) led by Lucy Kerbel of London's [Tonic Theatre](http://www.tonictheatre.co.uk/), where they and 9 other arts organizations presented [research on the topic of gender imbalances](http://www.tonictheatre-advance.co.uk/advance-2016/insights/) in theatre, dance, and opera.

Participating companies each posed a reflective question about gender imbalance. The Northern Ballet asks, "Why do we see fewer female choreographers of classical ballet than men and how can we ensure that the girls and young women who dance with us are aware that choreography is an option for them and have the opportunity to engage with it?"

Similarly, the [Royal Opera House](/scene/companies/royal-opera-house/) asks, "Why is it that such a small proportion of the conductors we employ are women? What can the Royal Opera House do to increase the number of women conductors working in opera and ballet?"

[Mahogany Opera Group](/scene/companies/mahogany-opera-group/), with its strong commitment to commissioning new work, asks, "Where are the female opera librettists? What routes are currently available for aspiring librettists? How can we broaden these opportunities and encourage more women to consider writing libretti?"

Women make up a majority of UK theatre audiences - as high as 68% - yet the point of Advance is not to assure that each arts organization is staffed with 50% women. The concern for company leaders was less about how many women they work with, and more about *how* they work with those women.

The research turned up a few [recurring themes](http://www.tonictheatre-advance.co.uk/advance-2016/insights/#research-themes). Women feel as though their work is **on the periphery** of some organizations, working just oustide of leadership positions or for smaller, neighbouring companies. They feel their **jobs are fragile**, with added pressures of pregnancy and children. Some women felt like the expectation of a **"good career trajectory"** didn't fit their own wants and needs. Companies often default to a **"how it's done"** method, leaving women out of the mix when it comes time to hire casts and creative teams.

It seemed entirely possible that the themes of fragile jobs, periphery, and unorthodox career trajectories also apply to men, especially when these men are in the early stages of their careers. They're not issues that are unique to women, but perhaps it's true that women feel the effects more acutely.

The biggest hurdle, one that certainly is unique to women, seems to be the **perception that gender quality isn't a problem**. There are women in the arts, no doubt; yet there are comparatively few in senior leadership positions. And talking about it is risky: "We heard from women involved in the research that being the ones to point this out to colleagues who don’t perceive there is a problem can put them in a difficult position in the workplace or the rehearsal room."

Interestingly, our first response to the question of women working in positions of seniority within opera was to think of Canada. [Stu&Jess Productions](http://www.stuandjessproductions.com/), [Opera da Camera](/scene/companies/opera-da-camera/), [Cowtown Opera](http://www.cowtownoperacompany.com/2016-home/), and the majority of the companies in [Indie Opera T.O.](http://www.indieoperatoronto.ca/companies/) are led by women. There are women leading Canada's largest [singer-focused management agency](http://deanartists.com/), and women hold both the Executive Director and Chair positions on the Opera.ca Board of Directors.

Perhaps Canada's gender equality numbers are objectively better balanced than in the UK. What's more likely, though, is that Canada's opera scene is a picture of what's happening worldwide. Around the [Canadian Opera Company](/scene/companies/canadian-opera-company/), which is led by men (with offices full of women, to be sure), lie companies like [Opera Five](/scene/companies/opera-5/), [The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/), and [Essential Opera](/scene/companies/essential-opera/), where women manage, direct, and perform. 

Our hunch is that there's a similar model in other opera hubs like New York, San Francisco, and clearly, London.

Another question arose: what was stopping women from rising to these central, senior positions? Two big answers seem to say it all: unions, and time. With the former, the issue is turnover. For young people, gone are the days of a "job for life," especially within the arts; yet there are still members of stage crews, choruses, and design teams who have tenure. 

It's a hard pill to swallow when jobs appear to be based - at the very least - on merit, and it means that these positions are simply unavailable for anyone else of any gender until the tenure-holder's retirement or death. (And with the economic hits of the last decade or so, fewer people are willing to retire sooner.)

Time, and the ability to be patient, seem to be the classic solutions. It may seem like a passive solution to a big, pernicious problem like gender imbalance, but it's related to that perception that no problem exists at all. For artists under 40-ish, it's extraordinarily rare to find someone who balks at the idea of working with or for a woman. It's also extraordinarily rare to meet an artist over 40 who is overtly and proudly sexist at work. The issue seems to fall lamely between having leaders who don't see a problem, and having very few leadership vacancies to offer men and women alike.

It may feel as though women have already been doing nothing but waiting for equality. Yet as General Directors retire, and as big companies continue to [learn from small companies](http://www.musicaltoronto.org/2016/09/17/the-scoop-against-the-grain-launch-seventh-season-with-big-surprise/), there are simply too many talented and experienced women in the industry to be ignored for another generation.

And what if they remain ignored? What if women never make up 50% of our conductor, choreographers, and General Directors? Does that mean that our artistic experiences have been, and will always be, limited? Are we missing out on masterpieces without more women calling the artistic shots? Are there certain avenues of the arts that women are simply less interested in pursuing, like technical direction or stage direction?

Perhaps an unpopular follow-up question is, will there be young men who get passed over in favour of women? Where's the line between gender imbalances and a competitive industry?

Finally, is it a form of equality to care more about the work than its creators?

>[Click here](http://www.tonictheatre-advance.co.uk/advance-2016/insights/) to read more findings from Advance 2016, & stay in the loop with [#TonicAdvance](https://twitter.com/search?q=%23TonicAdvance&src=typd).
