+++
author = ["authors/molly-simoneau.md"]
categories = "Review"
date = "2019-05-12T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "WNO's [production of _Tosca_](http://www.kennedy-center.org/calendar/event/OTOSF) runs through May 25."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1557686388/media/2019/05/sqWNOTosca.jpg"
primary_image_credit = "Keri Alkema in the title role of Tosca, Washington National Opera, 2019. Photo: Scott Suchman."
related_articles = ["articles/talking-with-singers-craig-colclough.md", "articles/talking-with-singers-keri-alkema.md", "articles/braid-brilliant-in-tosca-role-debut.md"]
related_companies = ["scene/companies/washington-national-opera.md"]
related_people = ["scene/people/david-cangelosi.md", "scene/people/alan-held.md", "scene/people/riccardo-massi.md", "scene/people/keri-alkema.md"]
short_description = "To me, Tosca is just about a perfect piece of theater. I think it's funny that it often gets dismissed as absurdly over-the-top melodrama, especially in this moment in time when Game of Thrones is so wildly popular, and the latest Avengers instalment is the highest grossing movie in theaters."
slug = "alkema-a-world-class-tosca-at-wno"
title = "Alkema a world-class Tosca at WNO"
youtube_url = ""

+++
I have to admit it: I'm a bit obsessed with _Tosca_. Of all the performances I've [reviewed for Schmopera](/authors/molly-simoneau/), _Tosca_ is the one that I know the best, inside and out. I just love this opera! I've probably heard just about every recording (I'm partial to Callas/Di Stefano/Gobbi 1953) and seen it live half a dozen times. I own the score, and as a singer, I've pored over the rambling first act love duet, marvelling at how brilliantly Puccini sets the text, alternating the musical mood from flirtatious staccato, to lustful and languid, to declamatory and frantic, and back around to the rich, luxurious melodies for which he is known best. I love Scarpia's bombastic theme which opens the opera, but isn't heard at all in the third act, after he is killed. And my friends all roll their eyes at parties when I get on the subject again of how time stops when Tosca sings "Vissi d'arte," and how that is one of the most magical moments in the operatic canon.

To me, _Tosca_ is just about a perfect piece of theater. I think it's funny that it often gets dismissed as absurdly over-the-top melodrama, especially in this moment in time when _Game of Thrones_ is so wildly popular, and the latest _Avengers_ instalment is the highest grossing movie in theaters. Don't we crave these kinds of stories? Stories about political intrigue, love, lust, sex, rape, torture, murder, suicide? _Tosca_ is par for the course nowadays.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557686432/media/2019/05/1.%20Riccardo%20Massi%20as%20Cavaradossi%20in%20WNO%27s%20Tosca.creditScottSuchman.jpg){{% /md %}}

<figcaption>Riccardo Massi (Cavaradossi) in Tosca, Washington National Opera, 2019. Photo: Scott Suchman.</figcaption>

</figure>

I think that's also why so few stage directors feel the need to "mess" with _Tosca_. The action unfolds in a way that is so tight, and the story is so timelessly relevant, with its noble political prisoners railing against a violently corrupt government official, there's really no need to add your own "spin." That which makes a good production of _Tosca_ comes town to detail - not just as it applies to the historical setting among three very specific actual places that you can visit in Rome (just ask any opera lover who has stood on the ramparts of Castel Sant'Angelo shouting "O Scarpia! Avanti a Dio!") but in the verismo character painting. And this brings me to WNO's production directed exquisitely by Ethan McSweeny. The slice-of-life detailing of McSweeny's production makes even the supernumeraries seem like authentic priests, choir boys, nuns, countesses, merchants, servants, soldiers. Under McSweeny's direction, even the soloists whose acting chops aren't as strong fail to pull you out of the world which he has so vividly painted.

As the painter, political dissident, and Tosca's doomed lover Cavaradossi, [Riccardo Massi](/scene/people/riccardo-massi/) was one such example of a weaker actor, whose over-the-top facial takes, and gestures border on camp, but he more than makes up for it with his lusty, open-throated singing. Massi's voice is old-school, like the great Italian tenors of the past, and is ideal for the role, in spite of the fact that his singing was all sort of evenly fortissimo, it's just so thrilling to listen to that I can't bring myself to care.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557686457/media/2019/05/6.%28l-r%29%20Alan%20Held%20as%20Scarpia%2C%20Samson%20McCrady%20as%20Sciarrone%2C%20and%20David%20Cangelosi%20as%20Spoletta%20in%20WNO%27s%20Tosca.creditScottSuchman.jpg){{% /md %}}

<figcaption>Alan Held (Scarpia), Samson McCrady (Sciarrone) and David Cangelosi (Spoletto) in Tosca, Washington National Opera, 2019. Photo: Scott Suchman.</figcaption>

</figure>

In her curtain speech, WNO artistic director Francesca Zambello took care to point out that the title role would be sung by [Keri Alkema](/talking-with-singers-keri-alkema/), a member of the very first class of the company’s Domingo-Cafritz Young Artist Program. As Tosca, Alkema does the program proud, skillfully tackling this challenging role which calls for delicate and then declamatory singing, and intense, emotionally taxing acting. Alkema is a world-class Tosca, charming the audience in the act one duet, before ripping their hearts out in act two, navigating the extreme vocal passages where Tosca desperately pleads for mercy, and then, yes, stopping time.

Those first two, iconic, unforgettable descending vocal lines of "Vissi d'arte" seem to arise from nothing, sung in a tissue-paper delicate pianissimo. Alkema achieves something that is so rare in performances of this well-known aria: subtlety. Her prayer rolls out of her mouth softly, in a way that makes the words seem new, as if I hadn't heard them sung a thousand times before, by two dozen other sopranos.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557686506/media/2019/05/8.%20Keri%20Alkema%20%28Tosca%29%20and%20Alan%20Held%20%28Scarpia%29%20in%20WNO%27s%20Tosca.creditScottSuchman.jpg){{% /md %}}

<figcaption>Alan Held (Scarpia) and Keri Alkema (Tosca) in Tosca, Washington National Opera, 2019. Photo: Scott Suchman.</figcaption>

</figure>

This exquisite rendering of the diva's anguished prayer makes it all the more viscerally compelling when the she finally delivers "Tosca's kiss" to the villainous Scarpia with a chest voice that made me want to hoot and fist pump.

In the third act, Alkema played a Tosca who was visibly shaken by the trauma of the previous scene, a Tosca who dared not hope for a happy ending, and ultimately, a Tosca with nothing to lose. Alkema's beautifully nuanced performance is more than worth the trip to the Kennedy Center, and that's before accounting for the luxury casting of [Alan Held](/scene/people/alan-held/) as the despicable Scarpia.

Held leaves no doubt as to who's in charge when his Scarpia enters a room. He moves slowly, when he moves at all. People come to him. The only one who seems to have any power over him is Tosca, when she holds out her arms for him to place her shawl over her shoulders, in a gesture of playacting civility. When he sings "Va! Tosca" his voice booms over the swelling orchestra with the ease you would expect from a highly respected Wotan, and as he proclaims "Tosca, me fai dimenticare Iddio!" the church set disappears in a bit of stage magic to leave Scarpia and the chorus standing in empty blackness.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557686533/media/2019/05/9.%20Keri%20Alkema%20as%20Tosca%20and%20Alan%20Held%20as%20Scarpia%20in%20WNO%27s%20Tosca.creditScottSuchman.jpg){{% /md %}}

<figcaption>Alan Held (Scarpia) and Keri Alkema (Tosca) in Tosca, Washington National Opera, 2019. Photo: Scott Suchman.</figcaption>

</figure>

The WNO orchestra is conducted by Speranza Scappucci who expertly brings out all the colors of Puccini's paintbrush, and the tempos never lag or become overly lugubrious as they so often do in Puccini.

A few other stand-outs deserve a mention. Bass Wei Wu plays a loveable Sacristan, with a warmth of tone and charming characterization. Tenor David Cangelosi's Spoletta is more than just the one-dimensional thug usually found in Tosca productions, did I catch a few glimpses of doubt about carrying out Scarpia's dirty deeds? Finally, treble Holden Browne sang the Shepherd Boy's song beautifully with a crisp, clear tone, opening the third act completely alone on the enormous stage, something that is difficult for even the most seasoned veteran performers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557686601/media/2019/05/WNOTosca.jpg){{% /md %}}

<figcaption>Keri Alkema (Tosca) and Riccardo Massi (Cavaradossi) in Tosca, Washington National Opera, 2019. Photo: Scott Suchman.</figcaption>

</figure>

Frankly, it would take a lot for me to not love a production of _Tosca_. I get swept up in it every time. But thankfully, WNO's production has a lot to love.