+++
author = ["authors/molly-simoneau.md"]
categories = "Review"
date = "2019-03-18T15:52:29+00:00"
disclaimer = ""
image_gallery = []
postamble = "Washington National Opera's production of _Faust_ runs through March 30. For details and ticket information, [click here](http://www.kennedy-center.org/calendar/event/OTOSD)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1552947140/media/2019/03/sqMargueriteErinWallWNOFaustScottSuchman.jpg"
primary_image_credit = "Erin Wall as Marguerite in Faust, Washington National Opera, 2019. Photo: Scott Suchman."
related_articles = ["articles/constructive-frustration-from-roh-s-queen-of-spades.md", "articles/a-problematic-creaky-old-masterpiece-les-vpres-siciliennes.md"]
related_companies = ["scene/companies/washington-national-opera.md"]
related_people = ["scene/people/raymond-aceto.md", "scene/people/allegra-de-vita.md", "scene/people/joshua-hopkins.md", "scene/people/marcelo-puente.md", "scene/people/erin-wall.md"]
short_description = "It doesn't help that Gounod's setting is about as dusty as operas get, focusing more on the downfall (and ultimate redemption in death, of course) of Marguerite, than on Faust's own psychological struggle, this opera always comes off like a parody of a 19th-century morality play, which was only emphasized by Staley's design which could have been pulled straight out of a European theater from 150 years ago."
slug = "overstaying-its-welcome-wnos-faust"
title = "Overstaying its welcome: WNO's Faust"
youtube_url = ""

+++
The Faust legend traces its roots back to the 16th century. The story was adapted as an English language play by Shakespeare contemporary Christopher Marlowe, and more famously by Goethe in the 19th century. Off the top of my head, I'm aware of three operatic settings of the tale, and a cursory glance at Wikipedia tells me there are 2 more on top of that (plus a musical by Randy Newman?) as well as several films. This is an _old_ story. The kind that infiltrates culture. Every time you mention someone making "a deal with the devil," you're referencing this ancient allegory.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552927799/media/2019/03/WNOFaustScottSuchman.jpg){{% /md %}}

<figcaption>A scene from Faust, Washington National Opera, 2019. Photo: Scott Suchman.</figcaption>

</figure>

Now there's something about _old_ things: they can be "classic," which is to say, timeless, never going out of style, or they can be cool and "retro," hitting our nostalgia buttons, or they can be stale, dusty, dated, old-fashioned. On Saturday night when WNO opened [its run of Gounod's _Faust_](http://www.kennedy-center.org/calendar/event/OTOSD) - directed by Garnett Bruce with production design by artist Earl Staley - I got the sense that they were going for "classic," but landed on stale and dusty.

> A bland opera can always be saved by first rate singing, so it's unfortunate that there was little of that to be had on Saturday night.

It doesn't help that Gounod's setting is about as dusty as operas get, focusing more on the downfall (and ultimate redemption in death, of course) of Marguerite, than on Faust's own psychological struggle, this opera always comes off like a parody of a 19th-century morality play, which was only emphasized by Staley's design which could have been pulled straight out of a European theater from 150 years ago.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552927893/media/2019/03/RaymondAcetoDeborahNansteelWNOFaustScottSuchman.jpg){{% /md %}}

<figcaption>Deborah Nansteel and Raymond Aceto in Faust, Washington National Opera, 2019. Photo: Scott Suchman.</figcaption>

</figure>

A bland opera can always be saved by first rate singing, so it's unfortunate that there was little of that to be had on Saturday night. In the title role, tenor [Marcelo Puente](/scene/people/marcelo-puente/), struggled, with a bleating voice and overly bright, forced high notes, and little stage presence to make up for his mediocre singing.

> He could have done even more with the role had he not been held back by the stiff staging.

Opposite him, as the innocent Marguerite, [Erin Wall](/scene/people/erin-wall/) offered some of the best singing of the night throughout most of the role, but her otherwise pleasant voice faltered in the very top of her range, and when she did fail on a few climactic high notes, she did so spectacularly, screeching, visibly straining, and running out of breath.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552927937/media/2019/03/RaymondAcetoMarceloPuenteErinWallWNOFaustScottSuchman.jpg){{% /md %}}

<figcaption>(l-r) Raymond Aceto, Erin Wall, and Marcelo Puente Faust, Washington National Opera, 2019. Photo: Scott Suchman.</figcaption>

</figure>

Baritone [Joshua Hopkins](/scene/people/joshua-hopkins/) sang beautifully as Marguerite's doomed brother Valentin, with a relaxed tone and sumptuous legato, and an easy top.

Bass [Raymond Aceto](/scene/people/raymond-aceto/) charmed the audience as the devil himself, Mephistopheles. It's a role that’s impossible not to love, and Aceto had fun with it, crooning along, before suddenly giving way to booming declamations, or growling, sinister whispers. No doubt, he could have done even more with the role had he not been held back by the stiff staging.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552927961/media/2019/03/oshuaHopkinsWNOFaustScottSuchman.jpg){{% /md %}}

<figcaption>Joshua Hopkins in Faust, Washington National Opera, 2019. Photo: Scott Suchman.</figcaption>

</figure>

As the lovesick Siebel, mezzo-soprano [Allegra De Vita](/scene/people/allegra-de-vita/) had a shaky start, but seemed to come into her own in her aria "Faites-lui mes aveux," but reverted back to her inconsistent sound later in the opera during her second aria "Si le bonheur à sourire t'invite."

> The opera world is chock full of exciting music and wonderful stories, so it's high time this stale old morality play gets left on the shelf.

Mezzo-soprano Deborah Nansteel brought a warm stage presence and luscious voice to the role of Dame Marthe, but was ill-served by the sexist gags in the libretto, which the staging emphasized.

In the pit, Keri-Lynn Wilson conducted Gounod's score enthusiastically, which often led to the orchestra overpowering the soloists, and occasionally failed to rein in the chorus rushing ahead of her baton.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552927948/media/2019/03/MarceloPuenteWNOFaustScottSuchman.jpg){{% /md %}}

<figcaption>Marcelo Puente Faust, Washington National Opera, 2019. Photo: Scott Suchman.</figcaption>

</figure>

There are a few operas that, while hugely popular in their day, have been mostly forgotten by modern audiences for one reason or another. Occasionally one will be "rediscovered," rarely to find a new place in the standard repertoire, but more often to the realization that it was forgotten with good reason. Then there are operas like Gounod's _Faust_ that make me wonder why it _hasn't_ been forgotten yet. The opera world is chock full of exciting music and wonderful stories, so it's high time this stale old morality play gets left on the shelf.