+++
author = ["authors/neil-weisensel.md"]
categories = "Review"
date = "2019-10-07T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Against the Grain Theatre's [production of _La bohème_](http://againstthegraintheatre.com/la-boheme/) continues its cross-Canada tour through Nov. 7."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1570494536/media/2019/10/sqOP190927_DSC4071_dznjel.jpg"
primary_image_credit = "Against the Grain Theatre's touring production of La bohème, photographed in Banff, AB, 2019. Photo: Jessica Wittman."
related_articles = ["articles/transladapted-bohème-offers-fresh-intimate-production-for-national-tour.md", "articles/hype-atg-boheme.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md"]
related_people = ["scene/people/jonelle-sills.md", "scene/people/gregory-finney.md", "scene/people/marcel-dentremont.md", "scene/people/giles-tomkins.md", "scene/people/danika-lorn.md", "scene/people/clarence-frazer.md"]
short_description = "Ivany told me that there are always audience members at these performances for whom opera is a new experience, and I think bringing opera to new audiences in this manner is a fantastic idea."
slug = "immersed-and-captivated-by-atgs-boheme-in-winnipeg"
title = "Immersed and captivated by AtG's Bohème in Winnipeg"
youtube_url = ""

+++
Two of my worlds collided when I went to see opera at The Pyramid Cabaret. I was a regular at the Pyramid (and its 90s predecessor, The Spectrum) and saw a lot of great bands there in the 80s and 90s, including The Bourbon Tabernacle Choir and… well, the rest is a blur. It was that kind of place.

As soon as I found out that Joel Ivany's Against the Grain Theatre was going to present Puccini's timeless masterpiece _La Bohème_ at my old haunt, I knew I had to be there. Ivany has been steadily gaining nationwide attention for his imaginative re-renderings of classic operas, from Mozart to Puccini and much more.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1570494644/media/2019/10/OP190927_DSC4139_dnjbg1.jpg){{% /md %}}

<figcaption>Against the Grain Theatre's touring production of La bohème, photographed in Banff, AB, 2019. Photo: Jessica Wittman.</figcaption>

</figure>

Ivany translates the original language of these operas into English, presents them in a new setting (like the cabaret we were in) and does an impressive job making these "transladaptations" fresh and new to the ears and eyes of a modern audience. I have seen _La Bohème_ on the mainstage a few times with full orchestra, and I have the full score in my library as for me, it's a bible of operatic orchestrating (I'm an opera composer).

> Sills is definitely a singer with a bright future.

So I know the story already, but spoiler alert – it does not end well! I had only ever heard it sung in Italian, so I knew it was going to be more approachable in English and updated to 2019 Winnipeg. This performance is part of Against the Grain Theatre's cross-Canada tour of the piece, travelling from Banff through Winnipeg to Toronto, then to the Yukon.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1570494657/media/2019/10/OP190927_DSC4179_kxrmbq.jpg){{% /md %}}

<figcaption>Against the Grain Theatre's touring production of La bohème, photographed in Banff, AB, 2019. Photo: Jessica Wittman.</figcaption>

</figure>

I found myself immersed and captivated by the story. Most of the performance held my interest so well, I forgot everything else and just allowed myself to be carried along by the beautiful singing and believable acting. In short, I forgot I was watching "a show", it seemed like real life (although one where everyone is singing). I started thinking about times in my own life that were reflected in the story I saw onstage.

> I had become so engulfed in the story, that I found I needed more time to grieve the loss of the characters onstage.

I was very touched several times – when Mimì (the lovely soprano [Jonelle Sills](/scene/people/jonelle-sills/)) hit her first high note, my eyes filled with tears. Sills is definitely a singer with a bright future. We don't usually hear voices of this calibre so close-up, and when the orchestra is replaced by a piano (played skilfully by Music Director David Eliakis), a level of intimacy is achieved that can't be matched by the mainstage experience. In effect, even though this is still opera, for me it becomes a different art form. Its scale and instrumentation makes it seem more like a musical, but a musical with some of the best music ever written.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1570494678/media/2019/10/OP190927_DSC4188_zx0emf.jpg){{% /md %}}

<figcaption>Against the Grain Theatre's touring production of La bohème, photographed in Banff, AB, 2019. Photo: Jessica Wittman.</figcaption>

</figure>

I was so into it, that at the extremely sad conclusion, I felt jarred when the lights came up and the performers hopped up, not dead anymore, to take their bows. I had become so engulfed in the story, that I found I needed more time to grieve the loss of the characters onstage. I especially loved how the second scene was set at the walk-up bar of the Pyramid.

The audience were so close to the singers, it was hard to determine one from the other (except when they started singing). The singers' interactions with the audience members at close quarters was something that never happens with a mainstage show. I also appreciated how the singers somehow managed to keep singing their tricky ensemble parts when they were mingled with the audience, and the piano being at the other end of the room – well done! Ivany has done a stellar job of adapting the Italian libretto to contemporary English.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1570494691/media/2019/10/OP190927_DSC4230_fd8cd6.jpg){{% /md %}}

<figcaption>Against the Grain Theatre's touring production of La bohème, photographed in Banff, AB, 2019. Photo: Jessica Wittman.</figcaption>

</figure>

There were many laugh-out-loud moments in the script, and the cast's crisp diction meant that you could understand practically every word they were singing.

Usually, when I think of opera, intimacy is not the first thing that comes to mind, but when a piece such as this is re-imagined to our own language and time, something special happens: the piece transports itself into our psyches with all-too familiar themes of our times – rising rents, the difficulty of finding financial reward as an artist, the spectre of illness – becoming top of mind.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1570494703/media/2019/10/OP190927_DSC4289_fnkg81.jpg){{% /md %}}

<figcaption>Against the Grain Theatre's touring production of La bohème, photographed in Banff, AB, 2019. Photo: Jessica Wittman.</figcaption>

</figure>

Ivany told me that there are always audience members at these performances for whom opera is a new experience, and I think bringing opera to new audiences in this manner is a fantastic idea. I wish him, the cast and crew safe travels as they continue to Kenora, Thunder Bay and beyond.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1570494716/media/2019/10/OP190927_DSC4373_naavvv.jpg){{% /md %}}

<figcaption>Against the Grain Theatre's touring production of La bohème, photographed in Banff, AB, 2019. Photo: Jessica Wittman.</figcaption>

</figure>