+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-05-16T14:58:00+01:00"
lastmod = "2016-05-22T10:47:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463433525448/2016-05-17---Florence-Foster-Jenkins.jpg.jpg"
publishDate = "2016-05-16T22:19:00+01:00"
related_articles = ["articles/gibson-girls-and-the-great-opera-theyd-make.md","articles/elitism-irony-and-the-phantom-of-the-opera.md","articles/familiar-exotic-a-brief-history-of-bellinis-norma.md","articles/michael-tilson-thomas-takes-on-ruggles-mozart-mahler.md"]
short_description = "Even the legend of Jenkins is almost enough to bring tears to our eyes. She went through a lot of tough stuff, and it&#039;s poignant for us, as writers of reviews, that even she, with all her well-placed ignorance and unashamed love for music, was deeply hurt by the negativity hurled at her from critics. Aren&#039;t we all searching for Jenkins&#039; mix of unapologetic joy, and transparent vulnerability?"
slug = "why-we-all-love-florence-foster-jenkins"
title = "Why we all love Florence Foster Jenkins"
+++

Within the competitive industry of opera singers, full of high standards and aspirations of pitch-perfection, why is it that we have such unashamed love for history's most famous terrible singer?

The story Florence Foster Jenkins (1868-1944), American socialite and lover of music, has been the source of plays like the Edinburgh Fringe's *Viva La Diva*, and the award-winning *Glorious!*, which hit London's West End in 2005; now, opera fans are beyond excited about the upcoming documentary, [*The Florence Foster Jenkins Story*](https://www.facebook.com/FFJStory/videos/1683420728565684/), featuring star mezzo-soprano [Joyce Di Donato](/scene/people/joyce-di-donato/) as Jenkins. "If I could say one thing to Florence Foster Jenkins," says Di Donato, "I think I would say, 'you go, girl'."

And of course, we're all drooling over Meryl Streep's sure-to-be-heartbreaking portrayal of FFJ in the film [*Florence Foster Jenkins*](http://www.imdb.com/title/tt4136084/), due out this August:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/LqNg3_3kpQQ" frameborder="0" allowfullscreen></iframe>
</figure>

Everybody loves someone who takes what they're passionate about, and follows it through, 1000%. That's Jenkins. She was a concert pianist whose career was cut short after an injury to her left arm. When her father died, and left her a sizeable inheritance, she suddenly had the means, once again, to make music with her life. She was completely convinced of her talent as a singer, despite her lack of rhythm, intonation, and almost everything else on the endless list of technical details that opera singers spend their lives perfecting.

But what comes to her so easily is something that's almost as difficult as pulling off that perfect phrase: confidence in oneself. Who can argue with confidence? And confidence plus undeniable love for singing? How endearing can you get?

There's also something appealing and heartwarming about someone who's not intimidating. Opera singers can seem almost superhuman in their skills, but Florence Foster Jenkins is another story. She was surrounded by mystery; audiences wondered if her terrible technique was all an act, a prolonged publicity stunt to pique curiosity. She was a treat for the eyes, if not the ears, famously photographed with angel wings, and known for flinging flowers at her listeners at her recitals. With money at her disposal, she pulled off an infamous invite-only concert at Carnegie Hall, with people like Lily Pons and Gian-Carlo Menotti in the audience.

Jenkins' career was almost picture-perfect example of singing for the right reasons. In a tragic, almost operatic finale, she died of a heart attack two days after her big Carnegie debut. The recital was the only performance where Jenkins could not prevent critics from attending, as she had in her previous private concerts; it's said that their harsh reviews were extremely painful for Jenkins to read.

For almost her entire life, it seems as though Jenkins was immune to the ebb and flow of the average opera singer's passion for their work. Perhaps it was her life as pianist, cut short by circumstance, or perhaps it was just *her*; only an unwavering love of singing could prompt the tireless work it takes to prepare, produce, and pay for all those recitals, recitals, recordings, photography, and her charming *tableaux-vivants*.

Of course, with each passing, year, Florence Foster Jenkins becomes more and more a legend, and the tales of her life may start to edge further from the truth. But even the legend of Jenkins is almost enough to bring tears to our eyes. She went through a lot of tough stuff, and it's poignant for us, as writers of reviews, that even she, with all her well-placed ignorance and unashamed love for music, was deeply hurt by the negativity hurled at her from critics. Aren't we all searching for Jenkins' mix of unapologetic joy, and transparent vulnerability?

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/DMu9PKWthLE" frameborder="0" allowfullscreen></iframe>
</figure>
