+++
author = ["authors/jennifer-rivera.md"]
categories = "Op-ed"
date = "2016-01-04T13:25:00-05:00"
lastmod = "2016-01-04T14:18:00-05:00"
preamble = "We're happy to share an article by [Jennifer Rivera](/scene/people/jennifer-rivera/), mezzo-soprano, writer, arts advocate, and Director of Artistic Development at [The Center for Contemporary Opera](http://centerforcontemporaryopera.org/) in New York. She chats about taking offstage jobs, the stigma that comes with that decision, and seeing the operatic forest for the trees. Check out the [original article]((http://www.huffingtonpost.com/jennifer-rivera/why-this-opera-singer-too_b_7548460.html)) on *Huff Post*, and read more by Rivera [right here](http://www.huffingtonpost.com/jennifer-rivera/)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1451933184123/2016-01-04---NonOperaJob.jpg.jpg"
primary_image_credit = "Photo: Shutterstock."
publishDate = "2016-01-04T14:18:00-05:00"
related_articles = ["articles/artists-administration-reputations.md","articles/giving-up-caring-too-little-and-other-taboos.md","articles/breaking-into-the-industry-a-vicious-cycle.md","articles/risky-opinions-there-are-2-types-of-singers.md","articles/moving-on-up-3-ways-my-old-career-prepared-me-for-my-new-one.md"]
related_people = ["scene/people/jennifer-rivera.md"]
short_description = "While directors and conductors often hold directorships and administrative positions within opera companies, singers themselves rarely have the opportunity to continue to perform while contributing to the other side of the footlights. There is definitely a stigma attached -- that if you have time for any kind of other job, your singing career must not be going well. "
slug = "why-this-opera-singer-took-a-nonsinging-job-at-an-opera-company"
title = "Why This Opera Singer Took a Non-Singing Job at an Opera Company"
+++

Some people dream of becoming famous, or winning the lottery, or becoming a size 2 just in time for their high school reunion. Some people dream about becoming an opera singer and traveling all around the world, singing in historical theaters and sipping cappuccinos in piazzas and Hefeweizen in beer gardens. 

I did dream about those things once upon a time, but found that while I was doing them, I was dreaming of something else as well -- and that was working behind the scenes at an American opera company in order to work towards changing the way opera is perceived in this country. I know, it sounds like an annoyingly lofty goal, but when you've spent the number of years I have living with this art form (I started taking legitimate singing lessons from a retired opera singer when I was nine years old), when you've had the opportunity to experience the transformative power of this particular type of music theater over and over, while simultaneously feeling that almost nobody you meet in airports and shopping malls has any concept of what you do much less how much power the unamplified voice can have, you dare to dream big.

So for all these years that I've been lucky enough to get to fulfill my first dream, and get to collaborate with amazing musicians and conductors and directors all over the world, I've been dreaming about how I was going to fulfill this second dream - this nagging responsibility I felt to be part of the solution of bringing opera to more people - especially to more Americans, where the cultural history of opera just doesn't exist as part of our national discourse. 

I haven't exactly been very secretive about this dream of mine - I was constantly quizzing every General or Artistic Director who would give me a few minutes of their time about what worked and what didn't, and more publicly, I started writing editorial articles about Arts Advocacy for this little publication you are reading right now. With a national platform, I just couldn't keep my mouth shut about why The Arts matter in this country right now more than ever, why we need to work harder to bring this particular art form to more people's attention, and how we can go about doing that.

Which is what brings me to today's announcement; I have accepted a position at The Center for Contemporary Opera in New York City as the company's very first Director of Artistic Development. In addition to my ongoing singing career, I will be overseeing development and marketing campaigns seeking to increase the financial stability and visibility of CCO, as well as assisting with future artistic and strategic planning. In other words, I finally get to work at an opera company doing the one thing I might be even more passionate about than singing; bringing opera to as many people as possible. 

The Center for Contemporary Opera is a particularly good fit for me, since my singing career has allowed me the opportunity to observe first hand the power contemporary opera has in creating new opera audiences. When a story is told with music theater by living composers in a modern idiom in the audience's native language, it removes most of the barriers people generally associate with opera right off the bat. Not to mention supporting the works of living, working composers keeps opera alive and vibrant and pushes the art form forward in immeasurable ways.

The Center for Contemporary Opera is now the second oldest opera company currently operating in Manhattan (only the Metropolitan Opera is older). It was founded in 1982 by new music proponent Richard Marshall, who ran the company for 26 years without ever paying himself a salary. During that time he produced forty three fully staged operas including nine world premieres. He founded the company at a time when small "start up" opera companies were not the norm, and kept the company running and presenting new works as well as neglected contemporary operas that had already premiered, giving countless living composers the opportunity to have their works presented in New York City, as well as delivering opera theater to New York audiences that couldn't be seen elsewhere- all out of personal dedication and passion.

The Center currently produces everything from fully staged productions, some of which have toured to theaters in Europe, to first readings of new works with a few singers and a piano. It provides every part of new work development, from laboratory to finished product. It is one of only three companies in New York City employing a union orchestra, and has continued to operate despite the financial turmoil every single arts organization finds themselves facing since the economic crash of 2008. 

The current General and Artistic Director, James Schaeffer, is another passionate proponent of contemporary music who has taken the financial and economic hurdles everyone has struggled with in stride, finding creative solutions to continue to produce opera even during this challenging fiscal period. He is now ready to push the company forward and encourage a growth spurt, hence the hiring of yours truly.

I find it fascinating and a little frustrating that while directors and conductors often hold directorships and administrative positions within opera companies, singers themselves rarely have the opportunity to continue to perform while contributing to the other side of the footlights. There is definitely a stigma attached -- that if you have time for any kind of other job, your singing career must not be going well. 

But I think we are also saddled with the problem that artists aren't taught enough social responsibility as part of their contribution to any art form. On the one hand, being an opera singer requires so many varied skills that it could certainly be seen as "enough for one person to do." However I firmly believe that in the current vortex of cultural unawareness, each artist must take some sort of responsibility to encourage the continuance of opera - if only so that we can have some jobs in the future! 

But more than that, we possess the knowledge of the extreme power of this combination of music and drama, and we have a responsibility to impart that knowledge to as many people as we can. Whether it be striking up conversations with strangers and encouraging them to check out a YouTube clip, inviting other diners in the restaurant where you are eating to your upcoming performance, starting your own art song festival in your local library, or even working for an opera company in some capacity. 

The challenge of making sure opera remains a necessary artistic element of the 21st century in the United States belongs to all of us, and I am thrilled with my new opportunity to participate in this mission.
