+++
author = ["authors/christopher-enns.md"]
categories = "Op-ed"
date = "2016-11-29T18:12:00+00:00"
lastmod = "2016-11-30T16:16:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480443871710/2016-11-29---Crumpled-Bill.jpg.jpg"
publishDate = "2016-11-30T16:02:00+00:00"
related_articles = ["articles/what-crippling-stage-fright-taught-me-about-money.md"]
short_description = "There are a million ways to communicate an awesome idea. I sing opera. Maybe you paint on canvas, or channel your soul through the words of Shakespeare. There are also a million ways to make peace with money. I use financial planning and teach it to others, but that doesn&#039;t mean it&#039;s the right tool for you."
slug = "why-mezza-voce-and-budgets-really-dont-matter"
title = "Why &#039;mezza voce&#039; and budgets really don&#039;t matter"
+++

Budgets don't matter.

I was doing a [podcast](http://www.overthoughtpodcast.com/) a little while ago, talking to two fellow opera singers about what I love about personal finance and financial planning, and one of the hosts stopped me and said something like:

"Look, I hear what you’re saying, and it sounds great… like it's this game-changing thing… but it can’t be that easy."

(… that's a horrible misquote of a much more eloquently expressed thought, but it's been rolling around in my mind for a while now…)

It's such a trap to write about something you believe is a transformative tool that everyone needs.

Because… everyone doesn't need it.

That's right. I said it. Not everyone needs this personal finance/financial planning stuff. Some people are fine. And if everything is honestly working fine… why micro-manage it? It's working.

And for those of us that aren't doing fine… it's not easy. It's really difficult… but not for the reasons you might think.

**Consider this massive oversimplification of my job as an opera singer:**

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480443323144/2016-11-29---Opera-Oversimplification.jpg.jpg)
</figure>
 
When I'm singing my main goal is to communicate an awesome idea or emotion to another person.

There are a lot of tools to help this happen: staging, lighting, vocal colour, and of course … the baritone claw. But the whole point it to get that idea from my brain to that other person’s brain.

But I forget that all the time.

I'll be sitting in a masterclass, or a performance and hear some insane piece of technique. A *mezza voce* that stops my soul, or a bone-shaking resonance and immediately I'm thinking…

"How cool would it be if I could do that?"

So I run to the practise room and obsess about *mezza voce* for the next 6 months, or in one unfortunate period of my life it was trying to master the goat trill.

The problem is that the tool doesn't matter on its own. If it's not helping my overall purpose of communicating an awesome idea… it's kind of useless.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480443395040/2016-11-29---Opera-Oversimplification-2.jpg.jpg)
</figure>

And let’s be honest. I’m oversimplifying the purpose of opera by saying it's "just communicating an awesome idea." It makes it sound like something simple…

… but you know it's not. It's freaking hard.

It takes years of mastery. It's not a matter of "just" doing anything. It's a combination of a thousand ever-changing factors and tools that match with your deepest, darkest identity.

It's the same with money.

What if the oversimplified purpose of your life is to take the values that you find really important (family, beautify, justice) and put them into the world.

Money is one of the tools that helps you do that.

The challenge is to connect your money with your values to create a life that you’re happy with.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480443463317/2016-11-29---Money-Oversimplification.jpg.jpg)
</figure>

Now, you might need some tools to help you with that…

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480443509474/2016-11-29---Money-Oversimplification-2.jpg.jpg)
</figure>

But that basic goal is what matters. Not financial planning, not budgets, not any tool or ideology at all.

There are a million ways to communicate an awesome idea. I sing opera. Maybe you paint on canvas, or channel your soul through the words of Shakespeare.

There are also a million ways to make peace with money. I use financial planning and teach it to others, but that doesn't mean it's the right tool for you.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480444113670/2016-11-29---Budgets-don't-matter-facebook.jpg.jpg)
</figure>

If you want to learn more about how financial planning, personal finance, and getting control of your money can help you be a better artist, visit [Rags to Reasonable](http://www.ragstoreasonable.com/) for free resources, DIY tools, and one-on-one advice for artists (by artists).
