+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-05-29T20:01:00-04:00"
lastmod = "2017-05-29T21:14:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496105843045/2017-05-30---Rat.jpg.jpg"
publishDate = "2017-05-29T21:14:00-04:00"
short_description = "After all, opera isn&#039;t just music, and it isn&#039;t just theatre. If it&#039;s well-written opera, the music we hear is directly connected with the action and text. I often wonder: if people had heard famous film scores - Psycho, Star Wars, etc. - without having ever seen the films, would they find the music appealing? Would they find the Imperial March catchy, or full of wrong notes? If they thought those sawing strings from Hitchcock&#039;s shower scene sounded screechy and ugly, could they be blamed?"
slug = "why-is-it-ugly-other-good-questions-about-new-opera"
title = "&quot;Why is it ugly?&quot; &amp; other good questions about new opera"
+++

If you're someone who goes to hear a lot of opera and concerts, you're likely exposed to a fair amount of what's called "contemporary" music. Defining "contemporary" is a funny thing. Strictly speaking, it means music written in our time; like the term "modern", "contemporary music" can also be a common blanket label for music that's actually decades old - just not centuries old.

Contemporary music is also synonymous with sounds that are weird, or even ugly. It's apparently *so ugly*, that a music fan who enjoys the varied sounds of Monteverdi, Mozart, Berlioz, and Verdi, can draw the line at Stravinsky. Augmented chords are ok, they may say, but sustained minor seconds are a no.

I'm wise enough to avoid the argument that one's personal taste is "wrong"; if you're not down with dissonance, so be it. You can choose your concert-going calendar accordingly. But it's an odd thing to hear contempt for contemporary music when we're talking about opera.

I've overheard moanings over dissonance at performances of Shostakovich's [*The Nose*](/jaw-dropping-the-nose-at-roh/), over the piercing piccolo lines at Aaron Gervais' [*Oksana G.*](/tough-to-watch-oksana-g/), and in opposition to the Harry Somers' aggressive score to [*Louis Riel*](/discomfort-louis-riel-at-the-coc/). Existential questions like, "why can't it be beautiful?" are muttered as the audience files out of the theatre; in the restrooms and at coat check, you can overhear words like "cacophony" and "unmelodious".

When we think back to the riotous premiere of works like Stravinksy's *Rite of Spring* or even Bizet's *Carmen*, it's easy to see that those who complain about unfamiliar sounds inevitably end up on the wrong side of history. They read like fussy Puritans, providing the enlightened music students of the 21st century with fun stories of the olden days; these early 20th-century folks freaking out over Strauss and Schoenberg didn't know the *meaning* of the word "dissonance", did they?

And still, there exist people who are righteously and stubbornly opposed, as a matter of principle, to "contemporary opera". Like the concertgoers who opt for Beethoven over world premieres, opera fans are entitled to their opinions. So, a question for you:

Is it fair to say that people who go to the opera to hear beautiful music are missing a large part of the point?

After all, opera isn't *just* music, and it isn't *just* theatre. If it's well-written opera, the music we hear is directly connected with the action and text. I often wonder: if people had heard famous film scores - *Psycho*, *Star Wars*, etc. - without having ever seen the films, would they find the music appealing? Would they find the Imperial March catchy, or full of wrong notes? If they thought those sawing strings from Hitchcock's shower scene sounded screechy and ugly, could they be blamed? 

It's a silly hypothetical, maybe. But the point is that, like film scores, operatic scores are only part of the puzzle.  Luckily, for the firmly ugly-averse, there's a current trend towards a more romantic, tuneful aesthetic happening among new opera composers; you can hear it in the work of people like Kevin Puts and John Estacio. 

I can't help but wonder if pronouncing a score un-beautiful isn't a quick way to limiting one's options. When it comes to telling stories, is there not a place for "ugly"? Does ugliness make for better drama, or does it divide opera fans into those who can weather the storm, and those who can't?

Readers, how much ugliness can you handle at the opera?

