+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-01-20T09:27:00+00:00"
lastmod = "2017-01-20T12:46:00+00:00"
preamble = "Compared to the cutthroat worlds of Broadway or Hollywood, opera may seem a noble art; since it's \"all about the voice\", opera demands that producers cast a broader variety of looks onstage. And yet, with the advent of opera-in-HD, and as more and more young artists vie for professional experience, experienced singers can find themselves excluded.\n\nThe idea of ageism in the opera industry was raised by Canadian mezzo-soprano [Kimberly Barber](/scene/people/kimberly-barber/), whose career includes everything from Mozart to world premieres, and who also teaches voice at Wilfrid Laurier University in Waterloo. She talks with us about her perceptions of a \"youth-obsessed\" opera world, and why companies should be paying attention to singers who have longevity."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484904559739/2017-01-17---Ageism---Cosi-fan-tutte---Dahl-and-Allen-Michael-Cooper.jpg.jpg"
primary_image_credit = "Tracy Dahl (Despina) and Sir Thomas Allen (Don Alfonso) in the COC's production of Così fan tutte, 2014, photo: Michael Cooper."
publishDate = "2017-01-20T10:38:00+00:00"
related_articles = ["articles/talking-with-singers-gregory-kunde.md","articles/coaches-voice-teachers-and-the-grey-area-in-between.md","articles/talking-with-singers-sondra-radvanovsky.md","articles/graceful-exits-double-standards.md"]
related_companies = ["scene/companies/calgary-opera.md","scene/companies/tapestry-opera.md","scene/companies/pacific-opera-victoria.md"]
related_people = ["scene/people/kimberly-barber.md"]
short_description = "&quot;In later career, there is much less forgiveness for a less than standard performance, whether it is loss in vocal function, beauty, tone quality or whatever, there is much less margin for error. As a young singer, you are perceived as fresh and new, so companies are willing to give you more chances. It is much more challenging to maintain a career as you age than it is to begin. Companies will often hear younger singers in audition again and again, while they often dismiss older artists.&quot;"
slug = "whos-afraid-of-the-aging-singer"
title = "Who&#039;s afraid of the aging singer?"
+++

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484905015840/2017-01-19---Barber-4.jpg.jpg)
<figcaption>Kimberly Barber, mezzo-soprano. Photo by Helen Tansey, Sundari Photography.</figcaption>
</figure>

## What form does ageism take in the opera business?

We live in a youth-oriented, youth-obsessed culture. In the performing arts the focus on the youthful prodigy, the "next new thing" has been pervasive, often causing older, more experienced performers to be sidelined and replaced with newer, younger versions as they approach mid-late career. Fees have stagnated in the industry over the last many years, and although more experienced artists generally expect incrementally higher fees over their years of service, they don’t always receive them. 

Producers wishing to save money often look to hire younger, less experienced singers who will accept lower fees. This is true even in roles that are written for older characters which require more life and acting experience — "gravitas".

## What assumptions about older singers do producers make?

Producers and agents make several assumptions about older singers. 

- If they begin teaching (which for many is a logical and rewarding professional development), they are no longer going to be active professionally as singers/performers (or even that teaching somehow makes them less desirable as performers).
- They are "too old" for certain repertoire, even perhaps roles that ought to be considered "pinnacles" of a career (I am not talking about the Cherubinos or the Zerlinas of this world, but rather the mature singing roles — title characters that are vocally and histrionically demanding).
- They will be inflexible artistically. Nothing could be further from the truth, especially if the artist feels they are validated and supported in their risk-taking by peers, director and conductor.
- If they have diminished vocal prowess (loss of range, flexibility, a less "youthful" sound) that they are not viable. The youth culture is so widespread that even artists in their early 40’s are often thrust into older "character" parts well before their time, unless they are absolute A-listers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484904841800/2017-01-18---DeadManWalkingcar.jpg.jpg)<figcaption>Kimberly Barber as Sister Helen in *Dead Man Walking*, Calgary Opera, 2006. Photo by Trudie Lee.</figcaption>
</figure>

## What sort of recognition or respect should older singers expect?

Since almost ALL vocal artists experience vocal changes as they age (with many artists of great longevity reporting multiple times of vocal crisis), they ought to be supported and nurtured through these transitions. Artists of a certain age draw on a vast amount of experience, both in the profession and in life that they can bring to bear in their interpretation of more complex roles, both vocally and interpretively. Artists who have had long careers deserve to find a place — even if it is no longer in the major parts. They can play an important role-modeling and mentoring role for younger artists as they age, but are frequently not given the opportunity. 

It was incredibly rewarding for me to be offered the role of Regina Giddens in Pacific Opera Victoria's *Regina* later in my career (and I’d do it again in a heartbeat — anyone listening??!). A role of this kind of complexity would have been completely beyond me as a younger artist, and frankly, I would have been frightened by the amount of dialogue and the transitions from chest into chest-head mix that were required of the role. 

I received some of the best reviews of my career for this part, and I am grateful to Tim Vernon for honouring me with this assignment. It was also doubly thrilling to work alongside such veteran colleagues as Greg Dahl, Patrick Raftery, Kathleen Brett and Doug MacNaughton, all of whom brought tremendous acting and singing experience and depth to their parts. Rehearsals were pure joy.

## How do singers adapt to fewer job opportunities?

Singers adapt in multiple ways by expanding their idea of what a career in the arts means. Many gravitate towards teaching, whether in the voice studio or in master class. Lots of them go back to school and gain licensing or accreditation in related disciplines — yoga, Alexander Technique, massage therapy, arts management, life coaching, voice over acting, advisory boards etc. These singers diversify and take on other roles, or even manage a total career change — chef, caterer, entrepreneur. 

But to be honest, many singers feel a tremendous loss when they are no longer able to practice their profession. When I was fest in Germany, there were so many singers in the opera house who had been leads in their younger days who transitioned successfully and happily well into old age singing secondary leads and then comprimario or character parts. They were valued members of the ensemble and enjoyed tremendous respect amongst their colleagues. Often their performances stood out for the degree of pathos or superb comedic timing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484904685563/2017-01-18---Barber-Dahl-MacNaughton.jpg.jpg)
<figcaption>Kimberly Barber (Regina), with Doug MacNaughton (Ben Hubbard) Gregory Dahl (Oscar Hubbard), *Regina*, Pacific Opera Victoria, April 2008. Photo by Pink Monkey Studios.</figcaption>
</figure>

## What is the difference between the struggles of an emerging artist to establishing themselves and a mid- to late-career singer in a "slump"?

In later career, there is much less forgiveness for a less than standard performance, whether it is loss in vocal function, beauty, tone quality or whatever, there is much less margin for error. As a young singer, you are perceived as fresh and new, so companies are willing to give you more chances. It is much more challenging to maintain a career as you age than it is to begin. Companies will often hear younger singers in audition again and again, while they often dismiss older artists. Older singers need to constantly market themselves and ply their contacts to ensure that they are being considered for roles, even (often) at companies where they have a long history of performing. 

## What could companies and agents gain from being less ageist?

As in the acting profession, there can be really juicy parts for older singers so long as one is willing to allow for some loss in flexibility, volume, velocity and resonance. Older artists can give really dynamic performances in character parts, since they are such experienced practitioners. 

Even casting 'against type' can make a powerful statement—one example of recent note was Tracy Dahl's turn as Despina in the COC's *Così fan tutte* a few years ago, where her wit, charismatic stage persona and still vibrant, beautiful voice were a standout in a role that is often cast with a young soubrette. She brought an intelligence and depth to the role that a younger artist simply could not have achieved.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484904706974/2017-01-18---Barber-2.jpg.jpg)
<figcaption>Kimberly Barber, mezzo-soprano. Photo by Helen Tansey, Sundari Photography.</figcaption>
</figure>

## What sets the successful late career singers apart from their peers? How are they able to be successful?

The singers who last in the profession are incredibly passionate about the repertoire, the profession and the craft. They are persistent to the point of obsession! They also work assiduously at caring for their vocal instrument and maintaining its health. They are willing to transition into different parts as they age, often changing fach or genre. 

For some of them, it's the enormous success of their earlier careers that allows them to continue to work, because they remain beloved despite any possible vocal shortcomings or hiccups in their vocal state later in life. Joan Sutherland would be a strong example of this—presenters and audiences alike were extremely forgiving of a prominent artist whose voice was audibly in decline.
