+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-02-09T09:05:00-05:00"
lastmod = "2015-04-28T20:52:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1430268692620/mozart_Fotor.jpg.jpg"
publishDate = "2014-02-09T09:05:00-05:00"
related_articles = ["articles/don-giovanni-at-the-estates-theatre.md"]
slug = "who-cares-what-mozart-loved"
title = "Who cares what Mozart loved?"
+++

I hear a lot of weird stuff at work. My job gives me the chance to sit in many a coaching or voice lesson and listen to how others impart wisdom and skills upon hardworking singers. Today, I heard the phrase, "Mozart loved portamento!" backed up with supposed evidence in Mozart's letters to his father.

And these three harmless words irked me. Why? You probably think I'm going to talk about the validity of historical evidence, or bring up some musicological debate so inconsequential it hurts. But frankly, when it comes to an assertion like "Mozart loved portamento!" music history isn't even what's important.

For example: there's this spot in one Mozart aria that shows two notes, over one syllable, with a slur between them. In most opera singers' books, that equals a portamento. (It's tedious to define it, so if you're not sure what a portamento is, click _[here](http://en.wikipedia.org/wiki/Portamento)_.) There are plenty of debates about what Mozart's music should sound like, including the use of bendy pitches, i.e. a portamento. But one constant truth in the debate is that Mozart loved the human voice and loved to write for it.

A statement like "Mozart loved portamento!" implies that there had been a question on whether or not the use of portamenti was stylistically appropriate. That's such a _boring_ question. The question should be, "How do I make my voice sound like what the text means?" If it means singing with more tension between each pitch, or bending pitch to get the affect of joy, loss, or lust, why not? Why would you take that tool off the table?

Mozart has written music that remains relevant over 200 years after his death; it was not the singers who premiered _Le nozze di Figaro_ or _Die Zauberflöte _that placed Mozart's operas among the most essential and influential in history. It was the music itself.

And so I use the pros and cons of using a portamento in Mozart as an example: if there's nothing fallable, fragile, or spontaneous about a singer onstage, then there is nothing human, cathartic, or entertaining about the performance.

I've referenced my director friend before; he maintains that Mozart was the greatest stage director to have lived. You can see what my friend means in simply the pages of the score. Any singer who has prepared an accompanied recitative by Mozart gets what I'm saying. Donna Anna, anyone?

<figure adat-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/-2RRyr9ZGQU" frameborder="0" allowfullscreen></iframe>
</figure>

That's the difference between a dead composer and a working artist - one can still make decisions. But the decision should always be in the interest of serving the text. If it means siding with the Historically Informed Performance side of things, cool; if not, accusations of a stylistic faux-pas are unproductive. Mozart has written music that needn't be framed by historical practice, but by the ability to marry text to music.

So: "Mozart loved portamento" only means that Mozart loved expression. I don't know whether that sentence is more boring or redundant.
