+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-07-12T10:55:00-04:00"
lastmod = "2018-01-03T10:06:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1514991954900/2018-01-03---Why.jpg.jpg"
publishDate = "2014-07-12T10:55:00-04:00"
related_articles = ["articles/opera-for-firsttimers-thinking-outside-the-box.md","articles/arizona-opera-on-tradition.md","articles/does-new-opera-raise-the-bar-for-performers.md","articles/concept-production-real-reason.md","articles/morbid-musings-art-death.md","articles/new-opera-honest-marketing.md","articles/the-real-reason-to-bring-teens-to-the-opera.md"]
short_description = "If I were the artistic director of my own opera company, I&#039;d probably enjoy putting up whatever shows I please. There would be a lot of Britten in my seasons. The question would be, would people want to go see the shows I like best?"
slug = "who-cares-what-bring-on-the-why"
title = "Who cares what? Bring on the why"
+++

If I were the artistic director of my own opera company, I'd probably enjoy putting up whatever shows I please. There would be a lot of Britten in my seasons. The question would be, would people want to go see the shows I like best?

It's an important question, because it gets us to the topic of getting more and more people to the opera (willingly, even). When a company decides what shows will make up a season, it's a fair assumption that, mixed in with some of the opera bosses' personal favourites, they'll choose at least _some_ shows that the average audience member would want to go and see. They'll try to cover the aesthetic gamut: some Puccini that's easy on the ears, some Verdi with grandeur and famous tunes, some Mozart or Rossini for comedy, and maybe some Wagner to prove that theirs is a Serious Opera Company. A show by Britten, perhaps, or even something _even more modern_, will be gingerly placed into the season, often in the same way that one picks up an overused dish sponge and tosses it in the trash.

So, what's so bad about trying to offer up a season of operas that cover different styles and time periods? Nothing, except the time and energy spent on the decisions are surprisingly wasted. Ironically, the people making these decisions are poorly equipped to judge what a general audience wants to see. Opera folks simply aren't like other folks (and I wouldn't have it any other way). But even if their oddities could be tempered, they're still too well-informed. I've had conversations with colleagues about how certain operas grew on them; they worked on a show, or saw it a bunch of times by accident, and they grew to love the piece. That's great, but where does that leave the potential audience, who didn't spend months immersed in the piece and has yet to even see it? The general public knows good drama, because they watch _Breaking Bad_, and they know how music moves us, because they go to _Les Misérables_ and listen to the Rolling Stones. Opera is on par with _these_ art forms; it is not above nor aside, and it is definitely not exempt.

Think about it: if you were to ask a slice of the general public what operas they'd like to see this season, they might shrug, or ask you to repeat the question. This doesn't mean that the general public are stupid consumers of lesser art forms. It just means that opera isn't as familiar to them as television or even straight theatre. It should be liberating to the opera bosses to know that a "well-chosen" line-up of shows does not decide how large the audiences will be. They don't need to worry about it. I'll say it again: what's worth worrying about is story-telling.

It really is as simple as that. I don't even have to qualify that the chosen opera should be a "good" one, that the words and music should be well-crafted and all that; if an opera really does tell a story, these elements are in place by default. The corollary is also true: if an opera doesn't have something to say, it doesn't matter who wrote it or how old it is. It's simply not going to move people. I have trouble with a lot of _bel canto_ repertoire, for example, because in it I haven't been able to find a story that can be told today without multiple layers of apologetics and contexts in the way. Sure, the music is stunning, and the vocal feats required of the singers are extraordinary. To be fair, the function of _bel canto_ is to clear the way for gorgeous singing; but if you're not equipped to really appreciate it, all the beautiful Bellini tunes in the world couldn't make up for the fact that there are obvious and distracting weaknesses in the plots. 

I've said it before: we should take stock of these so-called canonical pieces, and re-evaluate their stage potential today. If the goal is to prove that opera is relevant, let's be done with opera plots that feature hyperbolic emotional reactions and failed communication between characters. And if the goal is to tell a story, then a company will opt for shows with the potential to do so.

I don't doubt that the aim of many major opera companies is to wow their audiences and get them to come back. But is it too much to ask that they attempt to produce at least a few shows that don't need a pre-show talk or a skim through the synopsis in advance? These are the things that make opera inaccessible, especially when there exist other forms of theatre that are densely creative and don't require an introductory course? 

If Wagner's *Ring Cycle* will move people, it's not because [Carl Jung](http://stottilien.com/2012/07/19/c-g-jung-and-wagner-rainy-gotterdammerung-in-munich/) or because [_leitmotif_](http://en.wikipedia.org/wiki/Leitmotif#Wagner) or because [Wagner tuba](http://en.wikipedia.org/wiki/Wagner_tuba). It's because the entire creative team has stuck to its goal of telling the epic tale, and knowing the role of the music. For those outside of the small, _small_ world of opera, it's not true that there exist certain pieces that stand on their own. It's the job of the creative team to _show_ the audience the story in the text, and what the music has to say about it. And it's the job of those in charge of a company to hire directors and conductors willing to take on the task.

I love that opera folks are odd. They understand the potential of the human voice, what harmony and melody can do to words (and vice versa), and they become history and literature buffs in the meantime. I challenge major companies to decide not what show they want to put up, but _what they want to say_. It means they may have to ignore "suggestions" from puritan opera subscribers or even donors, and be brave enough to rediscover the task of story-telling. If snobby feathers are ruffled, so be it. Anyone who's tried to put up an opera (and I mean from  within the rehearsal room) knows that there's no room for ego in this art form. Shouldn't that trend start with the opera bosses?
