+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-12-28T14:47:00-05:00"
lastmod = "2015-12-29T12:36:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1451358040382/2015-12-27%20-%20Zerbinetta.jpg.jpg"
primary_image_credit = "Christopher Enns, Jane Archibald (Zerbinetta) and John Easterlin in the COC's Ariadne auf Naxos. Photo: Michael Cooper."
publishDate = "2015-12-29T12:36:00-05:00"
related_articles = ["articles/carmen-don-juan-and-gender-reversal-pants-roles-indeed.md","articles/a-sweet-girl-on-the-podium-can-make-ones-thoughts-drift-toward-something-else.md","articles/hidden-secrets-of-the-soubrette.md","articles/women-in-the-arts-is-it-our-turn-yet.md"]
short_description = "I have a sneaking suspicion that labels like &quot;Charaktersopran&quot; or &quot;Charaktermezzosopran&quot;, as pure equivalents to *comprimario* tenors or *buffo* basses, are slightly off-putting to women. It may be because the available supporting roles for women seem too serious, or too important to the plot, to be &quot;downsized&quot; with the &quot;character&quot; classification."
slug = "who-are-our-comprimarias-why-arent-they-funnier"
title = "Who are our comprimarias, &amp; why aren&#039;t they funnier?"
+++

When we think of comprimario roles, they're usually male. Monostatos (*Die Zauberflöte*), Dr. Bartolo (*Il barbiere di Siviglia*), Bardolfo and Pistola (*Falstaff*), Goro (*Madama Butterfly*), all dudes, unless the director is concept-productioning the &$%# out of the show. Comprimario characters have the potential to steal the show, especially if they're given great comedy, like Dr. Blind in *Die Fledermaus* or the "Four Servants" in *Les contes d'Hoffmann*.

There exists the "Charaktersopran" in the German *Fach* system, but it's defined more broadly as a soprano who can sing leading lyric roles, plus a few big mezzo roles. Basically, a mega-Zwischenfach. But besides the "Charaktersopran", there are no *Fach* distinctions that specify a character or *comprimario/comprimaria* role for women.
 
Would you count Micaëla in *Carmen* the non-leading lady? Perhaps that's a stretch. What about Mrs. Jessel or Mrs. Grose in *The Turn of the Screw*? What about Fricka or Erda in *Der Ring des Nibelungen* (or for that matter, the Rheinmaidens and the Valkyries)? Or Suzuki in *Madama Butterfly*? These ladies certainly can make or break a show; again, these roles fit the comprimario definition nicely. Unfortunately, in the context of their respective operas, these roles tend to lean towards "ladies who are less fun than the main character".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1451409768336/Falstaff-MC-2155---Resized.jpg.jpg)<figcaption>Marie-Nicole Lemieux (Mistress Quickly), Lyn Fortin (Alice Ford), Lauren Segal (Meg Page), and Simone Osborne (Nannetta) in the COC's 2014 production of *Falstaff*. Photo: Michael Cooper.</figcaption>
</figure>

So, who are the female equivalents of these forget-me-not roles? Are they the soubrettes, so often heard as opera's "Inas and Annas" the maids, nurses, and meddling BFFs? There's Annina in *La traviata*, Marcellina *and* Barbarina in *Le nozze di Figaro*, Giovanna in *Rigoletto*, Giannetta in *L'elisir d'amore*. *Comprimario* is Italian for "with the main character", and these ladies certainly fit the definition.

Or, are the contraltos and mezzo-sopranos (mostly) fated to be slotted in as secondary roles? (Fun fact: one of the first results when you Google "secondary female opera roles" is the Wikipedia page for "mezzo-soprano". Zing.) In all seriousness, though, are the *comprimarias* of traditional opera found in roles like Amneris (*Aïda*), Maddalena (*Rigoletto*), Flora (*La traviata*), Adalgisa (*Norma*), or Mistress Quickly (*Falstaff*)?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1451409818915/wangflute2040x1200---resized.jpg.jpg)<figcaption>Zanda Svēde, Nian Wang, and Jacqueline Piccolino as the Three Ladies in San Francisco Opera's production of *The Magic Flute*, 2015. Photo: Cory Weaver/San Francisco Opera.</figcaption>
</figure>

Maybe it's not the mezzos. Maybe it's all about the coloratura sopranos. Zerbinetta in *Ariadne auf Naxos* is one of opera's most notorious show-stealers, just like the Queen of the Night in *Flute* or Chiang Ch'ing ("the wife of Mao Tse-Tung") in *Nixon in China*. Adele in *Die Fledermaus*? Sophie in *Der Rosenkavalier*? What about the two "Nieces" in *Peter Grimes*? Supporting male roles in the same operas, like Harlekin (*Ariadne*), the Italian singer (*Rosenkavalier*) and Bob Boles (*Peter Grimes*), we have no problems putting them in the *comprimario* file. Zerbinetta isn't your average supporting role, of course, but neither is Mime (*Ring Cycle*).

I wonder if the distinction is related, in part, to the fact that comic relief is noticeably less prominent in female supporting roles. Although not every comprimario role is funny, comedy is a staple for character tenors and buffos basses. With the right combination of singer and director, roles like Berta (*Barbiere*) and even Ida, Adele's friend in *Die Fledermaus*, can be a total gas. The Three Ladies in *Flute* can be a bit of a Three-Stooges-type of situation, and the stepsisters in *La Cenerentola* can be cartoon-sized comedy.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1451410090917/1115-tisbe-don-magnifico-clorinda---resized.jpg.jpg)
<figcaption>Rihab Chaieb (Tisbe), Donato DiStefano (Don Magnifico), and Ileana Montalbetti (Clorinda) in the COC's 2012 production of *La Cenerentola*. Photo by Michael Cooper.</figcaption>
</figure>

Yet, in comparison to the opportunity for comic relief in male comprimario roles, women have slim pickings. I'm reminded of that provoking article by Christopher Hitchens, "Why Women Aren't Funny" (the original link seems to be down, but [here's a follow-up](http://www.vanityfair.com/culture/2008/04/hitchens200804) by Hitchens in *Vanity Fair*). He argues, very basically, that because women have never *had* to be funny in order to be attractive to men, their comedy skills aren't as developed. Perhaps it's a bit chicken-and-egg, since the opera's secondary roles for women don't offer much in funny material.

I have a sneaking suspicion that labels like "Charaktersopran" or "Charaktermezzosopran", as pure equivalents to *comprimario* tenors or *buffo* basses, are slightly off-putting to women. It may be because the available supporting roles for women seem too serious, or too important to the plot, to be "downsized" with the "character" classification. Today, our *Fach* system comes from a centuries-old tradition, and it may not reflect how today's singers feel about their secondary roles. It even grates on me, a non-singer, to consider the Queen of the Night a character role, because she has two arias in which to deliver all the fireworks for the whole night. The argument falls flat, though, when one thinks of Loge in *Das Rheingold* or Baron Ochs in *Der Rosenkavalier*. They too have serious singing to do.

Is this a funny twist in the *Fach* system? Are we flattering women by keeping them distinct purely by voice-type? Or do these non-leading, female roles simply warrant some different classificatino than their male counterparts?
