+++
author = ["authors/kimberly-barber.md"]
categories = "Op-ed"
date = "2018-11-14T16:08:00-05:00"
lastmod = "2018-11-14T20:31:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542241838101/sqmagnify.jpg.jpg"
publishDate = "2018-11-14T16:58:00-05:00"
related_articles = ["articles/when-art-is-not-enough-opera-activism.md","articles/art-is-not-action.md"]
short_description = "It becomes an important responsibility of artists to comment on the topics of the day, no matter how messy or fraught. It can no longer stand for us present a particular historic piece of theatre art &quot;as-is&quot; and to satisfy ourselves with platitudes about how &quot;that&#039;s how it was written, it&#039;s just of its time&quot;."
slug = "wherefore-art-thou-opera"
title = "Wherefore art thou, opera?"
+++

Opera: dead or alive?

Inquiring minds want to know.

Is such a musty old art form still relevant in our time? And if so, why? And how?
Decision makers in the opera industry have been wringing their hands over this question for some time now. *Live in HD* performances of opera have made its consumption more democratic, but the effect on box office revenues for live opera has been sobering. The traditional demographic for opera — white, wealthy, privileged — is shrinking, and opera companies are desperate to attract new audiences. 

The public increasingly has much greater choice, not only in how they spend their cultural dollars, but also in how they consume their culture — often just a click away. In order to seduce them off their sofas, opera companies (and any other live theatre or music) must offer their audiences something they can't get on a TV screen and give them a reason to leave the comfort of their personal bubble. Yup, opera needs to be compelling. And it needs to feel — and *be* — relevant.
 
Into this quagmire of competing interests comes the young singer, fresh out of a conservatory or university program, perhaps just finished one of the many young artist development programs that are the lifeblood of opera companies. And as Thomas Hampson said in a [recent Schmopera interview](/talking-with-singers-thomas-hampson/), the industry these young singers are entering is *not* the one that those of us who have been around for a decade or two (or three), and who perhaps are educating these budding artists, entered into when we first began.

A few overarching themes have emerged in recent conferences, symposia and industry brainstorming sessions, some of which affect all stakeholders (opera companies and their administrations, established artists, educators, audiences) and some of which affect the coming generations of artists and their mentors. Having attended the September 2018 Opera.ca Summit, ["Opera's Changing World"](http://www.opera.ca/whats-new/latest-events/operas-changing-worlds-education-and-artist-training-summit-sold-out) in Montreal and the May 2018 "Seminar on the Future of Song Recitals" (presented by the Art Song Foundation of Canada) in Toronto, here are a few gleanings:

<ul "class=nospace">
<li> Opera and music education and training need to be able to respond to changes in the industry.
<li> Artists need to be increasingly versatile, able to authentically perform in a variety of styles and genres.
<li> Young artists need to be able to "cross over" with ease, and need to bring a strong arsenal of acting and presentation skills to the table.
<li> Opera as an art form needs to reclaim its social relevance to remain current.
<li> Interdisciplinarity, sharing and partnerships between companies, and diversity of voices and disciplines are all of importance in the changing climate.
</ul>

For the last 100 years or so, operatic (and other performing) artists have safely identified themselves as "entertainers", rather than as agents of or commentators on social change. The advent of the conductor standing with his (or more recently, her) back to the audience in the darkened opera house or concert hall has meant that the more immediately participatory and engaged nature of audiences has been shut down in favour of pure "consumption" of culture. Yet in our increasingly fragmented social-media-verse, people long for connection, and they want to be drawn in to the artistic conversation. We want to see ourselves reflected in the stories and characters we watch and listen to on stage, and we increasingly want our art to take some kind of a stand, to have an opinion, to provoke and inspire us. As conductor Mark Wigglesworth said in a recent *Guardian* article: "Opera can be a mirror for our time, one that invites us to look at ourselves as individuals and as communities we are part of, inspiring us to find private or public solutions to the challenges we face."

It follows, therefore, that it becomes an important responsibility of artists to comment on the topics of the day, no matter how messy or fraught. It can no longer stand for us present a particular historic piece of theatre art "as-is" and to satisfy ourselves with platitudes about how "that's how it was written, it's just of its time". 

There are a number of what we could call "problematic" pieces in the standard operatic canon — *Rigoletto*, *Così fan tutte*, *Eugene Onegin* and *Barber of Seville* all come to mind. Why, you ask? Well, they represent patriarchal, misogynist worldviews. Delivered without commentary, they ask us to accept a society in which women are mindless chattels and non-persons who are incapable of making their decisions on their own, let alone possessing the agency to follow through on them. We are called upon to call out such anachronisms, injustices, divisive and even offensive ways of thinking and being.
 
A few cases in point: Peter Hinton's recent COC production of [*Louis Riel*](/discomfort-louis-riel-at-the-coc/) addressed the glaring lack of indigenous perspective in the story of a prominent historical Métis hero by inserting a voiceless, almost omnipresent group of indigenous performers as the Land Assembly. In his interview about the production, Hinton outlined exactly what the dilemma is in resurrecting works where perspectives have changed in society in the meantime: "What's so difficult in approaching this opera – I deal with this every day – is that there is an amazing insight in it, a great scene, then there's this huge blind spot, then there's this huge colonial bias and then there's this amazing scene. You can't throw a generalized blanket over it and say it's all racist or it's all brilliant. It's a bit of both constantly." 

Yep. That's it in a nutshell. The work has tremendous moments, whether musically or dramatically, and then there are the blind spots, those tone-deaf moments where you just can't believe what you are seeing and hearing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542229688976/2017-04-27---LouisRiel-MC-0679.jpg.jpg)
<figcaption>(centre) Justin Many Fingers (Mii-Sum-Ma-Nis-Kim) as The Buffalo Dancer in a scene from the Canadian Opera Company's new production of *Louis Riel*, 2017, photo: Michael Cooper.</figcaption>
</figure>
 
And now we come to *Rigoletto*. Two recent productions — at the COC last season and in Montréal this season — served up this toxic patriarchal soup with differing results. [Christopher Alden's COC production](/great-music-distracting-sexuality-rigoletto/) at least attempted to point out the unpleasant "boy's club" nature of Rigoletto's court, causing us to examine what kind of society it is when men can quietly sit in plush leather armchairs in an oak-paneled room reading the paper while nasty goings-on with women ensue. The use of Giovanna as a procurer for the Duke rather than as a protector of Gilda was an interesting touch, but I wondered — why choose to present women as intriguing and conspiring against one another?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542229698680/17-18-03-MC-D-0096.jpg.jpg)
<figcaption>A scene from the Canadian Opera Company's production of *Rigoletto*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

This feature was also present in Michael Cavanagh's production in Montréal, but there was nothing to cushion the blow of this. On the contrary, there was little to no addressing of the fact that women were ceaselessly abused, violated and murdered in this production, without any reaction whatsoever from the bystanders on stage, regardless of gender. 

This simply cannot stand. We have a role to play in meaningful dialogue around difficult themes — #MeToo, human rights, treatment of indigenous peoples, genocide, violence and so on. It's no longer good enough to hide behind the art — we need to use it to shine a light into the dark corners of human existence and open up the space for meaningful and constructive dialogue. It's *our job*.
 
So much for the opera companies. Now, how do we train young artists to adeptly navigate this new landscape? We need to give them tools to train their chops as improvisers. We need to train them how to talk and write about their art form, and to engage with political and social themes. We need to train them in the savvy use of digital technology and social media, so that they can reach their audiences and engage with them. We need to provide them with hands-on learning experiences so that they can see how their art form (and what they have to offer it) works in the real world. We need to give them entrepreneurship skills. We need to be engaging vigorously with outside partners at our learning institutions, whether they be other places of learning, in the industry or the wider community. We need to increase the diversity of both the repertoire and the people who teach it, so that students (and audiences) see themselves reflected in the stories they tell on stage.
 
Wherefore art thou, opera? Well, I'd say: you exist to move, to inspire, to engage, to enlighten and to propel to action. We've got a job to do. Let’s get on it.
