+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-02-11T13:43:00+00:00"
lastmod = "2017-02-15T12:25:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487160998199/2017-02-15---Sick.jpg.jpg"
publishDate = "2017-02-15T12:25:00+00:00"
related_articles = ["articles/in-defence-of-singers.md","articles/one-more-reason-we-dont-envy-singers.md","articles/sick-singers-when-its-best-to-shut-up-about-it.md"]
short_description = "A singer&#039;s best publicity is their work. Great singing begets more opportunities, and poor singing begets bad reputations. There are plenty of reasons not to sing while sick: it can do damage to your vocal folds, it can make you stay sicker for longer, and it means you lose a paycheque. But when a singer has to decide, to sing or not to sing, the decision often hinges on the performance they think they can give."
slug = "when-singers-call-in-sick"
title = "When singers call in sick"
+++

How does a professional singer call in sick?

Simple: all you have to do is cause sudden stress for your colleagues and bosses, make another singer scramble into costume to take your place, and disappoint hundreds, maybe even thousands of people who were excited enough to pay money to hear you.

If you're a singer who's also a people-pleasing type, or you don't generally like to let down an entire audience (or your donors, Heaven forbid), dealing with illness is one of the worst things about the career. Singers do some pretty supernatural things with their voices, but they're still human. And frankly, it's a wonder singers aren't sick more often. Air travel, hotel rooms, jet lag, new climates, and rehearsals spent rolling on the floor - they can all add up to a gig-cancelling illness that costs a singer money, joy, and maybe a bit of pride.

We read recently of the [latest cancellation by star tenor Jonas Kaufmann](http://slippedisc.com/2017/02/jonas-kaufmann-cancels-with-a-cold/), who, after a recital of Wagner at the Barbican Centre, was unable to meet for a chat with some students of Guildhall. The reason? A cold.

Man, using the "I have a cold excuse" - doesn't it just sound so...*lame*? It sounds like someone who's not trying very hard to get out of something they don't want to do. In Kaufmann's case, it's really unlikely that he's just shirking his duties as one of the world's most in-demand voices. One can only assume he loves his job, and cancelling performances costs him a good chunk of cash.

Yet with all the well-wishes and sympathy, it can still seem like a personal affront to learn that the singer you couldn't wait to hear won't be singing at all, and will be replaced with someone you've never heard of. It can be frustrating to read a program insert, or hear an announcement made just before curtain, that Famous Singer is feeling "under the weather" or some other lighthearted descriptor; it seems to feed the urge to march backstage and tell that fussy singer, "Cancelling over cold, really? Isn't that a bit dramatic?"

Of course, that's entirely unfair. Singers go on all the time when they're not feeling 100% - we just don't hear about it. Sometimes, the house will make an announcement - as though to toy with the audience's emotions - that a singer is not feeling well, but they have heroically decided to push forth and sing anyway. It used to be a weird bit of non-news - why would the house announce something that we didn't really need to know? Aren't they basically telling us that we shouldn't expect a great performance?

And actually, that's sort of the point behind those announcements; if a singer makes the decision to go onstage without their best instrument, sometimes they'd rather the audience know that they're not working at 100%. It might sound like an emotional safety net put in place for a fragile ego, but we've actually come to the crux of the sick-singer conundrum.

A singer's best publicity is their work. Great singing begets more opportunities, and poor singing begets bad reputations. There are plenty of reasons not to sing while sick: it can do damage to your vocal folds, it can make you stay sicker for longer, and it means you lose a paycheque. But when a singer has to decide, to sing or not to sing, the decision often hinges on the performance they think they can give.

It can be risky, at any point in a singer's career, to perform under the weather. Young, emerging artists could make a lasting, bad impression that may cost them an important opportunity. Seasoned singers - especially those with a bit of fame - have to live up to the high standards they've set in their career thus far; for big gigs like an HD broadcast at the Met or a Richard Tucker Gala-type event, these singers can suffer a dent in their legacy (which may get recorded for all to hear forevermore) if they sing with an ailing voice.

So it's no wonder that singers have reputations of being slightly germophobic, hypochondriacal, and tender souls. They own Neti-Pots and Humidiflyers and they have those little bottles of Purell you can attach to your purse. Some singers go too far, getting so stressed out about getting sick that the stress itself does them in with great irony.

A cold might not be enough to keep a realtor or teacher or landscaper from their work, it's certainly enough for a singer. It's not even a fair comparison, because a singer with a cold is like a dancer whose legs have fallen asleep, or truck driver who forgot to put in his contact lenses. It's not about being able to show up to work - it's about having the tools to work at all.

It must be a total nightmare to make that pre-show decision to call in sick. With one phone call, singers create a domino effect of consequences that starts with disappointing everyone inside the opera house, and ends with a smaller paycheque. Most singers that we know adore their work, and they have respect, if not love, for their audiences. It's difficult to imagine a situation where a singer would cancel without intense consideration, or think to themselves, *You know what, I'm just not going to sing this show tonight.*

On the one hand, eager audience members are indeed disappointed when a singer has to bow out of a show. The nastier listeners may even made their disapproval heard, and heard clearly. Yet there is silver lining. The ailing singer is telling their colleagues and audience that they deserve a better show than they can give, and they've made that decision in forfeiture of their pay and the chance to perform something they've spent many hours perfecting. 

A sick singer indeed wants the show to go on - and history shows that a heroic save by an understudy can be an exciting moment to witness.

>Is that enough to abate your disappointment? Let us know in the comments below!
