+++
author = ["authors/blanche-isral.md"]
categories = "Op-Ed"
date = 2017-12-20T02:52:00Z
lastmod = "2017-12-21T14:55:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513738286356/2017-12-20---Protect.jpg.jpg"
publishDate = "2017-12-19T21:52:00-05:00"
related_articles = ["articles/some-uncomfortable-questions-about-the-levine-business.md", "articles/operas-sexual-assault-secret.md", "articles/sex-is-one-of-the-perks-of-conducting.md", "articles/levines-ugly-exit-the-disposable-met.md", "articles/theatre-company-responsible-for-canadian-singers-death-goes-bankrupt.md"]
short_description = "It is irresponsible and dangerous to assume that a criminal&#039;s colleagues are unaware or indifferent to such serious offenses. This attitude needs to be addressed. An entire art form is at stake."
slug = "when-opera-companies-protect-abusers"
title = "When opera companies protect abusers"

+++
Behind the scenes at opera companies around the world, in the wake of a year that has brought some of the entertainment industry's biggest scandals to light, the volume dial on hushed conversations is turning all the way up. Since the eruption of the [latest Levine scandal](/some-uncomfortable-questions-about-the-levine-business/) two weeks ago, a distinctive shift is taking place. Whether this shift makes or breaks the opera industry will depend on how opera companies choose to acknowledge and deal with it. With concerned colleagues emboldened and supported to speak out, audiences becoming more discerning about the character of the artists they are supporting, and the industry depending more than ever upon the public for its livelihood, it is clear that the policies that have allowed known abusers to fly under the radar in the past must radically change.

>In 2017, taking a head-in-the-sand approach amounts to tacitly endorsing the abuse, and wrongfully puts the onus on individual staff members to develop their own strategies to build a safe work environment.

Had tenor [Alfred Kim](/poor-decisions-professional-consequences/) served his 8-month sentence, he would have been behind bars for domestic violence until about four weeks ago. Friday night at Oper Frankfurt, Kim stepped into the main role of Manrico in _Il Trovatore_. The last time Kim was heard on a main stage was in March 2017, in a production of _Ernani_ in Toulouse, where during his time off, he got intoxicated and assaulted his girlfriend in his hotel room, dragging her by the hair and smashing her head against a toilet bowl to the point of breaking the seat. The violence carried on until neighbouring guests got so alarmed that hotel security intervened. Kim was sentenced to 8 months for domestic abuse, the rest of the production was cancelled at Kim's cost, and the Théâtre du Capitole dealt with it as quietly as possible. The sentence was suspended and Kim went home.

Meanwhile, at the Canadian Opera Company and National Ballet of Canada, it's business as usual for [a tenured orchestra musician found in possession of child pornography](https://www.canlii.org/en/on/oncj/doc/2008/2008oncj68/2008oncj68.html). According to an inside source, the musician continues to this day to exhibit worrisome and inappropriate behaviours at work, at times in the presence of children. The case has never been acknowledged by the companies, and many musicians who play in the pit every day are entirely unaware of it.

>Whether further danger is real or perceived, the opera company is failing to create a safe and supportive environment for its female artists.

### The call is coming from inside the house

Courage begets courage: with conversations about the [Levine scandal](/some-uncomfortable-questions-about-the-levine-business/) setting a model and opening up dialogue around situations that were previously unmentionable, opera companies won't be able to rely on their artists' obedience and silence for much longer. While the abuse in all these stories technically occurred outside of company hours, the abusers continue to come into close and in some ways intimate contact with their artist colleagues in the regular course of their work. As Manrico, Kim is contracted to play a romantic lead opposite the Leonora, and shares emotional scenes with the Azucena. Whether further danger is real or perceived, the opera company is failing to create a safe and supportive environment for its female artists. And, by the same token, it is defending the abuser: while the Royal Opera House replaced Kim in a performance of _Turandot_ in July after news of the incident, Oper Frankfurt kept him on without taking any special measures.

There is also evidence of the opera company protecting the abuser in the Canadian case. At the time of the trial, "several letters of reference were introduced as evidence, which attest to the high level of skill he possesses as a violinist", including at least one from a tenured musician who plays in the orchestras. So while the incident has been treated as entirely separate from the perpetrator's employment, the same activities were cited by his colleagues in order to justify leniency on his sentence.

What's more, after years of steady contracts in the pit, at least one colleague who expressed concerns to management about worrisome behaviour by the convicted musician alleges never being invited back. The colleague's concerns included the musician - who was ordered against holding any employment that involves being in a position of authority towards children under 16, and from having any contact or communication with children under 16 - volunteering to lead school tours of the Four Seasons Centre, showing up at work seemingly under the influence of alcohol, and loitering near the children's chorus changing room.

These subtle manipulations point to emotion-based taking of sides by the company, rather than above-board decisions and due process. Of course, terminating the individual is not always an option, or for that matter the right option. But if companies took transparent, proactive measures around these situations (like acknowledging the situation rather than letting people find out through rumours, talking it out through workshops, or making discrete counseling available), they could actually create a supportive framework that would both enable the individual's rehabilitation and validate the concerns of those who are required to work and make art with them.

In 2017, taking a head-in-the-sand approach amounts to tacitly endorsing the abuse, and wrongfully puts the onus on individual staff members to develop their own strategies to build a safe work environment. What's more, it is hypocritical: others, notably women, lose jobs over far less, like dating the wrong person or speaking out of turn.

### The audience's power

Since the entertainment industry scandal, [countless](http://www.indiewire.com/2017/10/harvey-weinstein-separate-art-from-artist-film-critics-1201887805/) [people](https://www.nytimes.com/2017/11/28/learning/can-you-separate-art-from-the-artist.html) like [this](http://www.bbc.com/culture/story/20170517-can-you-separate-the-artist-from-the-art) and [this](https://www.dailywire.com/news/23062/separate-art-artist-con-mans-principle-paul-bois) and [this](https://www.hollywoodreporter.com/bastard-machine/separate-art-artist-thr-critics-debate-hollywoods-harassment-impact-1059802) [writer](http://www.firstpost.com/entertainment/in-the-post-harvey-weinstein-universe-can-you-separate-the-art-from-the-artist-4222361.html) have [weighed in](http://www.redbrick.me/comment/pop-culture/can-separate-art-artist-response-kevin-spacey-scandal/) on [whether](http://lancasteronline.com/features/entertainment/after-metoo-can-you-separate-the-artist-from-the-art/article_a70aa710-d6d6-11e7-9120-97bb829dae75.html) or [not](https://www.usatoday.com/story/opinion/2017/12/15/hollywood-sexual-predators-separate-art-artist-erase-christian-schneider-column/949536001/) art and artist should be considered separate. Where there may be ambiguities for film and other non-ephemeral art forms, opera is a live art and therefore harder to extricate from the artists in the room in that moment. With the amount of art on offer and the rise of socially responsible spending, audiences increasingly vote with their ticket dollars. Any inkling that they are supporting something sinister can nudge audiences toward spending elsewhere.

>The Met's reactive example should not be a model but rather a cautionary tale for opera companies around the world.

Perhaps this is what has driven a [floundering](https://www.nytimes.com/2017/09/28/arts/music/met-opera-buyouts.html) Met and other companies to take such a secretive approach to dealing with the improprieties of their artists in the first place. But as the channels of dialogue between artists and audience members continue to multiply, this approach needs to be turned on its head - instead of hiding, companies must instead bring their audiences into the conversation in order to build real trust that will carry them into a new era.

### The scent trail

The increasing power of PR is to thank for shifting the tides. As government support decreases, opera companies' direct reliance on the public for sustenance grows and grows. North American companies cater to individual and corporate wealth: private donors, sponsors, and ticket buyers, while European companies are still protected by cushy state funding (Oper Frankfurt, for instance, is between 90 and 100% funded by its municipal and regional governments. Illustrating how little PR matters in such a funding situation, they don't even have a Facebook page.) This direct connection with an opinionated and militant funding source elevates the power of public scrutiny. It is therefore no coincidence that the Met was the first on the chopping block. The reasoning for hiding Levine's actions through closed-door settlements with victims and, by the same token, repudiating his actions and cutting ties with him when the tides shifted can all be chalked up to PR-conscious decision-making. But I am convinced it will only be the first of many as governments hand over the funding reins to the people.

### A cautionary tale

The Met's reactive example should not be a model but rather a cautionary tale for opera companies around the world. Not everything is as clear-cut as the [James Levine case](/some-uncomfortable-questions-about-the-levine-business/). Certain crimes warrant second chances, but not without due diligence. The relationship of trust that is required to perform as part of an ensemble is often far greater than simply sharing an office, so there is no reason the HR measures put in place by large corporations should not be applied to this intimate industry founded on complex interpersonal relationships. It is irresponsible and dangerous to assume that a criminal's colleagues are unaware or indifferent to such serious offenses. This attitude needs to be addressed. An entire art form is at stake.