+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2019-06-17T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1560816767/media/2019/06/sqAsOne.jpg"
primary_image_credit = "Jorell Williams (left) and Briana Elyse Hunter as Hannah in AS ONE. Presented by Kaufman Music Center in association with New York City Opera and American Opera Projects. Photo: Steven Pisano Photography."
related_articles = ["articles/as-one-they-both-took-risks-that-paid-off.md"]
related_companies = ["scene/companies/american-opera-projects.md"]
related_people = ["scene/people/briana-elyse-hunter.md", "scene/people/jorell-williams.md"]
short_description = "It’s a truly original idea. Two performers (a mezzo soprano and baritone,) portraying two sides of the same coin: a transgender character named Hannah. Born a boy and dressed like a boy in sneakers and a letterman jacket, Hannah (in the baritone phase of their life) secretly wears a blouse underneath because “it feels so right,” as they deliver their newspapers on a paper route."
slug = "when-its-not-about-the-music-per-se"
title = "When it's not about the music per se"
youtube_url = ""

+++
Laura Kaminsky's opera _As One_ is billed as "the most produced opera written in the 21st century" and on almost every level you can understand why.  A well-executed concept, a timely story, a clever director, and two compelling performances add up to a satisfying evening, even though the music does not exactly add up to an opera.  Program notes admit that the evening is more of a song cycle but it's a meandering one at that. Ms. Kaminsky has composed some very good string quartet music that straddles both the 19th and 20th century in style, but the vocals are essentially nothing but recitative hanging above it all. The effect is one of voices hovering over an inviting landscape without finding anywhere to land.

>It's a singularly "on the nose" moment in an otherwise subtle and symbolic tale from two adept storytellers.

It's a truly original idea. Two performers (a mezzo soprano and baritone) portraying two sides of the same coin: a transgender character named Hannah. Born a boy and dressed like a boy in sneakers and a letterman jacket, Hannah (in the baritone phase of their life) secretly wears a blouse underneath because "it feels so right," as they deliver their newspapers on a paper route. Effective projections and films behind the singers follow Hannah's paper route, which is the beginning of their futile journey to become "the perfect boy" (represented by projections of sports images, etc.)  In school, Hannah writes cursively like a girl and during an essay on the famous poem by John Donne, refuses to conform to the notion that "no man is an island" because they feel so different, distant and apart from the rest of the students.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560816812/media/2019/06/AsOne1.jpg){{% /md %}}

<figcaption>Briana Elyse Hunter as Hannah in AS ONE. Presented by Kaufman Music Center in association with New York City Opera and American Opera Projects. Photo: Steven Pisano Photography.</figcaption>

</figure>

Eventually they cross a bridge, both figuratively and literally, and enter college where hormone therapy makes them feel, for the first time, like who they really are. But they can't face their family with this news. There is some elation about the life changes but a sense of loss, too, as they write a letter home, explaining that they won't be home for Christmas.

>Matt Gray is an imaginative stage director, getting the most out of the simplest of movements and set pieces.

There is only one detour from an otherwise solid libretto by Mark Campbell and film-maker Kimberly Reed (who also created the often-metaphorical video backgrounds). When Hannah is assaulted (dramatic enough in itself) there follows a reading of the names of real-life assault victims. This deliberately agitprop moment takes us out of the story. It's a singularly "on the nose" moment in an otherwise subtle and symbolic tale from two adept storytellers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560816823/media/2019/06/AsOne2.jpg){{% /md %}}

<figcaption>Jorell Williams as Hannah in AS ONE. Presented by Kaufman Music Center in association with New York City Opera and American Opera Projects. Photo: Steven Pisano Photography.</figcaption>

</figure>

The final act is essentially a mezzo monologue as Hannah tries to get as far away as possible and winds up in Norway of all places. Hannah at last becomes "the island" they wrote about as a child. There are some comic misadventures as Hannah begins four days of soul-searching in "a shack with cabin aspirations." They fail miserably in an attempt to make jam from wild berries. They fail in an attempt to row what turns out to be a leaky boat. But eventually they figure out who they really are and not only fix the jam and the boat, but also repair the male-female split in their lives and return from Norway not as two, but "as one."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560816835/media/2019/06/AsOne3.jpg){{% /md %}}

<figcaption>Jorell Williams (left) and Briana Elyse Hunter as Hannah in AS ONE. Presented by Kaufman Music Center in association with New York City Opera and American Opera Projects. Photo: Steven Pisano Photography.</figcaption>

</figure>

>In a score like this one, when it's not about the music per se, it has to be about the singing.

Matt Gray is an imaginative stage director, getting the most out of the simplest of movements and set pieces. A wooden rectangular frame (in its vertical position) serves as full length mirror. Baritone Hannah and Mezzo Hannah look at each other through the wooden frame as though looking at the other’s reflections. When the frame is in its horizontal position, it becomes a cage trapping Hannah during one scene and a boat (setting her free) in another. Mr. Gray has the singers "illuminate" different parts of the story using handheld flashlights that serve as pointers, pens, and headlights (of both a bike and a car.)

In a score like this one, when it's not about the music per se, it has to be about the singing. The singers, in this case, do a magnificent sales job with both their vocal and acting talents. Clarion baritone Jorell Williams and soulful mezzo Briana Elyse Hunter were both superlative as the two halves of Hannah.