+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2018-04-16T21:14:00-04:00"
lastmod = "2018-04-18T10:27:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523927627157/sqDonGiovanniPress25.jpg.jpg"
primary_image_credit = "Don Giovanni, Pacific Opera Project, 2018. Photo: Martha Benedict."
publishDate = "2018-04-17T20:03:00-04:00"
related_articles = ["articles/in-review-tcherniakovs-don-giovanni.md"]
short_description = "There is a temptation for any director, therefore, to try something different or new. To quote Stephen Sondheim: &quot;you gotta get a gimmick.&quot; In this case, it&#039;s not a gimmick but a brilliant conceit from director Josh Shaw that works on every level. Here, Don Giovanni is…well…the &quot;Don&quot; as in the head of the local mafia.\n"
slug = "when-don-giovanni-is-the-don"
title = "When Don Giovanni is the &quot;Don&quot;"
+++

About two miles east of LA Opera's home in downtown Los Angeles, you'd expect to find a lot of warehouses and a lot of graffiti. But a production of Mozart's [*Don Giovanni*](https://www.pacificoperaproject.com/dongiovanni)? Who knew? Well, evidently a lot of people are in-the-know, as the performances of the Pacific Opera Project (POP) are often sold-out, no matter where the company finds a space.

Now in its seventh year, POP stages about four operas each year, sometimes at actual theatres like the John Anson Ford, but often in temporary places such as the The Vortex performance space they are inhabiting for *Don Giovanni*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523927329025/DonGiovanniPress22.jpg.jpg)
<figcaption>*Don Giovanni*, Pacific Opera Project, 2018. Photo: Martha Benedict.</figcaption>
</figure>

*Don Giovanni* has been called "the greatest opera of all time." No debate that it's one of the greatest and one of the most popular and often-produced in the worldwide repertory. There is a temptation for any director, therefore, to try something different or new. To quote Stephen Sondheim: "you gotta get a gimmick." In this case, it's not a gimmick but a brilliant conceit from director Josh Shaw that works on every level. Here, Don Giovanni is…well…the "Don" as in the head of the local mafia.

As written, the title character is extremely wealthy; he can throw a masked ball at a moment's notice, wining and dining anyone who wants to attend. He can threaten and even kill anyone who opposes him. And, most importantly to the moral of the story, he can have any woman he wants, whether she agrees to the assignation or not. Director Shaw sees all this as a parallel to organized crime, and so he sets his production in gangland, circa 1940's. (Mr. Shaw does help himself out a little bit with some updated super titles, where he translates a few lyrics into gangster speak such as "dame" and "made guy.")

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523927352287/DonGiovanniPress31.jpg.jpg)
<figcaption>*Don Giovanni*, Pacific Opera Project, 2018. Photo: Martha Benedict.</figcaption>
</figure>

The main character is a hedonistic, narcissistic villain with no redeemable qualities, who is able to switch on a charm that no woman can resist. It goes further than that - every woman actually falls in love with him, and most realize too late that he isn't interested in romance as much as he's interested in rape. Rich and resonant bass-baritone Adrian Rosas captures the suave confidence of the character and sings the ultimate seduction song "Là ci darem la mano" with a rat-pack cool. Rosas is also convincing as the drunken and fearful Don Giovanni who falls apart near the end of the show.

The action takes place in "one dreadful night" and is mostly a door slamming comedy with no doors; the characters have to play hide and seek. For Don Giovanni, it's a constant case of "seduction interruptus" as various characters swoop in to foil all of his attempted conquests. He remains unflappable. He merely moves on to someone else in hopes of adding to his "catalogue," a book listing thousands of women he has had sex with (1,003 in Spain alone, according to the lyrics.) Not so ridiculous as we now know that statistics like this are common among the rich and famous.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523927361149/DonGiovanniPress42.jpg.jpg)
<figcaption>*Don Giovanni*, Pacific Opera Project, 2018. Photo: Martha Benedict.</figcaption>
</figure>

While much space has been devoted to Mozart's impeccably flawless score, it wouldn't be a theatrical masterpiece without the libretto of Lorenzo Da Ponte. Da Ponte has written an inky-black comedy with a very dark and "seria" river running through all the proceedings. The show begins with an attempted sexual assault and a murder after a battle of gunsels. Not easy to get a lot of laughs after a start like that, but Da Ponte is ahead of his time with a very modern, cynical view of life. Popular operatic themes like true love and honor have no place here - the only couple with these virtues commits suicide. But through it all, Da Ponte finds the humor for us (though the ending is certainly no laughing matter.)  

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523927370692/DonGiovanniPress41.jpg.jpg)
<figcaption>*Don Giovanni*, Pacific Opera Project, 2018. Photo: Martha Benedict.</figcaption>
</figure>

None of this would work without performers who understand the wit and timing in the libretto. This production has comic Bass and agile physical clown E. Scott Levin to keep the humor flowing. Levin plays Leporello, Don Giovanni's servant, wingman and fixer, who often has to juggle his master’s lady friends and keep them apart. There is both luxury and simple clarity in his voice. He delivers - and boy does he deliver - the best male aria of the night "Madamina" (The Catalogue Aria). Here Leporello reads from a book, listing every kind of woman Don Giovanni has conquered (young, old, fat, thin, blonde, brunette, you name it.) Levin, dressed in bright orange, produces a matching bright orange book out of his pocket and the pages open up into a long accordion that drops to the floor. An old but reliable gag to demonstrate Don Giovanni's lengthy statistics.

Saira Frank gives quite the star turn as Donna Anna, and sounds like Renée Fleming at the height of her powers. Her voice effortlessly dances in the clouds as she climbs the vocal ladder of "Or sai, chi l'onore."
Mezzo Daria Somers has two arias as the angst-ridden, hopelessly smitten Donna Elvira. She has the perfect blend of power and tears in her voice in Act I and then she doubles down, drowning in her passion in Act II.
Tiffany Ho is a hilarious Zerlina, who has to seduce her jealous newlywed husband Masetto (Luvi Avendano) not once, but twice, as an apology for having flirted with Don Giovanni. Ms. Ho and Mr. Avenado make an excellent pairing for these comic love scenes.

Robert Norman is the lone tenor in the cast but has plenty of talent to hold his own in a show that mostly showcases the lower male register. He has a velvety sound that blends beautifully with Ms. Frank in their duets and with Ms. Frank and Ms. Somers in their trios.

Here is a suggestion for every *Don Giovanni* production in the world: fly in Andrew Potter to play the Commendatore. It's perfect casting, especially in the scene where he’s a statue that comes to life. His earthshaking basso is as big as his 6'10" frame. And when he enters in a smoke-filled, backlit haze you can understand why Giovanni, Leporello, and everyone in the audience, would be scared to death.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523927379754/DonGiovanniPress50.jpg.jpg)
<figcaption>*Don Giovanni*, Pacific Opera Project, 2018. Photo: Martha Benedict.</figcaption>
</figure>

Ryan Murray conducts a solid chorus and a twenty-piece orchestra - yes, twenty pieces - who are as stellar as anything you will hear two miles west of here at the Dorothy Chandler Pavilion.

Mr. Shaw, who has directed 28 productions at POP alone, has a great sense of rhythm and music in his staging, and many of the movements and gestures by the performers are expertly timed to the notes of Mr. Mozart. They feel exactly right, as if that's precisely what the music calls for. Perhaps a little too much pushing and shoving going on, but this is only a minor quibble - and we are, after all, dealing with "tough guys." He also designed an ingenious mutli-level set which at first serves as the exterior of Don Giovanni's brick villa. Then, with the simple addition of panels that look like aristocratic fabric wall-coverings, the bricks are covered and - voilà! - we're suddenly inside the villa without any laborious set changes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523927393922/DonGiovanniPress48.jpg.jpg)
<figcaption>*Don Giovanni*, Pacific Opera Project, 2018. Photo: Martha Benedict.</figcaption>
</figure>

The set is also wisely whitewashed to avoid any competition with the creations of costume designer Maggie Green who has taken a cue from Warren Beatty's film Dick Tracy and dressed her guys and dolls in ultra-bright primary colors; Don Giovanni struts about in a crimson zoot suit.
There is some traditional theatre seating but most of the audience sits at tables and chairs. The price of a ticket also includes a bottle of wine and some piquant antipasti.

[Performances continue April 20, 21 and 22](https://www.pacificoperaproject.com/dongiovanni).
