+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-07-12T14:25:00-04:00"
lastmod = "2017-07-18T12:48:00-04:00"
preamble = "Art is an important mirror of ourselves, showing us the good, the bad, and the timely. The presence of artistic commentary is an indicator of a society that strives to be healthy and free; yet that commentary is incomplete without further action.\n\nOpera has always had a close relationship with moral dilemma and ugly human behaviour. We can watch an opera about corrupt leaders, prejudicial hate, or fatal sexism - and still, when the curtain falls there always looms the question, \"then what\"? In the hopes of answering that question, we've compiled some contemporary examples, along with a list of organisations that can help turn pathos into positive action."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1500250315866/2017-07-16---Protest.jpg.jpg"
publishDate = "2017-07-18T12:48:00-04:00"
related_articles = ["articles/dont-miss-id-please.md","articles/art-is-not-action.md","articles/in-review-dead-man-walking-at-miami-music-festival.md","articles/in-review-sweat.md","articles/getting-vexed-over-wagner-other-narcissisms.md","articles/the-mets-201819-seaszzzzzzzzz.md","articles/i-wrote-toward-tomorrow-to-bring-attention-to-this-crisis.md","articles/wherefore-art-thou-opera.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/tapestry-opera.md","scene/companies/the-bicycle-opera-project.md","scene/companies/pacific-opera-victoria.md","scene/companies/vancouver-opera.md","scene/companies/opera-saratoga.md","scene/companies/tete-a-tete.md"]
short_description = "Opera has always had a close relationship with moral dilemma and ugly human behaviour. We can watch an opera about corrupt leaders, prejudicial hate, or fatal sexism - and still, when the curtain falls there always looms the question, &quot;then what&quot;?"
slug = "when-art-is-not-enough-opera-activism"
title = "When art is not enough: opera &amp; activism"
+++

## Xenophobia and racism

British-Iranian composer Soosan Lolavar's [*ID, Please*](http://www.tete-a-tete.org.uk/event/id-please/) sees its premiere this summer at the [10th annual Tête à Tête Opera Festival](/tete-a-tete/) in London. It's an acute tale of what it means to confront racial prejudism and othering in the 21st century; a far cry from *Madama Butterfly*, *ID, Please* packs a timely punch in a world filled with borders and Brexit.

Nationalism and travel bans may permeate the news, but in response there are organisations with missions of help and justice:

<ul class="nospace">

<li> [Immigrant Defense Project](https://www.immdefense.org/donate/)
<li> [Immigrant Legal Resource Center](https://www.ilrc.org/donate-now)
<li> [American Civil Liberties Union](https://www.aclu.org/)
<li> [AURAForRefugees.org](http://www.auraforrefugees.org/)
<li> [Canadian Council for Refugees](http://ccrweb.ca/en/about-ccr)
</ul>

## PTSD treatment and veteran care

After his time in the [Explosive Ordnance Disposal](https://en.wikipedia.org/wiki/Bomb_disposal) unit in Iraq, Brian Castner returned home with Blast-Induced Traumatic Brain Injury (bTBI), and what he called "the Crazy". He told his story by writing a [book called *The Long Walk*](https://briancastner.com/books/the-long-walk/); his book was adapted into an [opera](https://briancastner.com/2015/06/23/opera-wrap-up/) in 2015 and it had its premiere run at [Opera Saratoga](http://www.operasaratoga.org/the-long-walk/).

Despite its status as one of the longest-standing results of war, the presence of organised support and treatment for Post-Traumatic Stress Disorder is relatively new. Though it may never be "enough", the links below scratch the surface of the help available to veterans:

<ul class="nospace">

<li> [Wounded Warriors](https://woundedwarriors.ca/?gclid=Cj0KCQjwkZfLBRCzARIsAH3wMKomjDIA3ISsKMH0vxDLqyujJSyFjM-LnHtoRxiDvmXedqkwkxqqykQaAlNiEALw_wcB)
<li> [CombatStress.org](http://www.combatstress.org.uk/veterans/) (UK-based)
<li> [PTSD Association of Canada](http://www.ptsdassociation.com/) 
<li> [National Coalition for Homeless Veterans](http://www.nchv.org/)

</ul>

## Justice and prison reform

Arguably already a staple of 21st-century opera, Jake Heggie's [*Dead Man Walking*](https://jakeheggie.com/dead-man-walking-2000/) (2000) is an adaptation of [Sister Helen Prejean](http://www.sisterhelen.org/journey-of-dead-man-walking/)'s true account of offering spirital advice to a convicted murderer on death row. 

"The death penalty is one of the great moral issues facing our country," writes Prejean, "yet most people rarely think about it and very few of us take the time to delve deeply enough into this issue to be able to make an informed decision about it." The issue of capital punishment is part of the larger conversation about prison and justice reform, wrongful incarceration, and prisoner rehabilitation. It's a dizzyingly large topic, and you can begin with this [list of Justice Reform Organisations on Piper Kerman's website](http://piperkerman.com/justice-reform/justice-reform-organizations/), or with the links below:

<ul class="nospace">

<li> [SisterHelen.org](http://www.sisterhelen.org/)
<li> [Center for Prison Reform](https://centerforprisonreform.org/our-mission/)
<li> [The Sentencing Project](http://www.sentencingproject.org/about-us/)
<li> [The Sunny Center for the wrongfully incarcerated](http://www.thesunnycenter.com/the-center.html)
<li> [National Coalition to Abolish the Death Penalty](http://www.ncadp.org/)

</ul>

## Anti-bullying

In 2016, [Vancouver Opera In Schools](https://www.vancouveropera.ca/learn/schools/secondary/vois_on_tour) (VOIS) took the opportunity to combine their annual touring production with an on-point message for young audiences. They brought to audiences across British Columbia *Stickboy*, the opera by Neil Weisensel and Shane Koyczan, originally staged for secondary school students by Vancouver Opera. 

In 2015, Tapestry Opera commissioned [Chris Thornborrow](/talking-with-composers-chris-thornborrow/) and Julie Tepperman to write [*Selfie*](https://tapestryopera.com/selfie/), an opera about online bullying; after its positive reception at Tapestry's Opera Briefs, it was presented in a workshop format to an audience of students in grades 8-10.

Singing about bullying helps to make the issue less covert, but it's only a start:

<ul class="nospace">

<li> [Anti-Bullying Institute](http://antibullyinginstitute.org/)
<li> [DitchTheLabel.org](https://www.ditchthelabel.org/about/)

</ul>

## Human trafficking

It was difficult to watch [*Oksana G.*](/tough-to-watch-oksana-g/), which had its world premiere run this year with Tapestry Opera; yet the piece by [Aaron Gervais](/talking-with-composers-aaron-gervais/) and Colleen Murphy certainly had the stuff of an opera-sized story. In our interview with Ukrainian-Canadian soprano [Natalya Gennadi](/oksana-g-its-so-out-of-this-world-and-yet-so-realistic/) who sang the title role of *Oksana G.*, she stressed that the story of young women being tricked and sold into sexual slavery was not one that is old, nor far-removed from home.

The long list of [organizations dedicated to fighting human trafficking](https://en.wikipedia.org/wiki/List_of_organizations_that_combat_human_trafficking) brings up as much hope as it does despair. Here are a few of them:

<ul class="nospace">

<li> [CEASE - The Centre to End All Sexual Exploitation](http://www.ceasenow.org/)
<li> [Global Alliance Against Traffic in Women](http://www.gaatw.org/)
<li> [Coalition to Abolish Slavery & Trafficking](http://www.castla.org/)
<li> [BreakingFree.net](http://www.breakingfree.net/what_we_do.aspx)
<li> [Truckers Against Trafficking](http://www.truckersagainsttrafficking.org/)

</ul>

## Workers' rights and child labour

"Who made your clothes?" It's the question that [The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/) is asking as it kicks off its touring production of [*Sweat*](http://bicycleopera.com/upcoming-sweat/), the *a cappella* opera by [Juliet Palmer](/scene/people/juliet-palmer/). *Sweat* was originally commissioned by Soundstreams, and it finds a rare topic among operas: the lives of sweatshop workers. "Plunging headfirst into the ethical conundrums of the garment trade, this opera offers a window into the lives of the workers who clothe us."

Perhaps an uncomfortable condundrum, *Sweat* takes the first step towards putting one's personal style up against the secretive costs:

<ul class="nospace">

<li> [International Labor Rights Forum](http://www.laborrights.org/about)
<li> [Labour Behind The Label](http://labourbehindthelabel.org/)
<li> [Fair Labor Association](http://www.fairlabor.org/)

</ul>

## Indigenous people's rights

Premiering this fall with [Pacific Opera Victoria](/scene/companies/pacific-opera-victoria/), [*Missing*](http://www.pov.bc.ca/missing.html) continues to give much-needed voice to the story of Canada's missing and murdered indigenous women. The chamber opera by composer Brian Current and Métis playwright Marie Clements sees its first stage direction by Peter Hinton, whose new production of [*Louis Riel*](/discomfort-louis-riel-at-the-coc/) at the [Canadian Opera Company](/scene/companies/canadian-opera-company/) was a notable contribution to the artistic offerings of #Canada150.

For many Canadians, awareness is a significant first step:

<ul class="nospace">

<li> [ReconciliationCanada.ca](http://reconciliationcanada.ca/about/about-us/)
<li> [Assembly of First Nations](http://www.afn.ca/)
<li> [RAVEN - Respecting Aboriginal Values and Environmental Needs](https://raventrust.com/)
<li> [InvisibleGirlProject.org](http://invisiblegirlproject.org/what-we-do/)

</ul>

## Homelessness, poverty, addiction and mental health

Onalea Gilbertson's [*Requiem for a Lost Girl: A Chamber Musical about Homelessness*](http://onalea.com/requiem/) was commissioned in 2009 by the Land's End Chamber Ensemble, and received its New York premiere with the New York Musical Festival."Exploring themes of of poverty, mental illness and addiction, this strikingly original chamber musical unfolds as a memorial service for a young woman. *Requiem* was created and is performed in partnership with a chorus of men, women and children who know the experience of homelessness."

In 2018, the chamber opera by Gilbertson and composer Marcel Bergmann heads to Vancouver Opera; the company is currently working with participants who are or have been homeless at Vancouver's [The Kettle](http://www.thekettle.ca/).

Homelessness, addiction, and mental health are complicated and intertwined, and every major city in the world can claim responsibility. Here are a few places that can complement the important artistic commentary on these issues:

<ul class="nospace">

<li> [RaiseTheRoof.org](http://www.raisingtheroof.org/)
<li> [Covenant House Toronto](http://www.covenanthousetoronto.ca/)
<li> [Centre for Addiction and Mental Health](https://www.supportcamh.ca/getinvolved/event)
<li> [Canadian Mental Health Associatiion](http://www.cmha.ca/)
<li> [CanadaHelps.org](https://www.canadahelps.org/en/donate/#find)

</ul>

>Readers, what have we left out of this list? Let us know in the comments below, or get in touch at [hello@schmopera.com.](mailto:hello@schmopera.com)
