+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-09-26T17:36:00-04:00"
lastmod = "2017-09-28T21:49:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506611300063/2017-09-29---Canadian.jpg.jpg"
publishDate = "2017-09-28T21:49:00-04:00"
related_articles = ["articles/the-stars-align-for-toronto-masque-theatres-final-season.md","articles/a-full-house-for-canadian-art-song-at-21c.md"]
related_companies = ["scene/companies/toronto-masque-theatre.md","scene/companies/canadian-art-song-project.md","scene/companies/esprit-orchestra.md"]
related_people = ["scene/people/lawrence-wiliford.md","scene/people/alexina-louie.md"]
short_description = "Wiliford joked that it &quot;took an American&quot; to found the Canadian Art Song Project, which focuses on getting new Canadian song repertoire written, performed, and recorded. Coming from the more fostering environment in the United States, Wiliford was surprised that Canadian performers weren&#039;t as quick to step into the role of champion for their own new music. Similarly, Alex Pauk admits that founding the Esprit Orchestra came out of his and other composers&#039; frustration with the dearth of groups willing to program Canadian material."
slug = "whats-the-deal-with-canadian-music"
title = "What&#039;s the deal with Canadian music?"
+++

Larry Beckwith, Artistic Director of [Toronto Masque Theatre](/scene/companies/toronto-masque-theatre/), addressed his audience at the company's first salon evening of the [2017/18 season](/the-stars-align-for-toronto-masque-theatres-final-season/), entitled *Canada in Words and Music*. He expressed a wish that he could present something larger than a simple snapshot of Canadian music, but rather a comprehensive history of music coming out of our still-young country. Perhaps Beckwith didn't give himself enough credit, since the evening's combination of music and conversation certainly did achieve something comprehensive; perhaps even more importantly, TMT's first salon gave valuable context to the topic of music in Canada.

The music was provided by young singers from the studio of Elizabeth McDonald at the University of Toronto, with Jo Greenaway at the piano. Between short musical sets, Beckwith sat down with three important figures in today's Canadian music scene: composer [Alexina Louie](/talking-with-composers-alexina-louie/), [Lawrence Wiliford](/scene/people/lawrence-wiliford/), tenor and co-founder of the [Canadian Art Song Project](/scene/companies/canadian-art-song-project/), and Alex Pauk, composer, conductor, and founder/Music Director of the [Esprit Orchestra](/scene/companies/esprit-orchestra/).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506610928832/2017-09-28---Louie.jpg.jpg)
<figcaption>Composer Alexina Louie.</figcaption>
</figure>

Some familiar tropes emerged in the chats. Louie, faced with that tricky question of identifying her "Canadianism" as a musical aesthetic, admitted to finding more of her Canadian identity only while living in the United States. It's certainly a big ask to pinpoint the national qualities of the art being made in a country as large as Canada, but Louie's account from her place as a composer is an interesting mirror to the familiar experience of many Canadian performers, who often find professional success in their home country only after working abroad.

Wiliford joked that it "took an American" to found the Canadian Art Song Project, which focuses on getting new Canadian song repertoire written, performed, and recorded. Coming from the more fostering environment in the United States, Wiliford was surprised that Canadian performers weren't as quick to step into the role of champion for their own new music. Similarly, Alex Pauk admits that founding the Esprit Orchestra came out of his and other composers' frustration with the dearth of groups willing to program Canadian material.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506610990693/2017-09-28---Wiliford.jpg.jpg)
<figcaption>Lawrence Wiliford, tenor and co-founder of the [Canadian Art Song Project](http://www.canadianartsongproject.ca/).</figcaption>
</figure>

Paraphrasing John Beckwith, Larry Beckwith posed that Canadian music has a "PR problem". That problem seems to encompass both a tendency to equate Canadian music with the avant-garde and unappealing, and the very familiar habit of looking outside of our country to find "better" music. 

The performances by Avery Lafrentz, Khadija Mbowe, Caroline Stanczyk, Matthew Snowdon, and Jo Greenaway - of music by everyone from Claude Vivier to Healey Willan to John Greer - were unarguably varied; it's a promising thing to see someone like Elizabeth McDonald, a voice teacher at a major Canadian institution, disseminating Canadian music to her students.

Pauk made perhaps the most interesting and encouraging point about the fate of Canadian music. Where in past decades, Canadian composers could sense the various schools of composition - notably European - and the fact that they were excluded from those schools, 21st-century art music is proving much more individualistic. It's now perhaps as difficult to discern a modern "German" or "French" aesthetic as it is to identify a "Canadian" style. The more recent focus on individual composers is not only more interesting than sorting music into compositional schools, it acts as a global equalizer, putting Canadian composers firmly on the same playing field as those south of the border and across the ocean.

>[Click here](http://www.torontomasquetheatre.com/node/24) to check out the full line-up for Toronto Masque Theatre's current - and final - season. 
