+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-05-28T20:28:00+01:00"
lastmod = "2016-05-30T11:34:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464557686346/2016-05-30---Coffee.jpg.jpg"
publishDate = "2016-05-29T22:40:00+01:00"
related_articles = ["articles/talking-with-singers-bryan-register.md","articles/talking-with-singers-christine-goerke.md","articles/talking-with-singers-nicole-cabell.md","articles/talking-with-singers-luca-pisaroni.md","articles/spotlight-on-angel-blue.md","articles/spotlight-on-claire-kuttler.md","articles/spotlight-onwho.md","articles/a-singer-and-her-ego.md","articles/talking-with-singers-kiandra-howarth.md"]
related_people = ["scene/people/jennifer-holloway.md","scene/people/alek-shrader.md","scene/people/alice-coote.md","scene/people/heidi-melton.md","scene/people/ambur-braid.md","scene/people/keith-lam.md","scene/people/lara-ciekiewicz.md","scene/people/amanda-majeski.md","scene/people/alan-held.md","scene/people/jeremy-bowes.md","scene/people/danielle-macmillan.md","scene/people/othalie-graham.md","scene/people/elizabeth-deshong.md","scene/people/simone-osborne.md","scene/people/jorell-williams.md","scene/people/christine-goerke.md","scene/people/luca-pisaroni.md"]
short_description = "Since we started Schmopera in late 2013, we have interviewed 108 singers. One hundred and eight! We&#039;re proud of that number, and we&#039;re by no means done. This site began partly out of our huge admiration for what singers do, and our respect for their skill and thick skins. We thought it might be a good milestone, at roughly 100 conversations with 100 singers, to take stock of what they&#039;ve told us."
slug = "what-weve-learned-by-talking-with-108-opera-singers"
title = "What we&#039;ve learned by talking with 108 opera singers"
+++

Since we started Schmopera in late 2013, we have interviewed 108 singers. One hundred and eight! We're proud of that number, and we're by no means done.

This site began partly out of our huge admiration for what singers do, and our respect for their skill and thick skins. We thought it might be a good milestone, at roughly 100 conversations with 100 singers, to take stock of what they've told us.

## Why do they do it?

We like to ask singers, "Why do you sing?" Plenty of them answer first with a wordless sound, like "Oof," or "Hmm," or an expression of exasperation, like "Oh, wow." It's perhaps a nonsensical question, and perhaps it's perfectly basic.

Most of them tell us that they sing professionally because they can't imagine doing anything else. "I could not stop if I wanted to," said bass [Jeremy Bowes](/spotlight-on-jeremy-bowes/), getting right to the point. Soprano [Amanda Majeski](/spotlight-on-amanda-majeski/) told us, "I sing because it's simply a part of who I am." Like Majeski, plenty of the singers we talk to have been singing for so long that it becomes a staple in their lifes. "I just think I would go mad if I didn't," explains soprano [Heidi Melton](/talking-with-singers-heidi-melton/). We loved how mezzo [Alice Coote](/talking-with-singers-alice-coote/) put it: "I was making noise about what it means to be alive from the time I was born."

Soprano [Christine Goerke](/talking-with-singers-christine-goerke/) answered with zero mystery, "I am having the time of my life up there."

Singers love the spotlight, but not for the egotism that many perceive. "I forget myself when I'm in a role," said mezzo-soprano [Jennifer Holloway](/talking-with-singers-jennifer-holloway/). Soprano [Corinne Winters](/talking-with-singers-corinne-winters/) explained it as more of a self-improvement: "I love that I can never go on autopilot." The spotlight is a place where singers can communicate and make an audience smile. "I sing to tell stories, to connect to people," said soprano [Lara Ciekiewicz](/spotlight-on-lara-ciekiewicz/).

Connecting to people extends beyond simple entertainment. Soprano [Simone Osborne](/talking-with-singers-simone-osborne/) started honing her singing skills in part so she could use her talents as a "soap box" from which to do humanitarian work, Sting-style. Baritone [Jorell Williams](/talking-with-singers-jorell-williams/) believes that a singer has done his work if, "at the end of the day, if we can change one person's life, if we can make them laugh or cry, or forget about whatever's happening in their lives." Soprano [Othalie Graham](/talking-with-singers-othalie-graham/) called singing "an amazing, tremendous responsibility," and tenor [William Ford](/spotlight-on-william-ford/) put it bluntly: "I sing because I want to serve society and change lives through the power of performance art." For bass-baritone [Luca Pisaroni](/talking-with-singers-luca-pisaroni/), "it's a calling, not a job."

## What is good singing?

For the average listener, everything that these singers do onstage can be considered "good singing", but since singers tend to be perfectionists, we love to ask them what they deem to be a job well done.

Singers have told us that they strive for ease, comfort, flexibility, and efficiency, and that they know it's "good" when they become unaware of the technique involved in making that all of that happen. "Achieving good singing means you’re unstoppable as a performer," explains baritone [Keith Lam](/spotlight-on-keith-lam/). "The possibilities are endless." Mezzo-soprano [Danielle MacMillan](/spotlight-on-danielle-macmillan/) told us, "When my whole body gets goosebumps, that's when I know I'm singing well and with everything I've got." 

Other singers sum it up in a beautifully concise way. "Good singing to me means connection," says [William Ford](/spotlight-on-william-ford/). [Amanda Majeski](/spotlight-on-amanda-majeski/) finds the experience a bit more otherworldly: "It feels like flying."

## What advice do they have for other singers?

Almost all of the singers we've interviewed have stressed how little it helps to compare oneself to others. The path of singers is a long one, and patience pays off exponentially more than competition or comparison. "So much of it you can't control," says soprano [Othalie Graham](/talking-with-singers-othalie-graham/), and [Nicole Cabell](/talking-with-singers-nicole-cabell/) agrees that "you have to be a certain breed of person to do this sort of thing." It's about perspective, like most difficult things; what some see as a life spent in airports, others see as an opportunity to do new things every day.

Of course, there's plenty of practical advice to be had, too. Study your languages, stressed our interviewees, and do it sooner and more seriously than you think is necessary. Learn about taxes and running your own business. Step outside of the insular world of opera, and do things that have nothing to do with your craft; [Danielle MacMillan](/spotlight-on-danielle-macmillan/) suggested, "get your heart broken and travel to a place where opera will never take you, with the hope that it'll inspire your creativity and feed your musical soul."

"Be prepared. Be punctual. Be nice," said [Lara Ciekiewicz](/spotlight-on-lara-ciekiewicz/). 

"Be kinder to each other," offered [Keith Lam](/spotlight-on-keith-lam/).

## What if they didn't sing?

Bass-baritone [Alan Held](/talking-with-singers-alan-held/) told us, without hesitation, that if he weren't a singer, he'd be a veterinarian. Mezzo-soprano [Elizabeth DeShong](/talking-with-singers-elizabeth-deshong/) pondered owning an antique store. Soprano [Ambur Braid](/talking-with-singers-ambur-braid/) told us, "I would certainly be able to make money organizing people's closets and planning really great parties."

Braid also made a beautiful point: "If you have a Plan B, you’re not going to do Plan A." So many of the singers we've spoken to have a hard time imagining their lives without music in it, and some even add that they'd sing for free, in choirs, bars, or weddings, if their solo careers stopped paying the bills.

"The motivation to be a singer should not be one of desire," said tenor [Alek Shrader](/talking-with-singers-alek-shrader/). "You should not want to get anything out of this job other than to do this job."

It was [Alice Coote](/talking-with-singers-alice-coote/) that answered this question in the most memorable way. "The life has done terrible things to me, I’m not joking, this life on the road, but not to sing? I couldn't…"

>To check out all of our interviews, [click here](/categories/interview/).
