+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2016-03-02T10:22:00+00:00"
lastmod = "2016-03-02T12:01:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456918767376/Chris-Rock-Oscars-Getty.jpg.jpg"
publishDate = "2016-03-02T11:57:00+00:00"
related_articles = ["articles/talking-with-singers-jorell-williams.md","articles/talking-with-singers-othalie-graham.md","articles/a-tale-of-big-hair-at-the-met.md","articles/forgiving-racism-onstage.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/glimmerglass-festival.md"]
related_people = ["scene/people/othalie-graham.md","scene/people/tamara-wilson.md","scene/people/eric-owens.md","scene/people/jorell-williams.md","scene/people/patricia-racette.md"]
short_description = "Perhaps opera is making a mess of this whole thing by keeping racist shows like Madama Butterfly on stages, or even sexist shows like The Marriage of Figaro alive and well. And yes, film is different than opera; a film doesn&#039;t go through different productions, doesn&#039;t get re-made over and over again with new casts of characters. But I think there&#039;s light in our madness, because it means we&#039;ve paid attention to the stories themselves, rather than the people charged with telling them."
slug = "what-oscarssowhite-can-learn-from-opera"
title = "What #OscarsSoWhite can learn from opera"
+++

In the wake of this year's Academy Awards, the conversation about race is really, really loud. There's the ubiquitous hashtag, [#OscarsSoWhite](https://twitter.com/search?q=%23OscarsSoWhite&src=typd), giving everyone with a Twitter account the opportunity to point out the iniquity of Oscar winners who aren't white. There was [host Chris Rock](http://www.newyorker.com/culture/culture-desk/chris-rocks-oscars), who punctuated the show with jokes about how it should be called the "White People's Choice Awards", and a pointed "We're black!" after a commercial break. There was also the [mysterious use of Wagner's music](http://www.newyorker.com/culture/cultural-comment/a-closer-look-at-wagner-and-oscarssowhite) to wrap up acceptance speeches, which for many of our readers evokes an awesomely thrilling scene in the third act of *Die Walküre*, but also, understandably, incites thoughts of anti-Semitism and general white-superiority.

In the opera world, we're talking about race, too. Shows like [*Madama Butterfly*](http://www.telegraph.co.uk/news/uknews/1542633/Opera-expert-says-Puccinis-Butterfly-is-racist.html) and [*The Mikado*](http://www.telesurtv.net/english/news/Final-Curtain-for-Racist-Gilbert-and-Sullivan-Opera-20150918-0011.html) are on trial for theor decidedly outdated pictures of Japanese culture, as told by white folk. The [lack of "blackface"](https://www.good.is/articles/otello-blackface-glimmerglass-mohegan-magic-flute-opera) in the Met's most recent production of *Otello*, and in Glimmerglass' 2015 production of [*The Magic Flute*](http://www.nytimes.com/2015/08/06/arts/music/at-glimmerglass-festival-the-magic-flute-is-among-the-reimagined.html) were positive, mature steps forward with operas written at decidedly more racist times in history.

Perhaps that's why, as opera lovers, we see the outrage of #OscarsSoWhite, etc., as missing the point on a lot of fronts. It's a fact that more white actors have won Academy Awards than anyone else. It's *not* a fact that white actors are inherently better at their craft than anyone else. There seems to be a connection, tightly bound almost to a fault, between the *work* and the *creators* of the work. In the opera circles of today, we are used to the practice of not throwing the baby out with the bathwater. *Madama Butterfly* is an exaggerated, Western-centric look at the story of Cio-Cio San; yet the characters who should be deemed "racist" are the white Americans, who are arguably the villains of the story. The talk of "angry Moors" in *The Magic Flute* and *Otello* are nasty stereotypes, but we're not so short-sighted as to dismiss the bigger, more important themes in these stories. These operas are about faith, patience, right and wrong, deception, and great love; they're still kicking around for a reason, and it's not because they feature black characters with major faults.

It makes us wonder what Tumblr or Everyday Feminism or Jezebel would have to say about "cultural appropriation" if opera were more mainstream. (actually, [Jezebel did have some stuff to say about that](/a-tale-of-big-hair-at-the-met/), in a tangential complaint as part of a "larger" argument). Would they lash out at stellar soprano [Othalie Graham](/talking-with-singers-othalie-graham/) for how many Turandots she has sung in her career? Or [Patricia Racette](/in-review-madama-butterfly/) for her portrayals of Cio-Cio San? Or for Agnes Baltsa's brilliant Prince Orlofsky in *Die Fledermaus*? She's not Russian, you know. Tamara Wilson isn't Egyptian, Aleksandrs Antonenko isn't black, and Eric Owens isn't a Norse dwarf. 

What these singers do have in common, though, is a great set of pipes. Thank goodness opera has this major caveat informing casting decisions; in the best cases, the voice comes first. After the voice comes the ability to say something with these characters, something beyond, "Did you know I am Turkish?" There indeed is something that separates the working, award-winning singers from the others: craft. 

Perhaps in fairness, it's right to argue that there's a type of discrimination with craft. In a recent interview, [tenor Paul Appleby said](/paul-appleby-telling-stories-at-wigmore-hall/), "I sing professionally because I have had a very privileged life. I was privileged to be born to parents who provided me with a life of financial stability, a good education...My upbringing permitted me to pursue the training that a professional career requires." It's true; to achieve success as an opera singer takes decades of investment, [both of money and time](/breaking-into-the-industry-a-vicious-cycle/). Without disposable income for lessons, coachings, wardrobe, and travel, and without the "free time" to put in the hard, unpaid work to win auditions, the career is basically a no-go.

Craft is what we should be talking about when it comes to #OscarsSoWhite. To lash out at the Academy Awards, which is basically a celebration of the end result of thousands of people's work on their craft, is short-sighted. It's only fair to be idealistic for a moment, and assume that an Oscar award is given out based solely on merit. It's a terrifying suggestion to make, that white actors and filmmakers are collecting awards because their work is objectively better. It's likely not true as a blanket statement, and racism, be it explicit or ignorant, is likely a factor. 

The objection should rather be about the fact that non-white actors and filmmakers don't get the same opportunities to hone their craft, not that they don't win Oscars. Whether or not there's a mean racial undertone to the selection of winners, the best way to counter that argument is by producing great work. It's an infinitely larger problem that learning an artistic craft takes time and money, and that in our Western culture, [white people make more than others](http://www.businessinsider.com/heres-median-income-in-the-us-by-race-2013-9?IR=T). It takes money to make money, and in the case of producing great art, that takes money, too.

As with everything, there will always be exceptions. There's something to be said about inherent artistic skill as an actor, musician, anything. Yet anyone working in the arts knows that "natural talent" is not only fairly rare, but that it's often not enough. 

Perhaps opera is making a mess of this whole thing by keeping racist shows like *Madama Butterfly* on stages, or even sexist shows like *The Marriage of Figaro* alive and well. And yes, film is different than opera; a film doesn't go through different productions, doesn't get re-made over and over again with new casts of characters. But I think there's light in our madness, because it means we've paid attention to the *stories themselves*, rather than the people charged with telling them. This is an oversimplication, even [within in the opera world](/talking-with-singers-jorell-williams/), and we're not exempt from the ubiquitous iniquity within our multi-cultural society. Yet an opera singer who hasn't yet developed the singing skills to pull off a convincing Pamina will have a hard time arguing that she should have gotten the gig; it's not a happy story, but that's what it means to be a professional in this industry. 

Still, the outrage about the Oscars needs to be centred properly, and combined with the ongoing conversations about access to education and livable earnings for all. It's a reason for opera companies to keep investing in outreach programs, internships, school tours, and summer camps for eager young musicians. It's a reason to *keep the arts in schools*, of course. #OscarsSoWhite is a symptom, not the disease itself.
