+++
author = ["authors/christopher-enns.md"]
categories = "Op-ed"
date = "2016-11-15T13:28:00+00:00"
lastmod = "2016-11-16T10:05:00+00:00"
preamble = "This is the first in a series of posts written by Christopher Enns, Canadian tenor and financial planner/coach. His work is all about \"money help for artists,\" and for more writing and resources, head over to his blog, [Rags to Reasonable.](http://www.ragstoreasonable.com/)"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479222976820/2016-11-16---Money.jpg.jpg"
publishDate = "2016-11-16T10:05:00+00:00"
related_articles = ["articles/rags-to-reasonables-personal-finance-holy-grail.md","articles/why-mezza-voce-and-budgets-really-dont-matter.md","articles/what-i-learned-about-money-from-enrico-caruso.md","articles/what-are-your-irrational-stage-fears.md"]
related_people = ["scene/people/christopher-enns.md"]
short_description = "A money technique is built in the same way, by investing hours of time into building solid fundamentals. Instead of breath, it&#039;s cashflow (the daily ins and outs of your money), instead of onsets it&#039;s deliberate decision making (learning to stop making default money decisions and make the ones you really want), and instead of working with someone to lift your soft palette, you work with someone to find one of a thousand little ways you can make your money life easier (by building a safety net, learning to save, and eliminating debt)."
slug = "what-crippling-stage-fright-taught-me-about-money"
title = "What crippling stage fright taught me about money"
+++

For the last 5 years I've been battling some fairly serious stage fright. 

It started off mildly enough, but slowly grew into a completely debilitating force that took away any joy I used to have for being on stage.

One of the many thoughts that started taking over my head was,

"What if I open my mouth and my voice just... doesn't work?"

Not a great mental dialogue for a professional singer.

And the truth was... sometimes I opened my mouth and my voice really didn't work.

It came from a mix of mental and technical problems, and normally I got through the show. But eventually it got bad enough that I completely crashed. It was not a great time in my life, and it sent me running.

I ran to my family farm. I sat on a tractor for 2 months and thought about how much I wanted to quit.

But I just couldn't do it.

I couldn't leave this thing that used to bring me so much joy… at least not like this.

So. I found a new teacher and we got to work - by painstakingly building up my technique and my shattered confidence.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479221132217/2016-11-16---Stage-Fright-1.jpg.jpg)
</figure>

**Technique is a funny thing.**

A director once told me: 'technique is for the times when things go wrong.' His theory was that when things are good, you don't need it. But when shit hits the fan, you have something to fall back on.

That might be an oversimplification, but here's what I know.

After 2 and a half years of technical work, I'm actually enjoying performing again.

Hours of work doing onsets, breathing, and encouraging my soft palette to lift just a little bit more, has given me a technical base that I actually trust.

And somehow knowing that I have that base has slowly (and I mean slowly) decreased that stress and given me the confidence to do my thing.

For the first time in years I've had a run of stress-free performances.

I can't tell you what that means to me.

## What crippling stage fright taught me about money

And so, as I was sitting backstage last week, about to put on my 2nd dance belt and pretend to be a greek demigod, I couldn't help but see the parallels between my two worlds: art and money.

Money is a huge cause of stress for so many people (especially variable-income, no-safety-net opera singers).

The stress that surrounds money can completely take over your life. The only problem is you can't run away from money (at least not as easily as I ran away from opera).

Luckily, the solution is the same: building up a money technique.

And I know that might not be what you want to hear. You might be like me… just hoping that every day you might wake up and things will be okay. That things will just get better.

You might think you don't have the skills to build a money technique… that you're not good at math, that you can't budget…

But I promise you. If you can go through the painstakingly slow work of building up an artistic technique, you have everything you need to build a money technique, too.

A money technique is built in the same way, by investing hours of time into building solid fundamentals. Instead of breath, it's cashflow (the daily ins and outs of your money), instead of onsets it's deliberate decision making (learning to stop making default money decisions and make the ones you really want), and instead of working with someone to lift your soft palette, you work with someone to find one of a thousand little ways you can make your money life easier (by building a safety net, learning to save, and eliminating debt). 

And, let me be clear, that technique isn't about becoming rich and it's NOT not about finally becoming 'an adult'.

Just like building my singing technique wasn't about becoming the greatest tenor of my generation (because I'm really not).

You build a technique so that you can forget about it and just *live your life* knowing that if something goes wrong, you have a system to fall back on.

## Where do I start?

Okay, that might sound good? But where do you start building that kind of technique?
I'm not going to just serve up a bunch of nice ideas and a fun story about a tenor who likes singing opera again. Here are a few actual places to start. 

[Here's a 10 day email guide](http://www.ragstoreasonable.com/intro-to-your-money/) to help you get control over your money (great for people who don't know where to start)!

<a href="http://www.ragstoreasonable.com/intro-to-your-money/" target="blank"><figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479221461499/2016-11-16---Intro-to-money---cartoon-ad.jpg.jpg)
</figure>
</a>

[Here's a FREE spreadsheet](http://www.ragstoreasonable.com/variable-income-opera/) to help you compare variable income and variable expenses over the course of a year. 

<a href="http://www.ragstoreasonable.com/variable-income-opera/" target="blank"><figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479221607776/2016-11-16---Variable-Income-2.jpg.jpg)</figure></a>

And if you just need someone to talk to… I have weekly office hours… where you can schedule a free 30 minute Skype session to talk to a real person about your money. It's a great place to come to if you really don't know what to do first.

Sign up for this week’s office hours [HERE](http://wp.me/P5xZbb-1e8).

It is not impossible.

Despite what that voice in your head is saying, it's not impossible.

That's how I felt as I drove my tractor up and down the fields wondering how I would ever step out on a stage again.

But I did.

And it wasn’t better right away, there were lots of bad days over those two plus years… but eventually everything changed.

I got my joy back. 
