+++
author = ["authors/greg.md"]
categories = "Review"
date = "2018-03-27T17:30:00-04:00"
lastmod = "2018-03-29T09:31:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522185922045/sq%20-%203.jpg.jpg"
primary_image_credit = "Sarah Ameral & Camille Rogers in Belladonna, FAWN Chamber Creative, 2018. Photo: Julius Haag."
publishDate = "2018-03-27T19:38:00-04:00"
related_articles = ["articles/gareth-matteys-belladonna-is-unashamedly-queer.md"]
related_companies = ["scene/companies/fawn-chamber-creative.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/amanda-smith.md","scene/people/adam-scime.md"]
short_description = "The two happen upon some berries and and with some coaxing, Cloth decides to join this new friend in tasting them. The berries take them on a psychotropic trip where they encounter Atrophy. Atrophy is personified in a dancer who leads them on a wild and destructive rampage of expression."
slug = "what-a-long-strange-trip-its-been-belladonna"
title = "What a long, strange trip it&#039;s been: Belladonna"
+++

On Thursday, March 22, I found myself in a dingy alley in Kensington Market waiting in line to enter the venue for [FAWN Chamber Creative](/scene/companies/fawn-chamber-creative/)'s first staging of their new work-in-progress *Belladonna: A Queer Techno Opera*. We were led downstairs to a basement venue with a white runway hand-painted and strewn with wool and a vine with berries, under a cloudscape of silver foil and cotton. It felt like walking into a super-underground New York fashion show. 

*Belladonna*, directed by Amanda Smith, tells the story of a shepherd, Cloth, who while working in the fields with his flock encounters another shepherd, Lake. The two happen upon some berries and and with some coaxing, Cloth decides to join this new friend in tasting them. The berries take them on a psychotropic trip where they encounter Atrophy. Atrophy is personified in a dancer who leads them on a wild and destructive rampage of expression.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522186159135/59.jpg.jpg)
<figcaption>Adam Scime, Darren Creech, Jeff Côté in Belladonna, FAWN Chamber Creative, 2018. Photo: Julius Haag.</figcaption>
</figure>

Gareth Mattey, Belladonna's librettist and dramaturg, says *Belladonna* is "... about queerness and how we access it and understand it, even in environments that may feel and seem inhospitable." With an improvised score played incredibly creatively by Adam Scime on double bass, Darren Creech on piano, and ACOTE on modular electronics. The sampling and electronics were awesome. ACOTE's playing added the next level (I feel) in contemporary opera. The impovised nature of the orchestration saw the more classic instruments employing a lot of the "tricks and turns" that give modern/contemporary operas their distinctive flavour, the addition of the sampling and modular electronics took this to another, and in my view, more artistic level. It also lent a more timeless feel to actual plot and libretto which were decidedly more antiquity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522186170310/2.jpg.jpg)
<figcaption>Sarah Amerald, Mary-Dora Bloch-Hansen, Camille Rogers in Belladonna, FAWN Chamber Creative, 2018. Photo: Julius Haag.</figcaption>
</figure>

Soprano Sarah Amerald, stepping into the role of Cloth at the last minute, sang the tricky score very, very well. Her voice was controlled and clear and meshed well with the orchestra. As Lake, mezzo-soprano Camille Rogers sang her heart out. Her voice was even-keeled and grounded even in times of intense physicality. Choreographer/dancer Mary-Dora Bloch Hansen as Atrophy was riveting. Her dancing evoking both the joy and chaos that the two shepherds are encountering. The three interacted together seamlessly and it was a very powerful climax to the show.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522186178312/41.jpg.jpg)
<figcaption>Camille Rogers, Mary-Dora Bloch-Hansen in Belladonna, FAWN Chamber Creative, 2018. Photo: Julius Haag.</figcaption>
</figure>

I had trouble finding the "queer" in the story though. Queer people were definitely involved in many levels of creating the show, but I felt the show itself was more of a drug allegory. One could look at the experience of "taking the berry" as the overture into accepting one's queer identity, but the consequences seem to be very negative and destructive. It felt more like a representation of an overdose as it appears that doing this takes Cloth's life. While being queer definitely has its difficulties (and those difficulties vary greatly across our queer spectrum), I found it a little hard to link "accepting one's queerness" to "Cloth's bane" - I think the show's perception of that "queerness" being self-destructive confuses the message a little. One definitively queer aspect of the show was the absence of gender or biological sex. Cloth and Lake could be man or woman or anything in between, and Atrophy's personification (both in look and dance vocabulary) was powerfully androgynous.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522186195549/4.jpg.jpg)
<figcaption>Mary-Dora Bloch-Hansen in Belladonna, FAWN Chamber Creative, 2018. Photo: Julius Haag.</figcaption>
</figure>

I have to give a shout out to Noah Feaver's lighting choices. Cloth and Lake spent large portions of their time on stage lit by handheld incandescent bulbs. The colour wash changes on the stark white room of the venue definitely heightened the "trip" aspect of the shepherds' journey. FAWN is known for its out-of-the box approach to both the storytelling and the music-making of lyric theatre and their shows never disappoint. 
