+++
author = ["authors/carly-gordon.md"]
categories = "Review"
date = "2019-05-02T04:00:00+00:00"
disclaimer = "Content warning: suicide."
image_gallery = []
postamble = "Florida Grand Opera's production of _Werther_ runs through May 11. For details and ticket information, [click here](https://tickets.fgo.org/Tickets/EventDetails.aspx?id=1721). "
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1557073295/media/2019/05/sqFGOWertherMG_7455.jpg"
primary_image_credit = "Dimitri Pittas in the title role of Werther, Florida Grand Opera, 2019. Photo: Daniel Azoulay."
related_articles = ["articles/talking-with-singers-daniela-mack.md"]
related_companies = ["scene/companies/florida-grand-opera.md"]
related_people = ["scene/people/evan-kardon.md", "scene/people/dimitri-pittas.md", "scene/people/daniela-mack.md"]
short_description = "The effect was darkly whimsical and visually captivating, allowing the drama to unravel within a framework of fiction – well-suited to the opera's poetic exaggerations and high-flying emotions."
slug = "a-dismal-opera-werther"
title = "A dismal opera: Werther"
youtube_url = ""

+++
_Werther_ is an opera with its own mythology: when Massenet presented the score to Léon Carvalho, then-director of Paris' Opéra-Comique, Carvalho rejected the work, decrying it as "too dismal." (Meanwhile, Carvalho had no problem greenlighting the premiere of _Lakmé_ or a remount of _Carmen_, apparently finding insufficiently dismal the suicide and violent murder of women of colour.) Then there's the text that inspired the opera's gloomy libretto – a novel by Goethe, aptly titled _The Sorrows of Young Werther_, that supposedly inspired a string of "copycat suicides" in the late eighteenth century.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557073449/media/2019/05/FGOWertherMG_7212.jpg){{% /md %}}

<figcaption>Dimitri Pittas (Werther) and Daniela Mack (Charlotte) in Werther, Florida Grand Opera, 2019. Photo: Daniel Azoulay.</figcaption>

</figure>

> Mack was a highlight, her thoughtful musicality edged with a calm confidence.

Florida Grand Opera's [brand-new production](https://tickets.fgo.org/Tickets/EventDetails.aspx?id=1721), directed by Lawrence Edelson in his FGO debut, took the literary origins of the opera to heart. Set design by Michael Baumgarten saw the characters gliding up and down a pair of inclines, decorated with illegible yet elegant lines of handwriting – Goethe's, perhaps? – as though leaping to life from the pages of an open book. Baumgarten's lighting design placed characters' movements in stark silhouette against a minimalistic coloured backdrop, while a large, gnarled tree loomed above every scene, its leaves replaced by gossamer sheets of paper. The effect was darkly whimsical and visually captivating, allowing the drama to unravel within a framework of fiction – well-suited to the opera's poetic exaggerations and high-flying emotions.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557073354/media/2019/05/FGOWertherMG_6851.jpg){{% /md %}}

<figcaption>Daniela Mack (Charlotte) and Evan Kardon (Sophie) in Werther, Florida Grand Opera, 2019. Photo: Daniel Azoulay.</figcaption>

</figure>

Tenor [Dimitri Pittas](/scene/people/dimitri-pittas/) in the title role sang with a bright timbre, yet unafraid to plunge into moments of melodrama. His portrayal of Werther was an unsympathetic one, his pursuit of Charlotte taking on a darker, possessive bent: he fetishizes her grief over the loss of her mother as imbuing her with the caretaking qualities desired in a wife; and he protests, "C'est moi – It is me whom she should love," after her marriage to Albert. Pittas' final appearance in the Bailiff's home on Christmas Eve had a lurking, ominous quality, and his "Pourquoi me réveiller?" alongside mezzo-soprano [Daniela Mack](/talking-with-singers-daniela-mack/) was sung with an urgency revealing obsession rather than true love.

> Under conductor Joseph Mechavich, the FGO Orchestra performed Massenet's score with attention to detail and a flair for drama.

As Charlotte, Mack was a highlight, her thoughtful musicality edged with a calm confidence. Her characterization was insistent and earnest in her repeated refusals of Werther's advances, making his uninvited returns all the more unnerving. Mack's Letter Aria revealed a rich range of vocal colour, and the larger-than-life emotions portrayed in the scene – Charlotte curled up on the floor beneath a picture-perfect Christmas tree, clutching letters from Werther, helpless and overcome – came across with just the right amount of overdramatic flair.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557073320/media/2019/05/FGOWertherMG_5649.jpg){{% /md %}}

<figcaption>Werther, Florida Grand Opera, 2019. Photo: Daniel Azoulay.</figcaption>

</figure>

As Charlotte's younger sister Sophie, standout soprano [Evan Kardon](/scene/people/evan-kardon/) shone in some of the show's most convincingly acted moments, her effortless dolce timbre complementing her character’s sunny interjections. Baritone Benjamin Dickerson's resonant Albert captured a sense of benign charm; his very first scene, in endearing dialogue with Kardon's Sophie, offered a sweet and memorable musical moment.

Tenor [Dominick Corbacio](/scene/people/dominick-corbacio) and bass-baritone Rafael Porto brought bumbling antics and observant wit to the comedic duo of Schmidt and Johann. Bass-baritone Jake Gardner's Bailiff was strongly sung, though at times seemed out of pace with the orchestra. An outstanding sextet of children's voices – all seasoned performers fresh off FGO's November production of _La bohème_ – brought genuine delight to the stage and elicited charming interactions with the grown-ups around them.

> _Werther_ is indeed a dismal opera, painting a grim portrait of dangerous obsession.

Under conductor Joseph Mechavich, the FGO Orchestra performed Massenet's score with attention to detail and a flair for drama. The memorable orchestral interlude preceding Werther's death scene featured warmly phrased solos from Principal French Horn Madison Allen, joined by oboe, flute, and clarinet in skillfully blended duets. An unexpected gunshot pierced the foreboding interlude, conveyed on stage by a digital projection of a sudden burst of blood.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557073333/media/2019/05/FGOWertherMG_6733.jpg){{% /md %}}

<figcaption>Daniela Mack (Charlotte) Werther, Florida Grand Opera, 2019. Photo: Daniel Azoulay.</figcaption>

</figure>

In the mythos surrounding Werther and its literary complement, Goethe penned the story as a semi-autobiography reflecting on his own experience with heartbreak and unrequited love. The resulting text, however, is far from romantic, coming across as an unsettling fantasy of victimhood in which Goethe – through the fictionalized persona of a lovelorn poet – could imagine the real-life woman who rejected him as, in fact, unable to resist him; and could burden her with blame for his contemplation of suicide. Nowhere is this clearer than in the frustratingly long death scene: "Blood from your wound flows because of me," Charlotte laments over Werther's dying breaths.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557073389/media/2019/05/FGOWertherMG_7673.jpg){{% /md %}}

<figcaption>Daniela Mack (Charlotte) and Dimitri Pittas (Werther) in Werther, Florida Grand Opera, 2019. Photo: Daniel Azoulay.</figcaption>

</figure>

As Léon Carvalho once assessed, _Werther_ is indeed a dismal opera, painting a grim portrait of dangerous obsession. As Werther finally collapses in Charlotte's arms, the voices of children float from offstage, singing Christmas carols with naïve joy, oblivious to the tragedy that has unfolded.