+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2018-04-16T13:02:00-04:00"
lastmod = "2018-04-16T22:25:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523897895104/sqBostonBaroqueFidelio.jpg.jpg"
primary_image_credit = "William Burden as Florestan in Fidelio, Boston Baroque, 2018. Photo: Kathy Wittman."
publishDate = "2018-04-16T22:25:00-04:00"
related_articles = ["articles/a-masked-ball-american-baroque-opera-cos-opera-cabaret.md","articles/in-review-fidelio-other-first-operas.md","articles/real-prisoners-voices-make-heartbeat-operas-fidelio-resonate.md"]
related_people = ["scene/people/anna-christy.md"]
short_description = "It is a great thing, then, that Boston Baroque has mostly found the right cast with which to lead this reading of the opera, especially with Wendy Bryn Harmer. By the end of it, I felt as inspired by Harmer&#039;s portrayal of Leonore as the other characters on the stage: and really, is that not the most important feeling one should have coming out of an opera where good triumphs over evil?"
slug = "wendy-bryn-harmer-leads-sensitive-inspirational-fidelio"
title = "Wendy Bryn Harmer Leads Sensitive, Inspirational Fidelio"
+++

Beethoven's *Fidelio* is the home of one of the stranger paradoxes of the opera world. On the one hand, the music is wonderful, and it does contain quite a large amount of drama within each of the individual numbers. On the other hand, however, the story that Beethoven's score supports suffers from uneven pacing spent developing characters who do not figure prominently into the main conflict of the narrative. This is a duality that any opera company would find daunting when staging the work, but when done right, the show can feel absolutely inspiring. Thankfully, the performance that Boston Baroque gave on Jordan Hall's stage managed to impart this joyous feeling with a briskly-paced show that managed to take out most of the air pockets endemic to the work.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523897975574/BostonBaroqueFidelio1.jpg.jpg)
<figcaption>Wendy Bryn Harmer as Leonore/Fidelio and William Burden as Florestan in *Fidelio*, Boston Baroque, 2018. Photo: Kathy Wittman.</figcaption>
</figure>
           	
The production they put together was only semi-staged, as opposed to fully staged. It is always interesting when opera is taken out of the theater and into the concert hall, as presenting it as a concert always has the effect of highlighting the score. And here, the direction emphasized the score, never letting the spoken dialogue parts move too slowly. The spoken parts were generally well-acted, and one thing that was also smart was that they simply spoke the dialogue in English, before singing all of the music in German. This was a little bit jarring at first, but it lent a natural quality to the spoken dialogue that I imagine would have been lost had the cast attempted to speak it in German. Both of these things did a lot to speed the action along, and while it could not completely override the show's more superfluous numbers, it helped paper over the slower pacing of Act I.

Of course, presenting the score as the most important part of the performance requires a top-notch execution. Boston Baroque was up to the challenge of presenting Beethoven's score, and on period instruments. This focus on informed performance practice added a little attention to detail that is not often heard in performances of Beethoven these days, and Maestro Martin Pearlman's steady hand kept the orchestra engaged with the action at all times. While there were some spots where the orchestra did overpower the singers (and even then, I suspect it was not for lack of trying on their part), and also barring a few understandable brass flubs throughout the first act, it was a nuanced reading of *Fidelio*, and it brought out the thrills of the score wonderfully, from the angry orchestral accompaniment of Pizarro’s revenge aria in Act I to the joyous love duet that marks Leonore and Florestan's reunion after Leonore has just saved his life.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523897982741/BostonBaroqueFidelio2.jpg.jpg)
<figcaption>Wendy Bryn Harmer as Leonore/Fidelio, Anna Christy as Marzelline, and Nathan Stark as Rocco in *Fidelio*, Boston Baroque, 2018. Photo: Kathy Wittman.</figcaption>
</figure>

It also provided great accompaniment for the singers who inhabited the stage of Jordan Hall, and here the performers were top notch. Nathan Stark provided a loveable, playful account of Leonore's superior Rocco, and Anna Christy provided a bright, bubbly Marzelline, such that it was almost a pity that she was so underutilized in Act II. Andrew Stenson's Jaquino was similarly endearing as the ever-beleaguered man vying for Marzelline's affections, toeing the line between being pathetic and sweet without dipping too far into either. Mark Walters, while perhaps a little stiff as an actor in the spoken-word segments, provided a rich, deep voice that imbued his Don Pizarro with the kind of menace that the role requires. And I of course would be remiss without mentioning William Burden's warm, desperate Florestan, as Burden made the most of Florestan's incredibly short time onstage.

But of course, *Fidelio* essentially lives or dies on how believable its main character is, and this is a difficult task both on an acting standpoint and a pure vocal standpoint. In this regard, the real star of the afternoon was Wendy Bryn Harmer, who was a great joy to watch as Beethoven's partly-titular heroine Leonore. She brought a lot of nuance to how she portrayed the character, and what is more she was able to navigate the tricky turns her character endures: she skillfully portrayed her awkward reactions to Rocco's attempts to pawn "Fidelio" onto Marzelline, showed great bravery in the climactic clash against Pizarro, but she also managed to find enough room for the tenderness that is required to bring the character’s motivations together. It was a *tour-de-force* of a performance, and it was only helped by a powerful, precise voice that easily soared over Beethoven's orchestrations and difficult vocal writing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523897998246/BostonBaroqueFidelio4.jpg.jpg)
<figcaption>Andrew Stenson as Joaquino in *Fidelio*, Boston Baroque, 2018. Photo: Kathy Wittman.</figcaption>
</figure>

The production, as per its nature as a semi-staged performance, was suitably sparse enough. However, I thought it was a particularly clever touch that they removed Jordan Hall's organ console and put the doors to the jail cell there: it left a lot of ways to play with the entrances, and it was a wonderful way to introduce the Prisoners' Chorus in Act I. It also chose a fairly interesting look in terms of costuming: the costumes went for something like a generic mid-20th-century dictatorship, and while it does muddy the waters as relates to Don Fernando's role in the story it was an appropriate choice for a story about a man falsely imprisoned by a tyrannical authority figure. There was not much to comment on in the aesthetic otherwise, but it was a consistent and interesting aesthetic all the way through.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523898005617/BostonBaroqueFidelio5.jpg.jpg)
<figcaption>Anna Christy as Marzelline in *Fidelio*, Boston Baroque, 2018. Photo: Kathy Wittman.</figcaption>
</figure>

It is interesting that *Fidelio* has the pacing problems that it does: and yet, with the right cast of people, the denouement can feel as inspiring as anything from the truly great operas of the repertory. It is a great thing, then, that Boston Baroque has mostly found the right cast with which to lead this reading of the opera, especially with Wendy Bryn Harmer. By the end of it, I felt as inspired by Harmer's portrayal of Leonore as the other characters on the stage: and really, is that not the most important feeling one should have coming out of an opera where good triumphs over evil?
