+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2018-02-21T07:47:00-05:00"
lastmod = "2018-02-21T08:42:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519219912908/sq---KA_3357_a-1.jpg.jpg"
primary_image_credit = "Ailyn Pérez (Tatyana Bakst) and Joyce Di Donato (Arden Scott) in Great Scott, The Dallas Opera, 2015. Photo: Karen Almond."
publishDate = "2018-02-21T08:42:00-05:00"
related_companies = ["scene/companies/the-dallas-opera.md"]
related_people = ["scene/people/joyce-didonato.md","scene/people/ailyn-prez.md","scene/people/anthony-roth-costanzo.md","scene/people/jake-heggie.md"]
short_description = "But really, who can argue with the riotous laughter that makes this recording something worthy of a listen? In opera, contemporary or otherwise, it’s a big deal to get an audience who reacts not only to what they see (and what was it they saw that was so funny? Ah, the plight of the live audio recording), but to details in the libretto."
slug = "we-took-a-real-chance-with-great-scott"
title = "&quot;We took a real chance with Great Scott.&quot;"
+++

"There are so many dark stories out there today for new operas," says American composer Jake Heggie, "that to hear people laughing riotously and having a great time in the opera house is really wonderful and refreshing." Heggie is speaking of his opera with librettist Terrence McNally, *Great Scott*, which this year sees the [recording release its world premiere performance](http://www.warnerclassics.com/shop/3252560,0190295940782/joyce-didonato-great-scott) in October, 2015, at [The Dallas Opera](/scene/companies/the-dallas-opera/)'s Winspear Opera House.

In an art-imitates-life sort of casting, [Joyce Di Donato](/scene/people/joyce-di-donato/) plays Arden Scott, the world-class opera singer who returns to the fictional American Opera Company - the company where she had her professional debut - to sing the title role in a long-lost bel canto opera, *Rosa Dolorosa, figlia di Pompei*. Scott has discovered the work herself in Moscow, and she pairs the opera's overdue premiere with a noble attempt to save the struggling opera company. Her efforts are only slightly distracted by rough rehearsals, the return of an old lover, a dressing-room mad scene - and the fact that the opera's opening night falls on the same weekend as the Superbowl.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519220267893/KA_2546_a-2.jpg.jpg)
<figcaption>Act I of Jake Heggie and Terrence McNally's *Great Scott* at Dallas Opera, featuring (left to right) Kevin Burdette, Rodell Rosel, Anthony Roth Costanzo, Joyce DiDonato, Michael Mayes, Ailyn Pérez and Frederica von Stade, 2015. Photo: Karen Almond.</figcaption>
</figure>

"I had never done a comedy, so it was new territory for me," says Heggie, whose well-received *Dead Man Walking*, *Moby-Dick*, and *Three Decembers* take on a decidedly heavier tone. Indeed, the laughs are audible on the live recording, and they're not just light chuckles; more than once, the crowd roars at the insider opera humour, like when Arden Scott pauses mid-cadenza to utter, "This shit is hard."

The opera does feel a bit like a rushed parade of operatic stereotypes: legendary singer romances, shirtless baritones, fame-hungry sopranos, class-clown-like comprimario singers, and even miffed stage managers ("I'm one of the invisible people who makes all of this shit happen."). *Great Scott* strikes a funny balance: the jokes ring true to those in the industry, yet for that same demographic, the jokes are a bit hokey. Lines like, "She's in love with the tenor, but he's married to the soprano...Opera 101!" seem a bit low-bar. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519220285071/KA_2722_a-1.jpg.jpg)
<figcaption>A scene from *Great Scott*, The Dallas Opera, 2015. Photo: Karen Almond.</figcaption>
</figure>

But really, who can argue with the riotous laughter that makes this recording something worthy of a listen? In opera, contemporary or otherwise, it’s a big deal to get an audience who reacts not only to what they see (and what was it they saw that was so funny? Ah, the plight of the live audio recording), but to details in the libretto.

"We took a real chance with *Great Scott* and did an original story that has contemporary resonance, but with characters that people don't necessarily know the minute they walk in," Heggie says, contrasting the fictional Arden Scott with his other operatic characters based in reality (like Sister Helen Prejean in *Dead Man Walking*) or in famous literature (like Captain Ahab in *Moby-Dick*). "That is a risky thing to do."

That risk is helped by this cast, whom Heggie calls "great singing actors who are some of the most hilarious people I know." Di Donato gets self-reflective - or perhaps self-deprecating? - in the role-within-the-role of Rosa Dolorosa, written by Heggie as an exaggerated homage to the great real-life bel canto roles currently owned by the star mezzo. It seems an unpopular thing to point out, that Di Donato’s tendency is to creep sharp at the top of her register, and for a quickening vibrato to come with her fuller singing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519220301712/KA_1871_a.jpg.jpg)
<figcaption>Joyce Di Donato as Arden Scott in *Great Scott*, The Dallas Opera, 2015. Photo: Karen Almond.</figcaption>
</figure>

Nathan Gunn is an audible stereotype as Sid, Arden Scott’s former lover, and casting Frederica von Stade as Winnie Flato, Artistic Director of the American Opera Company, feels like the most meta homage of all, considering Flicka's reputation as a staple singer of the 20th-century opera scene, and her role in Jake Heggie's rise from unknown composer to operatic giant.

[Ailyn Pérez](/talking-with-singers-ailyn-perez/) shows some refreshing comic chops as Tatyana Bakst, the ambitious young soprano who makes a splash singing the national anthem at the Superbowl. She's hard to understand, but perhaps that's the natural result of her thick-tongued Slavic accent. Not surprisingly, it's countertenor [Anthony Roth Costanzo](/scene/people/anthony-roth-costanzo/) who steals the show as Roane, the stage manager, his bold, sassy sound blazing through the din in this live recording. Roane gets plenty of the one-liners that pull laughs from the audience, even if they are groaners. It's a nice touch for Scheer and Heggie to unpack a bit of the "stage manager's plight" in Roane. He has a curious scene with Arden that's half touching, half savage; when Arden tell him she loves him - in that way that anyone loves a person who makes their life easier - he claps back, "Next month, Turandot will tell me that she loves me too."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519220322973/GS-Backstage-1.jpg.jpg)
<figcaption>The creative team of *Great Scott*, The Dallas Opera, 2015.</figcaption>
</figure>

*Great Scott* has layers, elements that add up to an impressive feat. Heggie and Scheer achieved that tricky balance of comedic pacing, as the composer describes it, "so that you get the laughs that you want, and you avoid the laughs you don’t want." The opera also looks frankly at its own industry. What's the real significance of reviving a lost *bel canto* gem if it's competing for audiences with the Superbowl? Heggie muses, "I don’t think sports are going away any time soon, but what about the opera world?"

>The live recording of *Great Scott* is released on [Warner Classics](http://www.warnerclassics.com/shop/3252560,0190295940782/joyce-didonato-great-scott), and is also available through [iTunes](https://itunes.apple.com/ca/album/heggie-great-scott/1314763926?ign-mpt=uo%3D4).

