+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-08-03T13:17:00-04:00"
lastmod = "2017-08-04T10:38:00-04:00"
preamble = "[The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/)'s touring production of [*Sweat*](/in-review-sweat/) has arrived in Toronto, playing at the Aki Studio at Daniels Spectrum **August 3-6**. \n\n\"*Sweat* takes us to the heart of a contemporary sweat shop. The garment industry has factories around the world from Mexico to Pakistan. Our factory is a fictional one made up of a kaleidoscope of nationalities represented by the women who work there. The show begins late one night in their dormitory, as the women get ready for bed and watch a horse race on TV.\"\n\nIt's a moving piece by composer [Juliet Palmer](/scene/people/juliet-palmer/) and librettist [Anna Chatterton](/scene/people/anna-chatterton/), and we were fortunate to chat with Bike Opera about what it means for them to bring the story of *Sweat* to Canadian audiences."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501780862561/2017-08-03---Square---Sweatstills-photobyDahliaKatz-4986.jpg.jpg"
primary_image_credit = "Production image from Sweat, Bicycle Opera Project, 2017. Photo: Dahlia Katz."
publishDate = "2017-08-03T22:40:00-04:00"
related_articles = ["articles/in-review-sweat.md"]
related_companies = ["scene/companies/the-bicycle-opera-project.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/juliet-palmer.md","scene/people/anna-chatterton.md","scene/people/larissa-koniuk.md","scene/people/geoffrey-sirett.md","scene/people/stephanie-tritchew.md","scene/people/emma-char.md","scene/people/caitlin-wood.md","scene/people/catherine-daniel.md","scene/people/keith-lam.md"]
short_description = "&quot;This is the perfect opera for Bicycle Opera! It has given us an amazing opportunity to tour this work to locations outside of the regular concert venue, since we don&#039;t need a piano or any space for our instrumentalists. This year, we were able to bring the show to some spaces that had a direct connection to the material.&quot;"
slug = "we-all-wear-clothes-they-sit-right-on-our-skin"
title = "&quot;We all wear clothes. They sit right on our skin.&quot;"
+++

## What is *Sweat* about? 

*Sweat* is an a cappella opera about the women who sew our clothes. The opera takes place in the heart of a contemporary sweatshop where a conflict arises around the movement to organize a union.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501780830802/2017-08-03---Sweatstills-photobyDahliaKatz-5055.jpg.jpg)
<figcaption>Production image from *Sweat*, Bicycle Opera Project, 2017. Photo: Dahlia Katz.</figcaption>
</figure>

## What do you think *Sweat* says about Canadian society, and the distance many of us have between what we buy, and how it's made?

Composer Juliet Palmer puts it really well. She often states that we all wear clothes. They sit right on our skin, but we rarely think about the other hands that have touched these garments. It is both an intimate and anonymous relationship at the same time.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501780843770/2017-08-03---Sweatstills-photobyDahliaKatz-5033.jpg.jpg)
<figcaption>Production image from *Sweat*, Bicycle Opera Project, 2017. Photo: Dahlia Katz.</figcaption>
</figure>

## How will an *a cappella* opera change your touring plans?

This is the perfect opera for Bicycle Opera! It has given us an amazing opportunity to tour this work to locations outside of the regular concert venue, since we don't need a piano or any space for our instrumentalists. This year, we were able to bring the show to some spaces that had a direct connection to the material.

As part of Ottawa Chamberfest, we brought *Sweat* to the Textile Museum in Almonte, where tapestries and old weaving machines provided an amazing backdrop to the piece.

In Hamilton, we played at the Workers Arts and Heritage Centre, a space that presents artwork about the history of labour. Their space is the old Customs House that used to process the cotton that was shipped in and then spun in the textile factories in Hamilton.

And in Bloomfield, Prince Edward County, we presented *Sweat* in an old canning factory-turned artist centre.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501780855480/2017-08-03---Sweatstills-photobyDahliaKatz-4979.jpg.jpg)
<figcaption>Production image from *Sweat*, Bicycle Opera Project, 2017. Photo: Dahlia Katz.</figcaption>
</figure>

## What do you hope audiences will take away from Bicycle Opera's performances?

I hope the audience will be compelled by this provocative story, and fall in love with the music the way we have! Juliet and Anna have written a really interesting piece that has challenged both us as performers and musicians and audiences along tour!

I also hope that audiences might consider some options we have found: Our new friend, Robin Pacific, has started a campaign called [Take Action FAST](https://www.actionfast.org/action), which asks the major retailers, such as Joe Fresh, and the Gap, to increase retail prices by just 5% in order to meet safe and fair working conditions for workers oversees.

On the opposite end of the spectrum, local makers, such as [Jennifer Fukushima](https://www.jenniferfukushima.com/) make all of their clothing by hand, locally and ethically, and source ecologically responsible fabrics, and even upcycle used garments. Many of our cast members shop second hand or frequent clothing swaps as well – so less ends up in landfill too!

I think all of these angles are good ones, and I hope audiences consider some new options.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/CnBTtvbv8yo" frameborder="0" allowfullscreen></iframe>
</figure>

>*Sweat* plays at the Aki Studio at Daniels Spectrum **August 3-6**. For details and ticket information, [click here.](http://bicycleopera.com/upcoming-sweat/)
