+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-01-15T15:06:00-05:00"
lastmod = "2016-01-19T14:21:00-05:00"
preamble = "Just like all the different ways a human voice can sound to our ears, each conductor brings their unique presence to an orchestra. A different posture, a different flow of gesture can bring out a huge variance of sound from the players as they react to what they see. Conducting is much, *much* more than a clear beat pattern, and we wanted to show our readers just how differently rhythmic information can look. \n\nNow, [Anthony Pappano's sporting of a GoPro](https://www.youtube.com/watch?v=JiIo16E1VtY) camera while he conducts a rehearsal is pretty neat, but we'd rather show you the big picture. We've selected clips of 8 conductors and their 8 unique styles at work; have a look, and ask yourself, who would you want to follow?"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453072264473/2016-01-17%20-%20Conductors.jpg.jpg"
primary_image_credit = "Clockwise from top left: Barenboim, Karajan, Bernstein, Alsop, Nézet-Séguin, and Kleiber."
publishDate = "2016-01-19T13:00:00-05:00"
related_articles = ["articles/conductors-what-else-do-they-tell-us.md","articles/the-dallas-opera-picks-its-women-conductors.md","articles/potential-orchestra-mutiny-and-conductor-envy.md","articles/the-olympics-of-singing-semiramide-at-roh.md"]
related_people = ["scene/people/yannick-nezet-seguin.md"]
short_description = "Just like all the different ways a human voice can sound to our ears, each conductor brings their unique presence to an orchestra. A different posture, a different flow of gesture can bring out a huge variance of sound from the players as they react to what they see. Conducting is much, much more than a clear beat pattern, and we wanted to show our readers just how differently rhythmic information can look. "
slug = "watch-learn-maestros-at-work"
title = "Watch &amp; learn: maestros at work"
+++

## Carlos Kleiber

In this clip, Kleiber conducts Beethoven's 7th Symphony from memory, one of any maestro's most impressive tricks. He stands tall, with great posture, assuming the spotlight as part of the show. His gestures are fluid, and they travel right from his core through to his fingertips. He's somewhat all limbs, but he follows through on his movements, kind of like a pitcher on the mound. That commitment to physicality makes an orchestra play with their full depth of sound, and feel phrase tension in the dance-like way that Kleiber does. Have a look:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/-i_2EA_ZgKI" frameborder="0" allowfullscreen></iframe></figure>

## Daniel Barenboim

Barenboim epitomizes the title of *maestro*, conducting de Falla's *Ritual del fuego* with a controlled power. His beats vary in attack, meaning he can bring a huge palate of sound out of the orchestra; yet, his motions are purposeful, masculine, and his whole body is emitting rhythm. Even his climactic flailings are extending from a grounded, solid posture, never off his balance. Controlled, purposeful, masculine, beats are pulsing through him, really directing the music, his arms flail as bursts of energy from his core. It's total strength at the podium.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/auRUxPPqDcQ?start=30" frameborder="0" allowfullscreen></iframe>
</figure>

## Leonard Bernstein

Perhaps Bernstein's movements are less precise, but there's more natural bounce in his body. He keeps his movements efficiently confined to a small area, yet carries no tension. All of this is exaggerated when Bernstein conducts his own music, which you can see [here with his *Candide* overture](https://www.youtube.com/watch?v=422-yb8TXj8). He stays loose even in Mahler; here's a clip of him conducting his 3rd symphony:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/1AwFutIcnrU?start=656" frameborder="0" allowfullscreen></iframe></iframe></figure>

## Riccardo Muti

Muti conducts with a tautness and a precision that, oddly, still seems entirely Italian. He's confident and tidy with his movements, contained and rarely out of control; his large gestures are wide and purposeful, but quite different from Kleiber's or Bernstein's. Now, in the clip below he's conducting the overture to Rossini's *Semiramide*, which suits Muti's physicality; he employs his precision for a different effect with the [Intermezzo from Mascagni's *Cavalleria Rusticana*](https://www.youtube.com/watch?v=fZynaqyy7MI).

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/EwSwN1rl5wU?start=141" frameborder="0" allowfullscreen></iframe>
</figure>

## Herbert von Karajan

Just like the sound he pulls from an orchestra, Herbert von Karajan conducts with beautifully grounded posture. Everything about him is stable, and though he flows easily from one movement to the next, the flow is carefully crafted. In his energetic, triumphant moments, he still demands a noticeable control. In the clip below, Karajan conducts the overture to *Tannhäuser*, and you can see immediately that he's in it for the long haul, patiently riding Wagner's far-reaching phrases. 

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/7b5R2TBIBgs?start=35" frameborder="0" allowfullscreen></iframe>
</figure>

## Marin Alsop

Maestra Alsop is precise and clear, and her beats are all about the ricochet that goes through her body. Her movements are comfortable and free, and when the music calls for it, [she even dances](https://www.youtube.com/watch?v=625WOYzdvFw). She has an air of encouraging great sound from her orchestra, rather than strictly directing them. The clip below is a great example; Alsop conducts John Adams' *Short Ride in a Fast Machine* at the BBC Proms, 2014. 

<figure data-type="video"><iframe width="854" height="480" src="https://www.youtube.com/embed/5LoUm_r7It8" frameborder="0" allowfullscreen></iframe>
</figure>

## Yannick Nézet-Séguin

Yannick Nézet-Séguin is a tight ball of energy when he conducts, and he constantly releases tension with his supported and spontaneous-seeming movements. His big moments come right out of his lower back, and his face is full of cheerleading for his players. Great example: the [last few seconds](https://www.youtube.com/watch?v=HBY5Mb90_lw) of Prokofiev's 5th Symphony. He's detail-oriented, almost schizophrenic, finding endless lines to bring out from all over the orchestra. Check out this clip of Yannick conducting Tchaikovsky's *Fantasy-Overture* from *Romeo and Juliet*.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/_Y_tLuudGGk?start=375" frameborder="0" allowfullscreen></iframe>
</figure>

## James Levine

There's always a good dose of joy and abandon in Maestro Levine's conducting. It goes with his uninhibited gestures, which come from a relaxed, efficient posture. He seems to have a relationship with his orchestra that's based on trust and respect for what they do, and like Nézet-Séguin and Alsop, he's a [constant cheerleader](https://youtu.be/PQI5LtRtrb0) of their music-making. He never expels more energy than he needs, staying small when he can and listening plenty. Here's a clip of him conducting the overture to Rossini's *L'italiana in Algeri*.

<figure data-type="video"><iframe width="854" height="480" src="https://www.youtube.com/embed/-rIatVmpjDA?start=105" frameborder="0" allowfullscreen></iframe>
</figure>

>What conductors do you like to watch? Let us know in the comments below!
