+++
author = ["authors/erik-flaten.md"]
categories = "Review"
date = "2017-09-18T15:25:00-04:00"
lastmod = "2017-09-18T21:42:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505766130532/2071-09-18---square---war-stories02.jpg.jpg"
primary_image_credit = "Daniel (Craig Verm) & Sorrel (Cecelia Hall) in I Have No Stories to Tell You. Photo: Dominic M. Mercier/Opera Philadelphia."
publishDate = "2017-09-18T21:42:00-04:00"
related_articles = ["articles/catharsis-is-the-wrong-word-brittens-war-requiem.md"]
related_companies = ["scene/companies/opera-philadelphia.md"]
related_people = ["scene/people/rachel-calloway.md","scene/people/sarah-tucker.md","scene/people/abigail-levis.md","scene/people/cecelia-hall.md","scene/people/samuel-levine.md","scene/people/craig-verm.md"]
short_description = "Beecher&#039;s score is a gripping manifestation of the heart-breaking and heavy content of the libretto. His choice to use the same instruments that were used in the Monteverdi is a brilliant blend of past and present. From the very first eerie sounds that welcome us into the world of the piece, one hears similarities to George Crumb&#039;s Black Angels, which is a response to the Vietnam War."
slug = "war-stories-o17"
title = "&quot;Humanity&#039;s bond to war&quot;: War Stories at O17"
+++

Whiskey and beer. Wine and Cheese. Sonny and Cher. Beecher and Monteverdi. Last night at the Philadelphia Museum of Art, a nearly-sold out performance immersed an audience in a perfect pairing of two great operas. [*War Stories*](https://www.operaphila.org/whats-on/on-stage-2017-2018/war-stories/) is a double-bill program, which was first presented to New York City audiences in 2014 at the Metropolitan Museum of Art. The night combines *Il combattimento di Tancredi e Clorinda* by Monteverdi and *I Have No Stories To Tell You*, with music by Lembit Beecher and incredible libretto by Hannah Moscovitch. In between the two contrasting works, audiences are invited into the Arms and Armor Exhibit. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505765694745/2017-09-18---war-stories09.jpg.jpg)
<figcaption>Composer Lembit Beecher's *I Have No Stories to Tell You* is performed in the Philadelphia Museum of Art's Great Stair Hall. Photo by Dominic M. Mercier for Opera Philadelphia.</figcaption>
</figure>

*Il combattimento* is performed in the cloister of the Art Museum, a space truly perfect for the experience, as it establishes an intimate and fascinating connection between the audience and performers. The music sounds remarkable in the space, and the cloister only magnifies the precise and thrilling playing of the stellar ensemble, led by Gary Thor Wedow from the harpsichord. The presentation of such an early opera is an exciting opportunity to reveal the dramatic possibilities of this canon of works. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505765705983/2017-09-18---war-stories05.jpg.jpg)
<figcaption>Composer Lembit Beecher's *I Have No Stories to Tell You* is performed in the Philadelphia Museum of Art's Great Stair Hall. Photo by Dominic M. Mercier for Opera Philadelphia.</figcaption>
</figure>

A first rate cast makes us aware of the full potential for this genre of music. Baritone [Craig Verm](/scene/people/craig-verm/)'s voice resonates richly and beautifully in the hall. Mezzo-soprano [Cecelia Hall](/scene/people/cecelia-hall/) shows us that she is no stranger to the stylization of Monteverdi, singing with a beautiful depth that matches the surroundings. Philadelphia audiences have now heard Hall within just one year sing Mozart, Monteverdi and Beecher with nuance, class, and superior musicianship. What more proof do we need that she is a world-class vocalist? Tenor [Samuel Levine](/scene/people/samuel-levine/) sings Testo with a brilliant and accurate ornamentation. Mezzo-soprano [Abigail Levis](/scene/people/abigail-levis/) also sings Testo, and her singing is a masterclass in itself on grounded technique, which achieves consistent beauty in its sound. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505765716326/2017-09-18---war-stories04.jpg.jpg)
<figcaption>Daniel (baritone Craig Verm) and Sorrel (mezzo-soprano Cecelia Hall) struggle through their marriage, and the night, in Lembit Beecher's *I Have No Stories to Tell You*. Photo by Dominic M. Mercier for Opera Philadelphia.</figcaption>
</figure>

*I Have No Stories To Tell You* shifts from the intimate space of the cloister to the famously vast Great Stair Hall of the Art Museum. The setting is modern, and we recognize the similarities between the singers and the current generation of individuals deployed overseas. The believability of the singers brings the story even closer to home. With our country's leadership talking about increasing military presence in Afghanistan, this story needs to be told. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505765726550/2017-09-18---war-stories01.jpg.jpg)
<figcaption>Tancredi (baritone Craig Verm) and Clorinda (mezzo-soprano Cecelia Hall) say goodbye in Monteverdi's *Il Combattimento di Tancredi e Clorinda*. Photo by Dominic M. Mercier for Opera Philadelphia.</figcaption>
</figure>

Using the same cast as the Monteverdi work further emphasizes the parallels between the two narratives. Cecelia Hall and Craig Verm are such commanding actors, that witnessing their characters' pain is excruciatingly unavoidable. [Sarah Tucker](/scene/people/sarah-tucker/), [Rachel Calloway](/scene/people/rachel-calloway/), and Abigail Levis are three "memories," occupying a cerebral space, like three haunting furies singing visceral, Britten-esque harmonies. Samuel Levine sings the role of Noah, giving a powerful voice to a flawed and tortured man. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505765738259/2017-09-18---war-stories07.jpg.jpg)
<figcaption>Daniel (baritone Craig Verm) and Sorrel (mezzo-soprano Cecelia Hall) struggle through their marriage, and the night, in Lembit Beecher's *I Have No Stories to Tell You*. Photo by Dominic M. Mercier for Opera Philadelphia.</figcaption>
</figure>

The staging on the stairs themselves adds great effect to the already tense drama. On the lower level of the stairway, we feel as if we are in the living world, while the upper levels are the tortured memories of Sorrel's past. Thanks to the sound design by Daniel Perelstein all sounds remains consistent, no matter where the action moves.

Beecher's score is a gripping manifestation of the heart-breaking and heavy content of the libretto. His choice to use the same instruments that were used in the Monteverdi is a brilliant blend of past and present. From the very first eerie sounds that welcome us into the world of the piece, one hears similarities to George Crumb's *Black Angels*, which is a response to the Vietnam War. Beecher's writing for the voice is natural and fluid, flowing speech-like from the singers. Director Robin Guarino deserves much credit for creating a cohesive and organic performance. Both the staging and the music functioned as one.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505765759310/2017-09-18---war-stories03.jpg.jpg)
<figcaption>Daniel (baritone Craig Verm) and Sorrel (mezzo-soprano Cecelia Hall) struggle through their marriage, and the night, in Lembit Beecher's *I Have No Stories to Tell You*. Photo by Dominic M. Mercier for Opera Philadelphia.</figcaption>
</figure>

Through the setting of [*War Stories*](https://www.operaphila.org/whats-on/on-stage-2017-2018/war-stories/) with the Arms and Armor exhibit, we reflect on the unpleasant reminder of humanity's bond to war. Aaron Copland said, "so long as the human spirit thrives on this planet, music in some living form will accompany and sustain it and give it expressive meaning." Perhaps what Beecher, Monteverdi and Moscovitch are telling us through *War Stories*, is that as long as we are here, war will scar humanity and art will be our reply to its brutality.

>War Stories runs with limited availability through September 23. For details and ticket information, [click here.](https://www.operaphila.org/whats-on/on-stage-2017-2018/war-stories/)
