+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-07-28T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1564334361/media/2019/07/sqWNOWarandPeace.jpg"
primary_image_credit = "A scene from WNO's War and Peace, ROH, 2019. Photo: Clive Barda."
related_articles = []
related_companies = ["scene/companies/welsh-national-opera.md", "scene/companies/royal-opera-house.md"]
related_people = []
short_description = "Writing an opera of this scale is not a simple charge and the task of producing it faces even more challenges; it is an immense work to attempt to pay homage to. There were a few magical, sparkling moments on stage that were completely true to the book, perfectly capturing the essence of Tolstoy's words. "
slug = "poutneys-oversimplified-war-and-peace"
title = "Pountney's oversimplified War and Peace"
youtube_url = ""

+++
The Welsh National Opera bring their ambitious 2018 production of Prokofiev's mammoth _War and Peace_ to the Royal Opera for two performances after successful run last year in Cardiff, a feat not unlike the reading of Tolstoy's epic on which it is based. Written in the 1940s, during the time of the German invasion of the Soviet Union and the Great Patriotic War, Prokofiev's version of the novel draws direct comparison to the unrest experienced during the Napoleonic invasion of 1812 upon which the story is centred. 

>There were a few magical, sparkling moments on stage that were completely true to the book.

During the 1940s _War and Peace_ became a symbol of nationalistic pride for the people of Russia as they struggled to maintain their country's freedom. Robert Innes Hopkins' production designs heightened this parallel by contrasting the lavish 19th-century ballroom of Imperial Russia in Act I (Peace) with scenes of warfare and turmoil of a 20th-century, German-occupied Russia (War). This provided some historical context for the opera, connecting the two works and demonstrating how Prokofiev's opera was inspired by and has become a continuation of Tolstoy's great novel.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1564334446/media/2019/07/WNOWarandPeace.jpg){{% /md %}}

<figcaption>A scene from WNO's War and Peace, ROH, 2019. Photo: Clive Barda.</figcaption>

</figure>

It was a shame though that for all this clever production design, director David Poutney's generalized broad brushstroke approach to the staging did very little to aid the storytelling. _War and Peace_ though wholly operatic in its grand, overarching themes does not in fact lend itself very well to the stage. 

>The English is jarring, infantile, and wholly unsuited to the landscape of Prokofiev's surging, impassioned score.

Prokofiev and librettist Mira Mendelson have written a simplified version of the story which touches on all of Tolstoy's main plot points but those who have read the novel will mourn the loss of some sorely needed backstory and character development. Weak characterization and ambiguous gesture led to performances across the board were well sung but overall, unimaginative.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1564334435/media/2019/07/WNOWarandPeace2.jpg){{% /md %}}

<figcaption>A scene from WNO's War and Peace, ROH, 2019. Photo: Clive Barda.</figcaption>

</figure>

This sense of oversimplification was pronounced due to the fact that the opera was sung in English, a standard practice for WNO. It is a somewhat contentious issue, but in the modern age of surtitles, the translation of operas from their original language to English for accessibility purposes has been rendered utterly useless and should be thrown out as a concept. The English is jarring, infantile, and wholly unsuited to the landscape of Prokofiev's surging, impassioned score which is overwhelmingly Russian in character.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1564334422/media/2019/07/WNOWarandPeace3.jpg){{% /md %}}

<figcaption>A scene from WNO's War and Peace, ROH, 2019. Photo: Clive Barda.</figcaption>

</figure>

Writing an opera of this scale is not a simple charge and the task of producing it faces even more challenges; it is an immense work to attempt to pay homage to. There were a few magical, sparkling moments on stage that were completely true to the book, perfectly capturing the essence of Tolstoy's words. A detailed attention to staging would have provided more of these moments, connecting the pieces of a fragmented and rambling opera, and bringing out the truth of these wonderful characters Tolstoy created.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1564334410/media/2019/07/WNOWarandPeace-WNOCastofWarandPeace.jpg){{% /md %}}

<figcaption>A scene from WNO's War and Peace, ROH, 2019. Photo: Clive Barda.</figcaption>

</figure>