+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-01-19T23:54:00-05:00"
lastmod = "2016-01-20T11:40:00-05:00"
preamble = "Canadian mezzo-soprano [Wallis Giunta](/scene/people/wallis-giunta/) is getting ready to join the [Tapestry Opera](/scene/companies/tapestry-opera/) team for [*Songbook VI*](https://tapestryopera.com/songbook-vi/), the sixth annual concert of new operatic works presented by the emerging artists of Tapestry's New Opera 101 program. With her own extensive experience with traditional and new opera (Mozart's *Così fan tutte* at the Canadian Opera Company, Adams' *I Was Looking at the Ceiling and Then I Saw the Sky* at Teatro dell'opera di Roma), Giunta will work with these young artists alongside Tapestry's Resident Conductor [Jordan de Souza](/scene/people/jordan-de-souza/) to present [*Songbook VI*](https://tapestryopera.com/songbook-vi/), February 5 and 6, in their Distillery District studio. \n\nGiunta chats about working with Tapestry Opera, and the crucial role new music plays in the careers of opera singers today."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453265621744/2016-01-20---Wallis-Giunta.jpg.jpg"
publishDate = "2016-01-20T11:31:00-05:00"
related_articles = ["articles/he-saidshe-said-songbook-v.md","articles/he-saidshe-said-songbook-vi.md"]
related_companies = ["scene/companies/tapestry-opera.md"]
related_people = ["scene/people/wallis-giunta.md","scene/people/jordan-de-souza.md","scene/people/michael-mori.md"]
short_description = "Canadian mezzo-soprano Wallis Giunta is getting ready to join the Tapestry Opera team for Songbook VI, the sixth annual concert of new operatic works presented by the emerging artists of Tapestry&#039;s New Opera 101 program. Giunta chats about working with Tapestry Opera, and the crucial role new music plays in the careers of opera singers today."
slug = "wallis-giunta-songbook-vi"
title = "Wallis Giunta &amp; Songbook VI"
+++

## What will your role be with Tapestry's *Songbook VI*?

I’ll be teaching masterclasses on contemporary opera, along with [Jordan de Souza](/scene/people/jordan-de-souza/) and [Michael Mori](/scene/people/michael-mori/) of [Tapestry Opera](/scene/companies/tapestry-opera/). We’ll be working with the participants for three days one-on-one, and in a group setting, to prepare them for our two [*Songbook VI*](https://tapestryopera.com/songbook-vi/) concerts: the evenings of Feb 5th and 6th. I’ll also be performing a couple pieces, myself, for the concerts!

## What have you learned about performing contemporary opera that you look forward to sharing with these young singers?

I have been performing new music since I was 8 years old in the Central Children’s Choir in Ottawa, and if there’s one thing I’ve learned, it’s that the rewards are definitely worth the extra effort. New music can be daunting and quite scary for many singers, especially those who might have gotten their start in classical music later than others. 

It really does get easier every time, though. It’s like any other language. You start to develop a musical vocabulary in these less-than-tonal pieces, and suddenly things just make sense and become clear. Like wiping the fog off a window. The off-beat rhythms become second nature once you get them in your body. It can be so much more rewarding than traditional classical repertoire, because the themes and stories are relevant NOW and speak to our current culture and societal values. 

Also, anything goes: I did a new opera once, with a live DJ as the “orchestra” and it was one of the most thrilling experiences I’ve ever had on stage (*Pandora’s Locker*, by [Dean Burry](/scene/people/dean-burry/)).

## How does contemporary opera fit in with the careers of singers today? 

Some of my colleagues have a good balance of traditional repertoire and new works on their schedule, but not all. I’d say most of us do one or two 20th or 21st century pieces per season. I think I probably do more new works than the average singer, but then again, I seek out those kinds of projects! 

There are so many commissions happening these days, and remounts of other modern works, that there really is a good market for singers willing to perform contemporary rep.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453306812980/Wallis-Giunta---pc---Dario-Acosta.jpg.jpg)
<figcaption>Wallis Giunta, mezzo-soprano. Photo by Dario Acosta.</figcaption></figure>

## Why is singing new music an important "niche skill" to develop?

I think it is vital for all singers to engage in contemporary opera, not only to keep themselves fresh and in-the-game as musicians, but to keep apace with the direction most major opera companies are going. What opera house is not commissioning premieres these days? There is a big movement across the board to cultivate new opera, with organizations like Tapestry and Opera America leading the charge. Why would any singer want to limit themselves by saying, "Oh, I can’t do that kind of stuff – please only consider me for traditional rep"? 

There is so much variety in contemporary opera now, that there’s really no excuse for any kind of singer to say that it doesn’t suit them. Plus, if we want opera to have a future, we ALL have to be a part of it.

## Do you notice any particular styles or themes that are unique to contemporary operatic repertoire?

There are definitely a lot of references to 20th century popular music in new opera. I hear a ton of jazz in many of the pieces I premiere, sometimes covertly woven in, and sometimes in blatant homage (John Adams!). 

As I said earlier, the themes are very often directly inspired by current events, social and cultural issues of today, and even our political climate. It can be really exciting to be a part of something that is not only relevant, but helping people to understand the world they live in right now.

>For details and ticket information for Songbook VI, follow the box office links below.
