+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2018-11-10T12:27:00-05:00"
lastmod = "2018-11-10T13:27:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541870795258/sqWhitneyRobinson_StephenSalters.jpg.jpg"
primary_image_credit = "Whitney Robinson and Stephen Salters in Le médecin malgré lui"
publishDate = "2018-11-10T12:27:00-05:00"
related_companies = ["scene/companies/odyssey-opera.md"]
short_description = "But of course, Stephen Salters proved to be the definitive star of the night with the way he played the role of Sganarelle. Salters proved to be an extremely versatile performer whose comedy was absolutely on point throughout the whole, be it from his tasteful vocal colorations in his drinking song to the exasperation towards his near-hanging at the end of the opera."
slug = "wacky-silly-medecin-malgre-lui-an-over-the-top-delight"
title = "Wacky &amp; silly Médecin malgré lui an over-the-top delight"
+++

Molière as a playwright was a man given to the silly and over-the-top when it came to lampooning the conventions of his time. This is especially so for any adaptations of plays starring his Sganarelle character, who often received lengthy monologues thanks to the fact Molière played him rather often in productions. It is thus that we arrive at the central issue surrounding Gounod's rarely-performed opera (accompanied, in this case, by recitatives by Erik Satie) based on his [*Le médecin malgré lui*](https://www.odysseyopera.org/2018-gounod-le-medecin-malgre-lui/): in order for any performance of this opera to work, the singers have to play directly into the absurdity.

As usual, Odyssey Opera provided a rather excellent reading of this rarely-performed work, and in this case it was entirely up to the singers on-stage to deliver the comedy and in spades. In this regard, the characters that graced the stage of the Huntington Avenue theater were more than accomplished in this regard, and I get the feeling that Jules Barbier and Michel Carré's libretto was immensely helpful.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541870696972/Ensemble_1.jpg.jpg)
<figcaption>*Le médecin malgré lui*, Odyssey Opera, 2018. Photo: Kathy Wittman.</figcaption>
</figure>

There was, for instance, Kristen Watson's Lucinde, the patient of the quack doctor of the title. Lucinde's role is a very ridiculous kind of lovesick where she has clearly made up her mind. Watson played into this with a quick voice, with her somewhat whispy tone color just making her role even funnier, especially with the hi's and the ho's that she barked out when she first sings in the opera. Then there is Tascha Anderson's Jacqueline, a crafty maid whose down-to-earth demeanor more or less serves to mock the absurd idiosyncracies of everyone around her. Her sharp voice provided punctuation on this function of her character, and her acting bolstered that. There was also James Demler's take on the stuffy noble Géronte, and his acting perfectly embodied this with the way he gestured wildly.

But of course, Stephen Salters proved to be the definitive star of the night with the way he played the role of Sganarelle. Salters proved to be an extremely versatile performer whose comedy was absolutely on point throughout the whole, be it from his tasteful vocal colorations in his drinking song to the exasperation towards his near-hanging at the end of the opera. The best part of the evening was easily his big scene inside the house, though: I just about lost it laughing when he went on a quack diagnosis involving ratting off a Hippocrates quote and then rambling on in Latin with words and phrases that did not really mean anything, and that should say something considering that he somehow managed to top that in a bit about curing disease using a block of bleu cheese. (No, I am not making that up!) I imagine that most singers probably would have lost some of their faculties at some of this ridiculousness, but Salters expertly delivered the exact spirit of ridiculousness that Gounod so effectively captures in the way he set Barbier and Carré's libretto.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541870710962/StephenSalters_1.jpg.jpg)
<figcaption>Stephen Salters in *Le médecin malgré lui*, Odyssey Opera, 2018. Photo: Kathy Wittman.</figcaption>
</figure>

Rounding out this stellar cast were a few other characters: Piotr Buszewski's Leandre provided a warm counterpoint to all the insanity around him, where even in his disguised form his lyrical tenor voice grounded the character in a sense of sincerity. Then there was Whitney Robinson as Sganarelle's put-upon wife: her expressions and body language were absolutely hilarious, and aided the character's small function in the plot quite well. And of course, there was Stefan Barner's Lucas and Ryne Cherry's Valère: Barner and Cherry provided rather good work when it came to setting up the plot, including a hilarious scene where they beat Sganarelle on suggestion from his wife.

All in all, this excellent cast did what Odyssey Opera has proved to be so adept at throughout all of their productions: that tendency to display a rarely-performed work and showcase everything that makes the work in question great. And here, there is no question that they've stumbled upon a gem: Gounod's music is incredibly light and contains just the right amount of French Baroque influence, and while some of this is admittedly due to recitatives that were later composed by Erik Satie, it provides the perfect backdrop for this drama to play out.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541870756868/PiotrBuszewski.jpg.jpg)
<figcaption>Piotr Puszewski in *Le médecin malgré lui*, Odyssey Opera, 2018. Photo: Kathy Wittman.</figcaption>
</figure>

And of course, it should almost go without saying that Maestro Rose once again pulled a performance out of his orchestra that perfectly encapsulated the spirit of fun that surrounds this work, with an orchestra whose playing was precise and light, even if some of the singers had a tendency to get a little ahead of his beat on occasion.

Of course, staging such ridiculousness does run into its own pitfalls, and here the directive team did stumble a few times. They probably were not helped by the fact that the score does occasionally take too long to get to the next comedic set piece, but there were times where the staging also seemed too busy for its own good, such as all the stage business that occurs when Leandre sings to the power of love in his first appearance. There was also a bit with a toy horse that, while cute, did not really seem to serve that much of a purpose, and could have been dropped to no effect. Still, it was effective, as the set design and the costume design both opted to go with designs that stayed out of the singers' way and let them indulge in the zaniness central to a performance of any adaptation of Molière.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541870763850/Ensemble_3.jpg.jpg)
<figcaption>*Le médecin malgré lui*, Odyssey Opera, 2018. Photo: Kathy Wittman.</figcaption>
</figure>
	
Overall, Odyssey Opera's mission statement came through once again, with a delightful production of a lost gem in the operatic repertory. Like all things Molière, it does rely heavily on excellent casting, and here Odyssey Opera has delivered in spades. It led to an overall delightful night at the opera, and one that showed a lighter side to Charles Gounod that is not often seen.
