+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-09-01T14:54:00-04:00"
lastmod = "2015-09-03T08:30:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441215258535/BallotBoxsquare.jpg.jpg"
publishDate = "2015-09-03T07:30:00-04:00"
related_articles = ["articles/just-in-the-crowdsourced-melody-is-complete.md"]
short_description = "What do you get when you ask a crowd what a song should sound like? CrowdSound.net is currently completing a melody, generated one note at a time by people on the Internet. Users can vote for each subsequent note in a melody, choosing from a list of diatonic pitches."
slug = "vote-for-a-note-crowdsourced-songwriting"
title = "Vote for a note: crowdsourced songwriting?"
+++

What do you get when you ask a crowd what a song should sound like?

[CrowdSound.net](http://crowdsound.net/) is currently completing a melody, generated one note at a time by people on the Internet. Users can vote for each subsequent note in a melody, choosing from a list of diatonic pitches. The crowdsourced song has a few parameters: 4/4 time, in C Major, with a fixed range of C to B, diatonically. The chord progression is simple enough: C, G, Am, F, and inspired by [this](https://www.youtube.com/watch?v=5pidokakU4I). 

On the one hand, the song sounds a bit dull. It's repetitive, but then again, so are the notes and chords available to choose from. Says programmer Brendon Ferris, "Sticking to the scale was much safer for a first song and reduces the number of options, so the vote sample size could also be smaller." 

Dull as it may be in its current state, the project shows a tool with a lot of potential for people interested in making music, but who lack some of the theoretical and practical background to write songs. It reminds me a bit of [TouchPianist.com](http://touchpianist.com/) (one of the most addicting websites on the Internet, if you ask me).

What I find truly intriguing about crowdsound.net is not its use as a songwriting tool, but what it can learn from the general public. There's a real possibility of gleaning information about what people *want to hear*; as someone who works in what's often considered a closed, elitist form of music, the chance to gather this kind of information is exciting. A voting system limited to 4/4 time and diatonic Western scales won't give the most accurate results; but upon refinement, it would be really cool to see what people choose out of a list of "dissonant" pitches, or how repetition and symmetry might be affected with varying time signatures and more *avant-garde* chord progressions underneath.

Head over and [have a listen](https://crowdsound.net/) to the tune so far, and [vote](https://crowdsound.net/) for the next note.

>What do you think? Is crowdsourcing a valuable tool for making music? What possibilities could evolve from a project like this one? Let us know in the comments below!
