+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2019-02-05T17:55:01+00:00"
disclaimer = ""
image_gallery = []
postamble = "_(La) Voix humaine_ happens February 16, 8pm, at Toronto's Gallery 345, 345 Sorauren Ave. For details and tickets, [click here](http://againstthegraintheatre.com/la-voix-humaine-3/)."
preamble = "Kicking off [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/)'s new Incubator Initiative is the gender-bent imagination of Poulenc's _La voix humaine_, created and performed by tenor [Jacques Arsenault](/scene/people/jacques-arsenault/). With Music Director Topher Mokrzewski and stage director Aria Umezawa, Arsenault transforms the opera's singular character, Elle, and becomes Lui, the man having a one-sided conversation with an ex-lover. The resulting [_(La) Voix humaine_](http://againstthegraintheatre.com/la-voix-humaine-3/) is a one-night only event on February 16, 8pm, at Gallery 345. \n\nWe spoke with Arsenault about his surprisingly contemporary project:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1549389427/media/2019/02/VoixHumaine.jpg"
primary_image_credit = ""
related_articles = ["articles/racette-an-unmissable-elle-in-o18s-ne-quittez-pas.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md"]
related_people = ["scene/people/jacques-arsenault.md"]
short_description = "\"In the operatic canon, there's a whole lot of male swagger, seduction, anger, and violence but a notable lack of vulnerability. Dramatically, I'm interested in shame and vulnerability, particularly in the lives of men.\""
slug = "challenging-operas-male-swagger-in-la-voix-humaine"
title = "Challenging opera's \"male swagger\" in (La) Voix humaine"
youtube_url = ""

+++
### What inspired you to experiment with Poulenc's _La voix humaine_?

Last year, I saw Groundling Theatre's production of Shakespeare's _Lear,_ in which Seana McKenna played Queen Lear. It blew me away. A simple change, from King to Queen, had a deep effect on our perception of the title character, especially in relation to the others around them and the world they inhabit.

> What happens to Lui in our version of _(La) Voix humaine_ has happened to many others, including, to some extent, Poulenc.

I wondered why opera companies didn't seem to be following suit with more dramatic gender swaps. That's when I had my idea to experiment with one of my favourite operas: _La voix humaine,_ by composer Francis Poulenc. I grabbed a score and the original play by Cocteau and set to research. Once I read more about the lives of Cocteau and Poulenc and how they dealt with their sexuality (Cocteau was quite out, Poulenc was more secretive), I became fascinated with the echoes between their own biographies and the protagonist of _La voix humaine._ People of all genders and orientations have their hearts broken. Pain and loss are universal. I want to explore what it would be like to peel back the curtain and to see a man, like Cocteau and Poulenc themselves, experiencing this story in 1930s Paris.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549389566/media/2019/02/JacquesArsenault.jpg){{% /md %}}

<figcaption>Jacques Arsenault, tenor and creator of (La) Voix humaine.</figcaption>

</figure>

### What changes about this piece and this character when the protagonist's gender is changed?

What changes about the piece has to do with our own perceptions as interpreters and observers. I have changed the character of Elle to Lui, but the ex-lover on the other end of the phone remains a man. I've also changed the character of Marthe into Marc to add a platonic male friendship to Lui's life.

In the original opera, Elle seems to have been the "other woman" in her ex-lover's life. After a five-year relationship, her ex-lover has left her, presumably to get married the following day. Within the world of 1930s Paris, Elle therefore inhabits a taboo space outside of what was deemed acceptable: heterosexual monogamy. When we add this taboo to the social inequality between men and women, a vast power difference between Elle and her ex-lover hangs over the original text. By swapping the gender of the protagonist but leaving that of the ex-lover unchanged, we now encounter both Lui and his ex-lover as gay men in 1930s, Paris. By making both halves of the couple male, the gendered power difference is removed and both are now cast as outsiders to the world around them.

> I think of Against the Grain as a company that defies, or at least questions, the attitude of "this is how things ought to be done."

Cocteau was at the forefront of the avant-garde movement and he idolized artists such as Picasso so it's not surprising that the portrait he gives us of Elle/Lui is rather abstract. In _(La) Voix humaine_, we only hear and see Lui's half of the conversation, which Poulenc illustrates musically. It's up to us to imagine the other half of this conversation, the dynamic of the relationship that's ending, and the character of the ex-lover. From our new perspective, perhaps we imagine that Lui remains the odd-man out in a love triangle. Or perhaps we can now imagine a new context, another backstory, a different explanation for the dissolution of this relationship.

It's been said that _La voix humaine_ frustrates us because Elle is too passive: we feel she should hang up the phone and find a better man. But I wonder whether we react that way to Elle because of the text itself or because of our own socially-conditioned expectations relating to gender: our biases and preconceptions of how a woman ought to behave, on and off stage. How we imagine the ex-lover in the context of their relationship and how we feel about emotional vulnerability in general will affect how we respond to Elle/Lui's personal tragedy. When we remove the gendered power difference between Lui and his ex-lover and feel that they are both "othered" men, do we still respond to Lui as being passive and are we as frustrated by his actions? Or does it now challenge our biases and preconceptions of how a man ought to behave?

> With this new interpretation of _(La) voix humaine_ I'd like to put those difficult, suppressed emotions centre stage and see what happens.

Quite a lot is known about Cocteau's love life so it's not a stretch to imagine that he drew from his own experience and suffering to write _La voix humaine._ In fact, during the play's original run at the Comédie-Française, hecklers were shouting from the boxes: "Enough! It's obscene! It’s Cocteau's lover on the other end of the line!" What happens to Lui in our version of _(La) Voix humaine_ has happened to many others, including, to some extent, Poulenc. While it would be naive to think that gay characters on stage are now totally accepted, we as artists do have liberties and privileges today that would have been unimaginable to this opera's creators. I've taken those initial hecklers at their word by placing a man like Cocteau on stage. Now it remains to be seen whether we as interpreters and observers will still find it obscene.

### What do you think the AtG Incubator found compelling about your ideas with this work?

I think of Against the Grain as a company that defies, or at least questions, the attitude of "this is how things ought to be done." They're a company that will sacrifice authenticity or accuracy to try to unearth something new. Traditions are beautiful and enriching but I think that they can be stifling if they aren't adhered to or engaged with mindfully. I'm excited that through their new Incubator, AtG is allowing me take risks: to crack open this work and to put it back together under a new light.

### What do you hope to say with your performance at Gallery 345?

In the operatic canon, there's a whole lot of male swagger, seduction, anger, and violence but a notable lack of vulnerability. Dramatically, I'm interested in shame and vulnerability, particularly in the lives of men. Opera is filled with moments of doubt, fear, descents into madness, and we're used to witnessing raw grief as a loved one dies in the arms of a male lead before the curtain comes crashing down. But what about our everyday tragedies like heartbreak, a loss of hope, or of one's identity? For many centuries men have been conditioned to hide and ignore a lot of difficult emotions lest we be considered as weak or effeminate. With this new interpretation of _(La) voix humaine_ I'd like to put those difficult, suppressed emotions centre stage and see what happens.