+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-11-26T11:12:00-05:00"
lastmod = "2017-11-26T18:11:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511712139519/2017-11-25---Types.jpg.jpg"
publishDate = "2017-11-26T17:59:00-05:00"
related_articles = ["articles/singers-its-time-to-expand-your-dating-pool.md","articles/the-opera-posse-phenomenon.md"]
short_description = "It&#039;s something to ponder: have the great composers of history inadvertently laid out a predetermined social life for generations of operatic artists? Have they added to the stereotype of rival divas by keeping them isolated to their own operas? Have they given credulity to the inevitable cross-disciplinary romances between soprano and baritone, between répétiteur and tenor?"
slug = "voice-type-social-life"
title = "How your voice type determines your on-the-job social life"
+++

The opera world is one where socializing is done in fits and starts. For a few weeks at a time, a group of artists is thrown together into a hectic routine of rehearsal and post-rehearsal festivities. The tightly-knit network is full of people separated by just one or two degrees; if two artists don't already know each other, they surely have at least a handful of friends in common (and Facebook makes it even weirder). Each bit of contract work – be it a fully staged production, a concert gig, a workshop of sorts – comes with a temporary social circle.

New friendships are forged among colleagues, and with the small-worldliness of opera, a gig can be a happy reunion of old friends, brought together once again by the casting gods ("I haven't seen you since that crazy *Flute* we did!!"). 

There's something fascinating about this phenomenon, when you think about it. Take, for example, a standard, staged operatic production: working on that contract are a cast of singers, a pianist or two, a conductor, a director, stage managers, and a handful of designers. Aside from assistantships, it would be a very rare case indeed to find two conductors or two directors working on a single production. Often there's even just one rehearsal pianist, and if there are more, they work in shifts, never to cross paths until *Sitzprobe*.

Among the singers, there's a subset of that predetermination at play. There are exceptions to every rule, of course, but you could argue that a singer's voice type plays a role in which singers they get to see around the gig circuit. For example: a leading soprano (dramatic or lyric, say), is often in a class of her own in any given opera. Operas like *Tosca*, *Aida*, *Un ballo in maschera*, or *Madama Butterfly* are written in
a way that features their leading ladies. In those shows, there's no other voice like Tosca, Aida, Amelia, or Cio-Cio San.

A strange yet inevitable by-product of such a soprano's career: they likely don't get to hang out with other similar sopranos at work, since they’re never in the same show together. Understudies excepted, where will you find two Isoldes? Two Manons? 

The same can be said for other one-of-a-kinders, like Heldentenors, bassi profundi, the Don José-sorts, lyric mezzo-sopranos (there is only *one* Carmen, of course), and maybe a Verdi baritone or two. There's usually only one Amneris-type around, and even character tenors tend to travel in a class of their own.

For the same reason, many conductors, coaches, and directors can feel as though they're like ships in the night with their colleagues. They likely hear of their friends' work - their fellow conductors/coaches/directors - yet the odds are slim that they'd find themselves working in close quarters with these colleagues. (Personal note: I've still never seen most of my vocal-coach friends give a coaching...)

There are, of course, shows that can feel like a giant reunion of friends and co-workers. Operas like *Don Giovanni* or *Billy Budd*, where the many male roles are often interchangeable among the men who sing them, can feel like an extended boys night out. There are the Handel operas to bring together long-lost mezzo-sopranos in their varied trouser roles, and shows like *Suor Angelica*, *Dialogues des Carmélites*, and *Die Walküre* are a rare bit of sisterhood among sopranos. For tenors? There's always *Salome*...

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/OMADKhLL7uA" frameborder="0" gesture="media" allowfullscreen></iframe>
</figure>

It's something to ponder: have the great composers of history inadvertently laid out a predetermined social life for generations of operatic artists? Have they added to the stereotype of "rival divas" by keeping them uniquely isolated in their respective operas? Have they given credulity to the inevitable cross-disciplinary romances between soprano and baritone, between répétiteur and tenor?

Or am I reading too much into the whole thing entirely?
