+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2018-02-18T09:59:00-05:00"
lastmod = "2018-02-19T21:09:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519092318147/sq---LUQ_7392.jpg.jpg"
primary_image_credit = "(left to right) Suzanna Guzmán (Lupita), Juan Mendoza (Chucho) in Cruzar la Cara de la Luna, 2018."
publishDate = "2018-02-19T21:09:00-05:00"
related_articles = ["articles/vos-merry-widow-a-comedic-tourdeforce.md"]
short_description = "Director Guerrero, using only a small acting space and nothing more than a door, a chair and bed as set pieces, utilized beautiful and, in some cases, symbolic rear projections to underpin the production, which is as much about the heart-breaking issue of immigration as it is about the heart-felt music."
slug = "viva-la-operetta"
title = "&quot;Viva la operetta!&quot;"
+++

For someone who knows virtually nothing about mariachi (like this reviewer), the production of *Cruzar La Cara De La Luna* was an eye-opening experience. It was a chance to not only hear, for the first time, the most famous mariachi band in the world ([Mariachi Vargas De Tecalitlan](https://www.youtube.com/watch?v=8NWSWg7c0Ec)), but a chance to see that mariachi, as a genre, can sustain a lovely and poignant book musical. Commissioned by and premiered at Houston Grand Opera in 2010, this is the Los Angeles premiere of the work (for one weekend only at the Younes and Soraya Nazarian Center for the Performing Arts, formerly the Valley Performing Arts Center on the campus of CSUN.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519092378932/LUQ_7981.jpg.jpg)
<figcaption>(left to right) Jonathan Arana (Rafael), Natalia Ferreiro (Diana).</figcaption>
</figure>

Mariachi has rural roots that are two hundred years old, but mariachi as we know it today is primarily a twentieth-century urban reinvention. Mariachi Vargas itself dates back to the 1890s, and they follow the traditions of most other mariachi bands today in that they have approximately the same types and numbers of instruments - seven violins, three trumpets, a harp and two guitars. Underneath it all, providing rhythm, is the booming bass of the instantly recognizable guitarron. Some of the musicians even switch instruments at times, and almost everyone sings. The vocal solos are shared, backed up by powerful harmonies. The voices have to be powerful and passionate to be heard over the band, and every number is a breathtaking celebration of the male voice. As a curtain raiser, we were treated to a mini-concert of approximately four songs from Mariachi Vargas.

The group then formed a semi-circle around a playing area, and there, under the direction of Dan Guerrero and under the baton of Jose "Pepe" Martinez, Jr., *Cruzar La Cara De La Luna* (*crossing the face of the moon*) was presented in Spanish with English supertitles. (When the characters spoke some of the dialogue in English, the supertitles were in Spanish.) Mr. Martinez's late father (of the same name) was the leader of Mariachi Vargas until his death in 2016 and wrote the music and the lyrics for the piece. Leonard Foglia wrote the book and shares credit on the lyrics.

Director Guerrero, using only a small acting space and nothing more than a door, a chair and bed as set pieces, utilized beautiful and, in some cases, symbolic rear projections to underpin the production, which is as much about the heart-breaking issue of immigration as it is about the heart-felt music.

Laurentino is dying in his home in Texas, and in his delirium he remembers the life he left behind. Though he created a new life for himself and his family many years ago in the United States, he thinks longingly of the other family he once had in Mexico. Though his American son Mark is dutifully there by his bedside, Laurentino mourns the loss of his other son, Rafa, who may or not be alive south of the border.

Through a series of flashbacks we learn that Laurentino, like many other laborers, had to leave his village for long periods of time to find work "up north" in the fields of the U.S. His wife, Renata (Alba Franco-Cancel) sings about the fact that the village has lost all of its men to immigration and she mourns the fact that, "We are widows and we can't even bury our dead." In fact, Laurentino has been gone almost an entire year when Renata, with their son Rafa in tow, decides to take the perilous journey of illegal immigration to join her husband. Pregnant, the trip proves to be too much for her and she dies in the desert. Rafa is returned to Mexico and he disappears.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519092388443/LUQ_7787.jpg.jpg)
<figcaption>(left to right) Daniel Rodríguez (Laurentino), Jonathan Arana (Rafael).</figcaption>
</figure>

Flash forward again to the present and Mark's daughter, Diana (Natalia Ferreiro), makes it her mission to find Rafa and reunite him with his dying father and thereby hangs the plot, told in past and present tense.
Gregorio Gonzalez (as Mark) sets the stage and the story. He sings the first song of the evening with his striking voice, accompanying himself solo on a simple guitar. "On Fragile Wings", about the migration of the monarch butterfly (from Mexico to Northern California and back again), is an important metaphor that carries through the whole evening. As a boy, Laurentino (played by Daniel Rodriguez, whose singing and acting proves to be the dramatic anchor of the evening) watched the monarchs come to his village every year and dreamed of flying away with them free to the north. Though the monarchs return to Mexico every year, Laurentino, like many immigrants, finds himself stuck in the north and unable to come back. (Director Guerrero effectively uses computer-generated butterfly images throughout the operetta.) As the lyrics go, "only monarchs can cross the face of the moon" and thus the inspiration for the title of the show.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519092401109/LUQ_7675.jpg.jpg)
<figcaption>(left to right) Daniel Mora (Victor), Jesus Martinez (Young Rafael), Alba Franco-Cancél (Renata).</figcaption>
</figure>

Only later do we learn that the monarchs who return to Mexico are, in fact, the fifth generation descendants of the original monarchs who left, and this elicits an emotional response as we think of the parallel to their human counterparts.

There is tremendous optimism when Laurentino is young. In "50 Years from Now" he sings with his young bride Renata and best friend Chuco (joyous Juan Mendoz) about his dreams for the future, which are reiterated and expanded in the rousing "10 Times More."

His wife's best friend, Lupita, is played by Suzanna Guzman, long-time Los Angeles opera artist (on stage, tv and radio), who has appeared in over forty LA Opera productions and who has performed over two hundred times as Carmen. Suzanna is that rare opera performer who might even be a better actress than she is a singer, even though her singing is perfection. In "Song of Lupita", after the death of her friend Renata, she evokes tremendous emotion from the audience as she implores her long-absent and recently-returned husband to say her name - it's been too long since she heard him say it.

As mentioned, the evening is focused on the mariachi tradition of the male voice and so there are two riveting duets between some of the men. Mark and Rafa (tremendous tenor Jonathan Arana) are brothers, but struggle with the concept of calling one another on the phone ("Numbers") because they've never met. Later on during the reunion of Laurentino and Rafa, we're treated to the combination of beauty and loss in the song "Your Mother's Eyes" as they sing of Renata, their long-dead wife and mother respectively.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519092411915/LUQ_7398.jpg.jpg)
<figcaption>(left to right) Suzanna Guzmán (Lupita), Alba Franco-Cancél (Renata), Daniel Rodríguez (Laurentino), Juan Mendoza (Chucho.</figcaption>
</figure>

In the end, the song "My Home" sums up the other great theme of the evening - the importance of family and the vital importance of family reunion. It was especially moving since the program's announcer told us that there were "dreamers" in the audience from the CSUN DACA student organization.

And if the point wasn't made, we also learned that the Valley Performing Arts Organization was renamed the Nazarian Center for the Performing Arts thanks to a seventeen million dollar grant from the Nazarian family - a family of immigrants.

Performances conclude February 17 at 8:00, and February 18 at 3:00.
