+++
author = ["authors/molly-simoneau.md"]
categories = "Review"
date = "2019-10-13T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "[Virginia Opera's _Tosca_](https://vaopera.org/experience/tosca/) has two more performances in Richmond, VA, October 18-20."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1571103360/media/2019/10/sqVAOperaTOSCA-3671_dektxt.jpg"
primary_image_credit = "Matthew Vickers (Mario Cavaradossi) and Ewa Płonka (Floria Tosca) in Tosca, Virginia Opera, 2019. Photo: Ben Schill Photography."
related_articles = ["articles/talking-with-singers-melody-moore.md", "articles/in-review-tosca-at-eno.md"]
related_companies = ["scene/companies/virginia-opera.md"]
related_people = []
short_description = "In general, tempos throughout the performance were sluggish, particularly in the first act. The love duet plodded along and the Te Deum was agonizingly slow, as was Mario's third act aria \"e lucevan le stelle.\""
slug = "a-tosca-found-wanting-in-virginia-operas-production"
title = "A Tosca found wanting in Virginia Opera's production"
youtube_url = ""

+++
It's not often as a critic that you get to see two different opera companies' productions of the same work in such close succession, such that it invites a direct comparison, but that's what happened when Virginia Opera kicked off their season with [_Tosca_](https://vaopera.org/experience/tosca/), just a few months after Washington National Opera concluded their season with the same.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571103372/media/2019/10/VAOperaTOSCA-2855_ftfeio.jpg){{% /md %}}

<figcaption>Matthew Vickers (Mario Cavaradossi) and Ewa Płonka (Floria Tosca) in Tosca, Virginia Opera, 2019. Photo: Ben Schill Photography.</figcaption>

</figure>

And it's unfortunate too, because I wonder if I would have enjoyed the Virginia Opera performance of my favorite opera more had I not had such an [exquisite example of the piece](/alkema-a-world-class-tosca-at-wno/) so fresh in my memory. As it is, Virginia Opera's outing of Puccini's "shabby little shocker," came off as mostly just shabby. But it speaks to the quality of Puccini's masterful writing that such an unimpressive performance of _Tosca_ still makes for a fairly entertaining evening.

> An all-out brawl broke out on stage in a moment of over-the-top camp.

In her staging, Lillian Groag attempted to create a Zeffirellian feel of excitement and bustle, but the result was often clumsy and overly busy. There were children darting back and forth, and city folk taking a moment to stop into the chapel where Mario Cavaradossi was working to admire the art, or later in Act II following Mario's exclamation of "Vittoria! Vittoria!" when he managed to briefly escape and an all-out brawl broke out on stage in a moment of over-the-top camp.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571103439/media/2019/10/VAOperaTOSCA-3101_zycwbp.jpg){{% /md %}}

<figcaption>Kyle Albertson (Scarpia, left) in Tosca, Virginia Opera, 2019. Photo: Ben Schill Photography.</figcaption>

</figure>

_Tosca_ is an actor's opera. The music must be performed with skill and artistry, but without singing actors who can carry off the intensity of the drama, the opera falls flat or devolves into silliness, which this production often did. Matthew Vickers' performance as Mario was that of an acting student, where the audience can see all-too clearly every thought he's having about motivations and objectives. In the first act, his attempt to play a Mario distracted by thoughts of worry for his fugitive friend, read instead as cold and disconnected during the sweeping love duet.

And his singing wasn't much better - his dark, baritonal voice, heavy and pressed, never really managed to take flight. The lovers utterly lacked any chemistry, and their tryst felt like a  frivolous flirtation, making it hard to root for their doomed romance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571103478/media/2019/10/VAOperaTOSCA-3266_j2nywk.jpg){{% /md %}}

<figcaption>Ewa Płonka (Floria Tosca) and Kyle Albertson (Scarpia) in Tosca, Virginia Opera, 2019. Photo: Ben Schill Photography.</figcaption>

</figure>

In the title role, Ewa Płonka brought a truly remarkable voice. Steely and impossibly huge, I found myself whispering "Wow!" to myself over and over again whenever her voice hit its sweet spot in her upper register. The voice is so enormous that it becomes clumsy at times but is still gloriously thrilling to hear, with an ground-shaking top C.

> The lovers utterly lacked any chemistry, and their tryst felt like a  frivolous flirtation, making it hard to root for their doomed romance.

Her Tosca, however, lacked sincerity. She performed all the beats you expect from a Tosca: the flirting, the jealousy, the forgiveness, the prayer, the murder, the suicide, without ever sinking into ay of them in a satisfying way. When the time came in the intense second act, she launched so hurriedly into her "Vissi d'arte" that it crushed the magic of those first four notes which should emerge from nothing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571103488/media/2019/10/VAOperaTOSCA-3595_sjcihh.jpg){{% /md %}}

<figcaption>Matthew Vickers (Mario Cavaradossi) and Ewa Płonka (Floria Tosca) in Tosca, Virginia Opera, 2019. Photo: Ben Schill Photography.</figcaption>

</figure>

But the aria was beautifully sung and had an appropriate intensity, which risked being deflated by Groag's staging of Scarpia who continued to work at his desk, writing, blotting, and sealing papers.

> The love duet plodded along and the _Te Deum_ was agonizingly slow, as was Mario's third act aria "e lucevan le stelle."

Kyle Albertson played a one-dimensional Scarpia, with all the menace of [Snidely Whiplash](https://en.wikipedia.org/wiki/Snidely_Whiplash) or some equally silly cartoon villain. His voice is small for a Scarpia, and he seemed to struggle for the lowest notes during the first act, but the voice came into its own, sounding more lyrical in the second. Scarpia's "Va, Tosca" and _Te Deum_, serving as the finale of the first act, should be a show-stopping spectacle, but Albertson was occasionally covered by the orchestra (led by Virginia Opera artistic director Adam Turner) and the chorus's first few lines, sung from offstage, were all but inaudible in, by far, the slowest rendition of this aria I've ever heard.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571103500/media/2019/10/VAOperaTOSCA-3705_q1maec.jpg){{% /md %}}

<figcaption>Ewa Płonka (Floria Tosca) in Tosca, Virginia Opera, 2019. Photo: Ben Schill Photography.</figcaption>

</figure>

In general, tempos throughout the performance were sluggish, particularly in the first act. The love duet plodded along and the _Te Deum_ was agonizingly slow, as was Mario's third-act aria, "E lucevan le stelle."

Virginia Opera is doing the important work of bringing Grand Opera to the stage in smaller cities outside of Washington, D.C., and judging by the size of the audience at Saturday's performance, that work is highly valued. And I think that's what frustrated me about this performance: it wouldn't have taken much to turn this from a mediocre _Tosca_ into a pretty good one; like a meal with no salt, it only takes a little sprinkle to turn something flavorless into something delicious.