+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2021-05-20T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1621563154/media/2021/05/GirlintheSnow-collage_e0qtqy.jpg"
primary_image_credit = "Clockwise from top left: composer Scott Ordway (photo: Amanda Greene); mezzo-soprano Julia Dawson (photo: Cacao Produccines), and pianist Anna Naretto (photo: Evelyn Fay)."
related_articles = []
related_companies = []
related_people = ["scene/people/julia-dawson.md"]
short_description = "Dawson is committed to video. \"These videos were a way that we could come together as a community and make musical offerings to people in the midst of the pandemic. By embracing the constraints of 2020 and leaning into the medium of video, I've seen the richness of expressive possibility that is available.\""
slug = "video-premiere-the-mystery-of-the-world-according-to-julia-dawson"
title = "Video premiere: \"The Mystery of the World\" according to Julia Dawson"
youtube_url = ""

+++
[Julia Dawson](/scene/people/julia-dawson/) speaks with enthusiasm and commitment when the subject of [_Girl In The Snow_](/girl-in-the-snow-a-mysterious-song-cycle/) comes up. The mezzo-soprano talks with equal zeal about the evolution of the video following the work's 2018 premiere in Frankfurt and the potential role of video in building audiences for opera. She also offered a few insights into the song-cycle's mysteries.

Scott Ordway and Dawson were friends from her student days in Philadelphia at the Academy of Vocal Arts. Inviting her to premiere _Girl In The Snow_, he must have known how perfect her voice would be for the work. Dawson jumped at the chance, contacted pianist Anna Naretto, whom she terms "a great collaborative artist", and the work premiered on a chamber series in Frankfurt in 2018. Ordway attended, and that is when the group connected with Alex Brusencev, the audio engineer recording the concert, who would later produce the album for Acis.

As they were preparing for the release this past summer Brusencev, who happens to come from the world of heavy metal music, suggested they make a video for the recording. Once again Dawson jumped at the chance and they immediately began to plan. "We chose 'The Mystery of the World' says Dawson, "in which the speaker seeks the transformative power of the woods and longs to commune with nature as only children can. The song is imbued with the desire to return to a simpler time and felt reflective of 2020."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1621560552/media/2021/05/Julia_Dawson_-_Girl_In_The_Snow_Master_.00_02_01_14.Still001_taayr5.jpg){{% /md %}}

<figcaption>Julia Dawson in "The Mystery of the World" video from Scott Ordway’s Girl In The Snow. Photo: Mario Drescher.</figcaption>

</figure>

With the help of Frankfurt-based photographer Mario Drescher, who shot the video and, according to Dawson "brought a striking visual poetry," the project took shape. "In the video," Dawson continues, "a woman is isolated and alone. She escapes into her imagination, exploring the wonders of nature and searches for release. What she finds instead is a baptism into her present."

In preparing the entire cycle with Ordway and Naretto, Dawson chose to develop the character of a woman at the end of her life. "I saw the Ordway/Ordway songs as her memories of childhood; joyful, yet tinged with escapism and nostalgia. The Ordway/St. Augustine songs I perceived as moments of clear awareness as she accepts her mortality."

> "It's time we caught up with the rest of the music industry and connected with video artists to create kick-ass musical art videos!"

Back in March 2020, Dawson was stranded in lockdown in rural France. She felt isolated and uncertain when her father, who plays bass with the Toronto Symphony Orchestra, sent her a [video of Copland's _Appalachian Spring_](https://youtu.be/5rzZ2F18MwI) that his TSO colleagues had created. "I immediately thought, we have got to do this for opera." Dawson then reached out to Brusencev and Guillaume Faraut, a violinist with the Oper Frankfurt Orchestra who organized the players." Dawson found the singers and Brusencev edited the video and sound. Thus _Quarantunes_ and [_Gone In 60 Seconds_](https://www.youtube.com/watch?v=bScyUr43yws) were born.

Dawson is committed to video. "These videos were a way that we could come together as a community and make musical offerings to people in the midst of the pandemic. By embracing the constraints of 2020 and leaning into the medium of video, I've seen the richness of expressive possibility that is available.  Musical videos are definitely an interesting medium in themselves and can also be a tool to invite people into the concert hall who maybe wouldn't have considered it before. It's time we caught up with the rest of the music industry and connected with video artists to create kick-ass musical art videos!"

But for now, here is the premiere of the video of the Scott Ordway/St. Augustine song, "The Mystery of the World":

<figure data-type="video">{{% md %}}<iframe width="1280" height="720" src="https://www.youtube.com/embed/LT7zAkn_g2g" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>