+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2016-03-15T10:28:00+00:00"
lastmod = "2016-08-14T12:20:00+01:00"
preamble = "Often, people are curious about all the vibrato they hear from opera singers. Compared to the way most pop singers use their voices, vibrato can seem like an effect, superimposed by the singer in an active way, to achieve that \"opera singer sound\". In reality, vibrato is the result of the ultra-efficient, healthy sound that opera singer work to achieve. Vibrato is a great litmus test, one that reveals what's happening in the mysterious and subtle vocal mechanism. Opera isn't all about singing with a constantly vibrating tone, but when a singer maintains the potential to vibrate any note, it means that they're singing with breath support and a relaxed body.\n\nThere are a few instances where singers can really use this vibrato-as-litmus-test phenomenon. The examples are likely endless, but we've narrowed down a few sections from beloved arias, where attention to vibrato can keep the singing easy, and the singer honest."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471173385915/2016-08-14---Vibrato.jpg.jpg"
publishDate = "2016-03-15T11:58:00+00:00"
related_articles = ["articles/4-tips-for-when-there-are-too-many-notes.md","articles/4-secrets-for-better-high-notes.md","articles/4-ways-that-opera-really-is-life.md","articles/a-singers-todo-list-4-tasks-to-keep-you-focused-this-year.md","articles/rhoda-and-the-fossil-hunt-where-opera-meets-science.md","articles/keeping-the-thread-momenttomoment-awareness-in-singing.md"]
short_description = "There are a few instances where singers can really use this vibrato-as-litmus-test phenomenon. The examples are likely endless, but we&#039;ve narrowed down a few sections from beloved arias, where attention to vibrato can keep the singing easy, and the singer honest."
slug = "vibrato-all-the-reasons-why"
title = "Vibrato: all the reasons why"
+++

## Don José's aria

This tricky start to José's famous aria is made trickier by the text setting. The first note, often in the *passaggio*-like cracks for a tenor, is also sung on the word "the"; this means that the tenor has to tread lightly on an already perilous starting pitch. Often it's easy to put all of one's attention into this first note, and then finish the sentence as though it's a sigh of relief. For the text, and for the energy of the whole phrase, paying attention to vibrato on the word "fleur" is key. The sound will be more lovely, the French will do what it should, and the tenor will stay engaged beyond the difficult moment; forest for the trees, really.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458037506654/Vibrato---Jose-2.jpg.jpg)
</figure>

Similar moments are in all of these falling phrases later in the aria (shown below). Coming down from the A-flat on "te revoir" is about more than nailing the high note; listeners respond to the full outburst of this phrase, and the best words are not on the high A-flat. The tension is really in the G-flat that immediately follows. Plus, tenors, you've got to do this again in the next line. The bottom system of this excerpt shows a sequential pattern of descending phrases; each time, it's the first note *down* from the highest peak that matters. The words aren't necessarily the most imporant, but vibrating beyond the high notes will let you do what you want with those diminuendos, and it will keep the "tu n'avais eu qu'à paraìtre" from feeling pinched or unsupported.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458037888280/Vibrato---Jose-3.jpg.jpg)
</figure>

## Stephano's aria

For mezzos, the excerpt below is one reason that this aria from *Roméo et Juliette* is so tricky. This harmless-looking high A on the end of "tourterelle" is a note to be thrown away, like a mocking laugh from Stephano. The grace note can act as a springboard up to the A; mezzos either like to connect these like a quick portamento, or they often separate them completely, like two staccato notes. In order to "find" the ease and playfulness in the short note, try it out as a long note instead. While you're practicing, take the time to find a great vowel, and find a place for the high note in your voice where, if you were to hold it indefinitely, it's free to vibrate. You can work backwards from this point, shortening the note to one or two vibrations instead of a sustained pitch.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458038305614/Vibrato---Stephano-1.jpg.jpg)
</figure>

The circled notes below need to vibrate for different reasons. There's a surprising change of key starting at "Cependant", and that D-flat on "-pen-" is the crux of this change. In the practice room, try adding a fermata on that D-flat, to allow yourself time to find the centre of the pitch. The distance between the C and D-flat is a semitone, of course, but it's one of those semitones that feels smaller than others. The same goes for the responding phrase, under "Nos amants".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458038683739/Vibrato---Stephano-2.jpg.jpg)
</figure>

Now, here's the line that freaks out many mezzos, and for good reason. The first circled note below, on "Gardez bien la belle", is about attention to detail. The D-natural often falls a bit flat in pitch, and loses vibration; most mezzos are coasting here, getting relaxed for the coloratura coming up. Vibrato on "la" will help keep the voice spinning, and the placement high.

The circled note on "tourterelle", right before the scales up and down, serve the voice in the same way stretching serves a runner. It's understandable that the singer's attention is on the moving notes; yet without a supported, easy, malleable starting note on "-rel-", it's hard to get moving at all. Pay attention to the vowel you choose for this C-natural, and use the vibrato to avoid "falling" down from the D-natural just before it. This phrase is all about being *up*, so give yourself a fair chance with an energized start.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458038859312/Vibrato---Stephano-3.jpg.jpg)
</figure>

## Lucia's aria

This excerpt is from Lucia di Lammermoor's first aria, "Regnava nel silenzio". The first two phrases have that tragic, minor sixth leap up from A to F-natural; in both cases, it's a common trap to neglect the first E-natural that follows (circled). It has to do with the text ("la" isn't important *per se*), and the 6/8 meter (weak beats like this first E-natural can get lost in the meter's natural lilt). Imagine these two repeated E's as one longer note, rather than two short. Pay attention to what your vibrato is doing on the word "la"; it will help you sing through the consonants in "fronte", and stay beautifully in tune. This descending semitone is another tiny one.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458039546584/Vibrato---Lucia-1.jpg.jpg)
</figure>

This next excerpt below is a complicated little decoration that Donizetti writes, and it's common performance practice to stretch this first bar a little bit so the singer (and listeners) can enjoy it. The huge interval from the low F up to the high A takes some care, but so does the innocent-looking G-natural that follows. It's actually the note with the most tension in it, because it's a dissonant appoggiatura. The free vibrato you achieve on the high A should continue through to the end of "esanime"; that G-natural at the end of "mano" is a litmus test for this. In the practice room, try pausing on the G-natural, and see where it lays in your voice. There should be room for it to vibrate, if you're singing a true legato line downwards.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458039560303/Vibrato---Lucia-2.jpg.jpg)
</figure>

## Renato's aria

Renato's "Eri tu che macchiavi" from *Un ballo in maschera* is a lesson in baritone *bel canto*. In this first excerpt, the circled B-flat on "perdute" is a tiny passing note, but it's vital for this phrase to make sense. The chromatic descent from the C-natural can sound like bad intonation without taking care on each note, and the short notes like the B-flat on "per-" are more important than the long.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458039851494/Vibrato---Renato-3.jpg.jpg)
</figure>

This small cadenza is a complicated bar, and like the Gounod exceprt above, it's easy to focus on individual difficulties. Once you're happy with the high F on "o", carry that spin, height, and vibrato down to the D on "spe-". Sections like this are like a ladder, and dismissing quick passing notes can be like removing rungs from said ladder. Maintaining vibrato (even potential vibrato) on the circled D will keep you in shape for the rest of the measure, specifically the second D with the fermata. Instead of falling out of your extreme register, you'll make a calculated descent with the option of ascending again.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458040260162/Vibrato---Renato-2.jpg.jpg)
</figure>

Finally, here's an exaggerated version of the same concept. The high G is a big deal, no doubt about it. To use another analogy, phrases like this one are like a tall tower; it's impressive on its own, but the tower needs support on all sides. Spend time figuring out how you'll sing the whole word "brillava"; the E-natural should be free and flexible, getting your voice moving for the leap up to the G. The subsequent F-natural should have room to vibrate, too; if it's difficult, try adding a portamento (at least in the practice room) and see if there's a moment where the voice closes down. Again, the high G is the point of this whole moment; it can be easier to sing with some help before and after it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458040630831/Vibrato---Renato-1.jpg.jpg)
</figure>

>Singers, we want your input! What does vibrato do for you, and when does it matter most? Let us know in the comments below.
