+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-01-18T13:06:00-05:00"
lastmod = "2016-01-20T09:54:00-05:00"
preamble = "Veronika Roux is a photographer and opera enthusiast, and she's currently combining her passions in the form of her [exhibit](http://www.operafacesandwords.com/index) at the Four Seasons Centre for the Performing Arts, home to the Canadian Opera Company. The photography project is called [*Opera Faces & Words*](http://www.operafacesandwords.com/index), and Roux pairs portraits of opera singers with the texts of arias that are particularly important to each artist. The work is ongoing, and Roux plans to re-capture the singers in 5 years time, \"presenting not only their growth as humans but showing their growth within the art form as singers and as bodies of knowledge of the operatic content.\"\n\nRoux spoke with us about *Opera Faces & Words*, at the Four Seasons Centre until February 27th, and the task of capturing a moving art form in still images."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453155121856/ROUX---201601---January-exibit---5---resized.jpg.jpg"
publishDate = "2016-01-20T09:40:00-05:00"
related_articles = ["articles/photographing-the-opera-singer.md"]
related_companies = ["scene/companies/canadian-opera-company-ensemble-studio.md","scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/jacqueline-woodley.md","scene/people/gregory-dahl.md"]
short_description = "Veronika Roux is a photographer and opera enthusiast, and she&#039;s currently combining her passions in the form of her exhibit at the Four Seasons Centre for the Performing Arts, home to the Canadian Opera Company. The photography project is called Opera Faces &amp; Words, and Roux pairs portraits of opera singers with the texts of arias that are particularly important to each artist. "
slug = "veronika-roux-opera-in-photographs"
title = "Veronika Roux: opera in photographs"
+++

## Why is opera a passion of yours?

It is hard to describe why it is a passion – I believe it needs to be experienced to be understood. Opera and classical music have an ability to truly capture and bring us within their realm while touching our own inner realm. Opera truly reflects the essence of human emotions. It is fascinating to know that stories, which were written as long as 400 years ago, are still relevant today and are presented not only through character interaction, scenery and librettos but heightened by beautiful music bringing it to a whole new level. 

It is truly fascinating that we can watch the same opera and hear the same aria over and over again and continually discover something new within the piece and/or the performance.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453155374870/2016-01-19---Roux5.jpg.jpg)
<figcaption>Katherine Giaquinto, soprano, paired with "Zeffiretti lusinghieri", from *Idomeneo*. Photo by Veronika Roux.</figcaption>
</figure>

## Can you tell us about why you were inspired to create this project?

The project was inspired by three things – re-introduce a classical photography style, create stillness within the moving art form of opera and to capture an aspect of the world of opera through another art form with the purpose of growing the reach of opera through photography.

By merging the stillness of photography and words I wanted to present the singers in a classic style of photography – albeit captured digitally. The images are not retouched and only enhanced with lighting; the singers natural essence creates the impact of the portraits. 

One of the main influences was a book titled *Miroirs autoportraits* published in 1973 in Paris. It is a collaborative work between photographer Edouard Boubat and writer Michel Tournier. The publication presents portraits of French authors with a descriptive text written by the authors themselves about their impressions when seeing their portraits. The parallel with the words enhanced the portraits. The more you read, the more you were drawn into the essence of the sitter heightening the impact of the portrait. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453155389340/2016-01-19---Roux3.jpg.jpg)
<figcaption>Adam Fisher, tenor, paired with Mahler's "Ich bin der Welt abhanden gekommen", from *Rückert Lieder*. Photo by Veronika Roux.</figcaption>
</figure>

It all started during a performance of COC's *Così fan tutte*. In the last aria: "Happy is the man who looks at everything on the right side and through trials and tribulations makes reason his guide." It made me stop and think about how beautiful and inspiring librettos can be. This started a flow of questions – how does it feel to sing those words? To learn them? To perform them?  Which ones become favorites, resonate the most, or are hard to assimilate? In the end: can the performer and the true self of a singer be present during a performance?

With all these pieces in mind, the puzzle was complete, and the purpose for the project was finalized in spring 2015. Since then, I have been working with singers and growing the project. It is just the beginning and so far, it has simply been a fascinating learning experience.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453155345103/2016-01-19---Roux1.jpg.jpg)
<figcaption>Veronika Roux's *Opera Faces & Words*, on exhibit at the Four Seasons Centre until February 27th.</figcaption>
</figure>

##  What is it about opera and opera singers that you capture in these photos?

I capture stillness and essence. It is very powerful to present the portrait of a person and attach words which have meaning for them. It gives an opportunity to the viewer to fully study the words and the various facets of a singer who favors these words.

Through photography I capture the singers essence both as individuals and as performers. Images are captured in-studio in a very intimate setting. My purpose is to capture their inner and outer beauty and presenting it to the world – I capture who they are at that point and 

The selection of two portraits per singer was carefully planned and not an easy selection to make. People are multifaceted, it is fascinating to see how one small change in the eyes, with no physical movement, can alter the integrality of a portrait. The portraits were carefully selected to display one facet of the singers as performers and a second as themselves.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453155405837/2016-01-19---Roux4.jpg.jpg)
<figcaption>Gregory Dahl, baritone, paired with "Il balen del suo sorriso", from *Il trovatore*. Photo by Veronika Roux.</figcaption>
</figure>

## What do you anticipate will come of recapturing these singers in 5 years?

For me, people and their continuous evolution is a fascination. There are significant changes that happen in a person, even within a 1-year-time frame  – both physically and psychologically. I have seen the impact through another photography project I am working on, titled "Power in Change", where I capture individuals on a yearly basis. Other than the visible changes in clothing style, hair and make-up, there are new mannerisms, new facial expressions, new body postures can be found.  

Sometimes, the appearance of those changes is very subtle, but if we are very attentive to them. they can be captured. It gives us a point in time – offering a reference of the sitter at that specific moment.

A singer's career is a continuous evolution process – taking on new roles, gaining traction and visibility within the art form, continually growing their repertoire. In 10 or 20 years, it will offer a beautiful evolution of them as individuals and as performers – creating a visual biography.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453155428518/2016-01-19---Roux2.jpg.jpg)
<figcaption>Jacqueline Woodley, soprano, paired with "Deh vieni, non tardar" from *Le nozze di Figaro*. Photo by Veronika Roux.</figcaption>
</figure>

