+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2018-05-16T10:49:00-04:00"
lastmod = "2018-05-16T10:49:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526481567401/sqrig_0284p.jpg.jpg"
primary_image_credit = "Juan Jesus Rodriguez (Rigoletto) in LA Opera's 2018 production of Rigoletto. Photo: Ken Howard/LA Opera."
publishDate = "2018-05-16T10:49:00-04:00"
related_articles = ["articles/searching-for-superlatives-locs-suberb-rigoletto.md","articles/talking-with-singers-michael-fabiano.md"]
related_companies = ["scene/companies/los-angeles-opera.md"]
related_people = ["scene/people/lisette-oropesa.md","scene/people/morris-robinson.md","scene/people/ginger-costajackson.md","scene/people/arturo-chaconcruz.md"]
short_description = "To protect his daughter from the Duke (and his entourage of like-minded cruel courtiers), Rigoletto hides her from the real world. She isn&#039;t allowed to venture outside, except to go to church. And that&#039;s where the Duke spies her and decides he must have her. There is an abundance of well-placed irony throughout the drama."
slug = "verdis-tragedy-in-jest"
title = "Verdi&#039;s tragedy in jest"
+++

Sometimes when a singer makes his or her opera company debut, the results are earth-shaking. No pun intended, but LA Opera has had a few of those quakes. (Maria Ewing in *Salome*, is just one example.) Well, another "star is born" as Juan Jesus Rodriguez made his first appearance in the City of Angels in the title role of [*Rigoletto*,](https://www.laopera.org/season/1718-Season/rigoletto/) as the cursed court jester. Mr. Rodriguez is so brilliant in the role, in fact, that his performance overwhelms the rest of the production - which is good - but isn't quite as great as he is.
 
Mr. Rodriguez is the real story here. The stage effect of thunder is important to the final act of the opera, but the voice of Mr. Rodriguez is thunder itself for all three acts. In both singing and acting, he masterfully plays all the agonizing transitions of the character: from snarky to angry to pathetic and, ultimately, to tragic. In fact, he has to portray almost all of these emotions in the course of one aria, "Cortigiani, vil razza dannata!" It takes a world-class performer to do that.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526481932052/rig_0055p.jpg.jpg)
<figcaption>Arturo Chacon-Cruz (The Duke of Mantua) and Liv Redpath (Countess Ceprano) in LA Opera's 2018 production of *Rigoletto*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>
 
Mr. Rodriguez elevates every moment where he is present. [Lisette Oropesa](/scene/people/lisette-oropesa/) (as Rigoletto's daughter Gilda), was stunning as Eurydice in John Neumier's *Orpheus & Eurydice* this last March. Here she gets a thumbs-up for the impossibly difficult bel canto "Caro, nome," but her greatest moments are in the several duets she shares with Mr. Rodriguez. Together, they give us some of the most splendid moments of the evening.
 
The score by Giuseppe Verdi made him famous and ushered in a period where he was at the height of his prolific powers (*Il Trovatore* and *La Traviata* would soon follow.) There is burst of creativity in this so-called "middle period" where Verdi breaks away from Italian opera conventions and becomes a true dramatist. (As mentioned, he does pause to insert a bel canto aria, a nod to the past, but it reflects Gilda's ecstasy in the story as much as it reflects her vocal prowess.) Verdi's powers would continue to grow, leading to *Aida*, *Otello* and *Falstaff*, but his output would slow down. The energy and drive, as well as the abundance of melody have made *Rigoletto* one of the top ten most-performed operas of all time.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526481982217/rig_1022p.jpg.jpg)
<figcaption>Lisette Oropesa (Gilda) in LA Opera's 2018 production of *Rigoletto*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>
 
*Rigoletto* is the story of a court jester who works for the Duke of Mantua, a man who is the embodiment of wealth, power and narcissism. A Don Giovanni-like character, the Duke believes he's entitled to take any woman he wants, even by force. Modern political parallels abound.
 
Verdi and his oft-used collaborator, librettist Francesco Maria Piave, had a problem getting past the censors almost 170 years ago, due to their depiction of the violent, hedonistic and amoral world of aristocrats. Human life has no value here. In fact, at one point the chorus says, "Hey, there’s Rigoletto - let's kill him!" They decide, instead, to play a cruel joke on the court jokester. Here in Mantua, fun can range from murder to just a prank, depending on the whim of the herd mentality.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526481951394/rig_2648p.jpg.jpg)
<figcaption>Juan Jesus Rodriguez (Rigoletto) in LA Opera's 2018 production of *Rigoletto*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

To protect his daughter from the Duke (and his entourage of like-minded cruel courtiers), Rigoletto hides her from the real world. She isn't allowed to venture outside, except to go to church. And that's where the Duke spies her and decides he must have her. There is an abundance of well-placed irony throughout the drama.

In Piave's libretto (based on a work by Victor Hugo), Rigoletto begins as a willing accomplice to his employer. When Monterone crashes the opening party at the Duke's palace to denounce the Duke for deflowering his daughter, Rigoletto leads the party-goers in the taunting and mocking. But a capricious kind of karma turns events on the jester, and he finds himself cursed by Monterone while the Duke gets off scot-free. Though Monterone is a small role, his curse and the repeat of the curse is what drives the action of the whole story and [Craig Colclough](/talking-with-singers-craig-colclough/) makes the most of his time on stage. The world of Mantua trembles with his bass-baritone.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526482006486/rig_2568p.jpg.jpg)
<figcaption>Morris Robinson (Sparafucile) in LA Opera's 2018 production of *Rigoletto*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

[Morris Robinson](/scene/people/morris-robinson/), making a career of star-turns in supporting roles (he was brilliant as Zaccaria this season in *Nabucco*) is nothing short of perfect as the assassin Sparafucile. [Ginger Costa-Jackson](/scene/people/ginger-costa-jackson/), making her LA Opera debut is a memorable Maddalena, and this reviewer is looking forward to hearing her in larger mezzo roles.

Arturo Chacon-Cruz as the Duke has a tough job playing one of the world's most iconic tenor roles, singing some of the most recognized music in opera history. ("La donne è mobile", etc.) There are a number of other performers who have done better with the role. He sings more in bursts and tends to cut himself off where there should be the fluidity we've come to expect in Verdi's music.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526482018924/rig_3170p.jpg.jpg)
<figcaption>Juan Jesus Rodriguez (Rigoletto) and Craig Colclough (Monterone) in LA Opera's 2018 production of *Rigoletto*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

Constance Hoffman's period costumes are superb and are literally "a stand-out" when framed by Michael Yeargan's modernist/minimalist set of archways. The sharply raked enterprise looks as if it will spill into the orchestra pit at any moment. It seems to be saying, "one misstep and down you go," which is exactly what happens to Rigoletto and Gilda.
 
The lighting from Robert Wierzel is as dark as the subject matter. In fact, Sparafucile is just an ominous shadow during his introductory scene; only his murderous hands make their way into the light. Oven-red lights pour out from between Mr. Yeargan's arches, symbolizing the passions and bloodletting inside, as if they were furnaces rather than buildings. He also uses a beautiful deep purple to enhance the inky black night where Rigoletto is blind to his daughter's abduction.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526482028177/rig_1994p.jpg.jpg)
<figcaption>Lisette Oropesa (Gilda) and Juan Jesus Rodriguez (Rigoletto) in LA Opera's 2018 production of *Rigoletto*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

Director Mark Lamos has brought some nice touches, but the opening number is frenetic, as if several three-ring circuses have joined forces. Too many elegant women parade and too many dancers twirl. Masked performers and revelers overindulge themselves. We don't know where to look. Luckily, Mr. Rodriguez takes the stage and the show finds some focus, and the show truly begins.
 
Mr. Lamos errs in the other direction as well, confining the second half of Act I to a small box on the enormous Dorothy Chandler Pavilion stage. The characters have almost nowhere to move, putting a restraint on some of the opera's most memorable musical moments.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526481940167/rig_1579p.jpg.jpg)
<figcaption>A scene in LA Opera's 2018 production of *Rigoletto*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

The best moment Mr. Lamos creates is during "Cortigiani, vil razza dannata!" as Rigoletto begs the courtiers for mercy. Here they remain absolutely still, covering their faces with expressionless masks representing their indifference. It's chilling. Another impressive idea was his show-within-a-show as some of the courtiers, now in outlandish Commedia dell'arte masks, recreate the abduction of Gilda for the delight of the Duke.
 
Conductor Matthew Aucoin is also a welcome new face (and baton) at LA Opera, and chorus master Grant Gershon leads an all-male chorus this time. The ever-glorious sopranos and altos are out of luck and out of work in this score.
 
[Performances continue May 16, 19, 27, 31 and June 3](https://www.laopera.org/season/1718-Season/rigoletto/). (Note: Mr. Rodriguez only appears in the 5/16 and 5/19 performances.)
